/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.pe.modmenu;

import com.google.common.collect.Sets;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Set;
import net.lopymine.pe.client.ParticleEffectsClient;
import net.lopymine.pe.utils.ModMenuUtils;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class NoConfigLibraryScreen {
    private static final Set<String> ALLOWED_PROTOCOLS = Sets.newHashSet((Object[])new String[]{"http", "https"});
    private static final String YACL_MODRINTH_LINK = "https://modrinth.com/mod/yacl/versions?l=fabric&g=";

    private NoConfigLibraryScreen() {
        throw new IllegalStateException("Screen class, use createScreen(...) method!");
    }

    @Contract(value="_ -> new")
    @NotNull
    public static Screen createScreen(Screen parent) {
        return new ConfirmScreen(open -> NoConfigLibraryScreen.onConfirm(open, parent), ModMenuUtils.getModTitle(), ModMenuUtils.getNoConfigScreenMessage(), CommonComponents.f_130657_, CommonComponents.f_130660_);
    }

    private static void onConfirm(boolean open, Screen parent) {
        if (open) {
            try {
                String url = YACL_MODRINTH_LINK + SharedConstants.m_183709_().m_132493_();
                URI link = new URI(url);
                String string = link.getScheme();
                if (string == null) {
                    throw new URISyntaxException(url, "Missing protocol");
                }
                if (!ALLOWED_PROTOCOLS.contains(string.toLowerCase(Locale.ROOT))) {
                    throw new URISyntaxException(url, "Unsupported protocol: " + string.toLowerCase(Locale.ROOT));
                }
                Util.m_137581_().m_137648_(link);
            }
            catch (URISyntaxException e) {
                ParticleEffectsClient.LOGGER.error("Can't open YACL Modrinth page:", (Throwable)e);
            }
        } else {
            Minecraft.m_91087_().m_91152_(parent);
        }
    }
}

