/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.pe.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import java.util.List;
import net.lopymine.pe.ParticleEffects;
import net.lopymine.pe.capture.ParticleCaptures;
import net.lopymine.pe.manager.ParticleEffectsManager;
import net.lopymine.pe.utils.ArgbUtils;
import net.lopymine.pe.utils.ListUtils;
import net.lopymine.pe.utils.PEType;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.FastColor;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Debug(export=true)
@Mixin(value={LevelRenderer.class})
public class WorldRendererMixin {
    @Shadow
    @Nullable
    private ClientLevel f_109465_;

    @Inject(method={"processWorldEvent"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/math/Vec3d;ofBottomCenter(Lnet/minecraft/util/math/Vec3i;)Lnet/minecraft/util/math/Vec3d;")})
    private void modifyParticleEffect(int eventId, BlockPos pos, int data, CallbackInfo ci, @Share(value="tp_effects") LocalRef<List<ParticleOptions>> localParticleEffects) {
        ParticleEffectsManager.processSplashPotionStageOne(localParticleEffects, data);
    }

    @WrapOperation(method={"processWorldEvent"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/render/WorldRenderer;spawnParticle(Lnet/minecraft/particle/ParticleEffect;ZDDDDDD)Lnet/minecraft/client/particle/Particle;", ordinal=0)})
    private Particle swapParticles(LevelRenderer instance, ParticleOptions parameters, boolean alwaysSpawn, double x, double y, double z, double velocityX, double velocityY, double velocityZ, Operation<Particle> original, @Share(value="tp_effects") LocalRef<List<ParticleOptions>> localParticleEffects, @Local(argsOnly=true, ordinal=1) int color) {
        return ParticleEffectsManager.processSplashPotionStageTwo((Level)this.f_109465_, parameters, particleEffect -> (Particle)original.call(new Object[]{instance, particleEffect, alwaysSpawn, x, y, z, velocityX, velocityY, velocityZ}), localParticleEffects, color);
    }

    @WrapOperation(method={"addParticle(Lnet/minecraft/particle/ParticleEffect;ZZDDDDDD)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/render/WorldRenderer;spawnParticle(Lnet/minecraft/particle/ParticleEffect;ZZDDDDDD)Lnet/minecraft/client/particle/Particle;")})
    private Particle swapParticle(LevelRenderer instance, ParticleOptions parameters, boolean alwaysSpawn, boolean canSpawnOnMinimal, double x, double y, double z, double velocityX, double velocityY, double velocityZ, Operation<Particle> original) {
        if (!ParticleEffects.getConfig().isModEnabled() || ParticleCaptures.getParticle() != parameters) {
            return (Particle)original.call(new Object[]{instance, parameters, alwaysSpawn, canSpawnOnMinimal, x, y, z, velocityX, velocityY, velocityZ});
        }
        boolean bl = parameters.equals((Object)ParticleTypes.f_123811_);
        boolean bl2 = parameters.equals((Object)ParticleTypes.f_123770_);
        if (!bl && !bl2) {
            return (Particle)original.call(new Object[]{instance, parameters, alwaysSpawn, canSpawnOnMinimal, x, y, z, velocityX, velocityY, velocityZ});
        }
        int color = FastColor.ARGB32.m_13660_((int)(bl2 ? 38 : 255), (int)((int)(velocityX * 255.0)), (int)((int)(velocityY * 255.0)), (int)((int)(velocityZ * 255.0)));
        List<ParticleOptions> list = ParticleEffectsManager.getParticleEffects(ArgbUtils.getColorWithoutAlpha(color));
        if (list == null || this.f_109465_ == null) {
            return (Particle)original.call(new Object[]{instance, parameters, alwaysSpawn, canSpawnOnMinimal, x, y, z, velocityX, velocityY, velocityZ});
        }
        ParticleOptions particleEffect = ListUtils.getRandomElement(list, this.f_109465_.m_213780_());
        if (particleEffect == null) {
            return (Particle)original.call(new Object[]{instance, parameters, alwaysSpawn, canSpawnOnMinimal, x, y, z, velocityX, velocityY, velocityZ});
        }
        ((PEType)particleEffect).particleEffects$setColor(color);
        return (Particle)original.call(new Object[]{instance, particleEffect, alwaysSpawn, canSpawnOnMinimal, x, y, z, velocityX, velocityY, velocityZ});
    }
}

