/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.pe.manager;

import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.fabricmc.fabric.api.particle.v1.FabricParticleTypes;
import net.lopymine.pe.ParticleEffects;
import net.lopymine.pe.capture.ParticleCaptures;
import net.lopymine.pe.client.ParticleEffectsClient;
import net.lopymine.pe.particle.TexturedParticleFactory;
import net.lopymine.pe.utils.ArgbUtils;
import net.lopymine.pe.utils.ListUtils;
import net.lopymine.pe.utils.PEStatusEffect;
import net.lopymine.pe.utils.PEType;
import net.lopymine.pe.utils.StatusEffectUtils;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ParticleEffectsManager {
    private static final List<ParticleOptions> REGISTERED_PARTICLE_TYPES = new ArrayList<ParticleOptions>();
    private static final Map<Integer, List<ParticleOptions>> COLOR_TO_PARTICLES_MAP = new HashMap<Integer, List<ParticleOptions>>();
    private static final HashMap<ParticleOptions, MobEffect> MINECRAFT_EFFECTS_WITH_TEXTURED_PARTICLE = ParticleEffectsManager.getMinecraftEffectWidthTexturedParticles();

    @Nullable
    public static List<ParticleOptions> getParticleEffects(Integer i) {
        return COLOR_TO_PARTICLES_MAP.get(i);
    }

    private static ParticleOptions registerParticleTypeForEffect(MobEffect statusEffect, ResourceLocation effectId) {
        ParticleOptions type = (ParticleOptions)Registry.m_122965_((Registry)BuiltInRegistries.f_257034_, (ResourceLocation)ParticleEffectsManager.getModEffectId(statusEffect, effectId), (Object)FabricParticleTypes.simple());
        REGISTERED_PARTICLE_TYPES.add(type);
        return type;
    }

    private static ResourceLocation getModEffectId(MobEffect statusEffect, ResourceLocation effectId) {
        boolean bl = MINECRAFT_EFFECTS_WITH_TEXTURED_PARTICLE.containsValue(statusEffect);
        return ParticleEffects.id(effectId.m_135815_() + (bl ? "_new" : ""));
    }

    public static void onInitialize() {
        ResourceLocation id;
        MobEffect statusEffect;
        for (Holder.Reference reference : BuiltInRegistries.f_256974_.m_203611_().toList()) {
            statusEffect = (MobEffect)reference.m_203334_();
            id = reference.m_205785_().m_135782_();
            if (!id.m_135827_().equals("minecraft")) continue;
            ParticleOptions type = ParticleEffectsManager.registerParticleTypeForEffect(statusEffect, id);
            StatusEffectUtils.swapParticle(statusEffect, type);
        }
        for (Holder.Reference reference : BuiltInRegistries.f_256980_.m_203611_().toList()) {
            Potion potion = (Potion)reference.m_203334_();
            id = reference.m_205785_().m_135782_();
            if (!id.m_135827_().equals("minecraft")) continue;
            List effects = potion.m_43488_();
            int color = ArgbUtils.getColorWithoutAlpha(StatusEffectUtils.getColor(effects));
            List particleEffects = effects.stream().map(MobEffectInstance::m_19544_).flatMap(effect -> {
                ParticleOptions particleEffect = ((PEStatusEffect)effect).particleEffects$getParticleEffect();
                if (particleEffect == null) {
                    ParticleEffectsClient.LOGGER.error("[DEV/Potion Registration] Looks like {} effect (from potion with color {}) doesn't have textured particle, this shouldn't happen! Skipping it registration.", (Object)color, (Object)effect.m_19482_().getString());
                    return Stream.empty();
                }
                return Stream.of(particleEffect);
            }).toList();
            COLOR_TO_PARTICLES_MAP.put(color, particleEffects);
        }
        for (Holder.Reference reference : BuiltInRegistries.f_256974_.m_203611_().toList()) {
            statusEffect = (MobEffect)reference.m_203334_();
            id = reference.m_205785_().m_135782_();
            if (!id.m_135827_().equals("minecraft")) continue;
            int color = ArgbUtils.getColorWithoutAlpha(statusEffect.m_19484_());
            ParticleOptions particleEffect = ((PEStatusEffect)statusEffect).particleEffects$getParticleEffect();
            if (particleEffect == null) {
                ParticleEffects.LOGGER.error("[DEV/Effect Registration] Looks like {} effect with color {} doesn't have textured particle, this shouldn't happen! Skipping it registration.", (Object)color, (Object)statusEffect.m_19482_().getString());
                continue;
            }
            List<ParticleOptions> effects = COLOR_TO_PARTICLES_MAP.get(color);
            if (effects != null) {
                if (!ParticleEffects.getConfig().isDebugLogEnabled()) continue;
                ParticleEffects.LOGGER.warn("[DEV/Effect Registration] Found registered effects for color {} from {} effect, skipping it registration. If you just mod user, ignore it.", (Object)color, (Object)statusEffect.m_19482_().getString());
                continue;
            }
            COLOR_TO_PARTICLES_MAP.put(color, List.of(particleEffect));
        }
    }

    public static void onInitializeClient() {
        for (ParticleOptions type : REGISTERED_PARTICLE_TYPES) {
            ParticleFactoryRegistry.getInstance().register((ParticleType)((SimpleParticleType)type), TexturedParticleFactory::new);
        }
    }

    private static HashMap<ParticleOptions, MobEffect> getMinecraftEffectWidthTexturedParticles() {
        return new HashMap<ParticleOptions, MobEffect>();
    }

    public static MobEffect getVanillaStatusEffectByStatusEffect(ParticleOptions parameters) {
        return MINECRAFT_EFFECTS_WITH_TEXTURED_PARTICLE.get(parameters);
    }

    public static void processSplashPotionStageOne(LocalRef<List<ParticleOptions>> localParticleEffects, int color) {
        localParticleEffects.set(null);
        if (!ParticleEffects.getConfig().isModEnabled()) {
            return;
        }
        List<ParticleOptions> list = ParticleEffectsManager.getParticleEffects(ArgbUtils.getColorWithoutAlpha(color));
        if (list == null) {
            return;
        }
        localParticleEffects.set(list);
    }

    public static Particle processSplashPotionStageTwo(@Nullable Level world, ParticleOptions original, Function<ParticleOptions, Particle> function, LocalRef<List<ParticleOptions>> localParticleEffects, int color) {
        if (!ParticleEffects.getConfig().isModEnabled()) {
            return function.apply(original);
        }
        List list = (List)localParticleEffects.get();
        if (list == null || world == null) {
            return function.apply(original);
        }
        ParticleOptions particleEffect = (ParticleOptions)ListUtils.getRandomElement(list, world.m_213780_());
        if (particleEffect == null) {
            return function.apply(original);
        }
        ((PEType)particleEffect).particleEffects$setColor(-1);
        ParticleCaptures.setParticle(particleEffect);
        Particle apply = function.apply(particleEffect);
        ParticleCaptures.setParticle(null);
        return apply;
    }
}

