/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.pe.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.loader.api.FabricLoader;
import net.lopymine.pe.ParticleEffects;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParticleEffectsConfig {
    public static final Codec<ParticleEffectsConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("mod_enabled").forGetter(ParticleEffectsConfig::isModEnabled), (App)Codec.BOOL.optionalFieldOf("debug_log", (Object)false).forGetter(ParticleEffectsConfig::isDebugLogEnabled)).apply((Applicative)instance, ParticleEffectsConfig::new));
    private static final File CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("particle-effects.json5").toFile();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Particle Effects/Config");
    private boolean modEnabled;
    private boolean debugLogEnabled;

    public ParticleEffectsConfig() {
        this.modEnabled = true;
        this.debugLogEnabled = false;
    }

    public static ParticleEffectsConfig getInstance() {
        return ParticleEffectsConfig.read();
    }

    @NotNull
    private static ParticleEffectsConfig create() {
        ParticleEffectsConfig config = new ParticleEffectsConfig();
        try (FileWriter writer = new FileWriter(CONFIG_FILE, StandardCharsets.UTF_8);){
            String json = GSON.toJson((JsonElement)CODEC.encode((Object)config, (DynamicOps)JsonOps.INSTANCE, (Object)JsonOps.INSTANCE.empty()).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0)));
            writer.write(json);
        }
        catch (Exception e) {
            LOGGER.error("Failed to create config", (Throwable)e);
        }
        return config;
    }

    private static ParticleEffectsConfig read() {
        ParticleEffectsConfig particleEffectsConfig;
        if (!CONFIG_FILE.exists()) {
            return ParticleEffectsConfig.create();
        }
        FileReader reader = new FileReader(CONFIG_FILE, StandardCharsets.UTF_8);
        try {
            particleEffectsConfig = (ParticleEffectsConfig)((Pair)CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)reader)).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0))).getFirst();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                LOGGER.error("Failed to read config", (Throwable)e);
                return ParticleEffectsConfig.create();
            }
        }
        reader.close();
        return particleEffectsConfig;
    }

    public void save() {
        ParticleEffects.setConfig(this);
        CompletableFuture.runAsync(() -> {
            try (FileWriter writer = new FileWriter(CONFIG_FILE, StandardCharsets.UTF_8);){
                String json = GSON.toJson((JsonElement)CODEC.encode((Object)this, (DynamicOps)JsonOps.INSTANCE, (Object)JsonOps.INSTANCE.empty()).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0)));
                writer.write(json);
            }
            catch (Exception e) {
                LOGGER.error("Failed to save config", (Throwable)e);
            }
        });
    }

    public boolean isModEnabled() {
        return this.modEnabled;
    }

    public boolean isDebugLogEnabled() {
        return this.debugLogEnabled;
    }

    public void setModEnabled(boolean modEnabled) {
        this.modEnabled = modEnabled;
    }

    public void setDebugLogEnabled(boolean debugLogEnabled) {
        this.debugLogEnabled = debugLogEnabled;
    }

    public ParticleEffectsConfig(boolean modEnabled, boolean debugLogEnabled) {
        this.modEnabled = modEnabled;
        this.debugLogEnabled = debugLogEnabled;
    }
}

