/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.utils;

import de.ambertation.wunderlib.WunderLib;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;

public class Version {
    public final String version;

    public Version(String version) {
        if ("${version}".equals(version)) {
            version = "0.0.0";
        }
        this.version = version;
    }

    public Version(int major, int minor, int patch) {
        this(String.format(Locale.ROOT, "%d.%d.%d", major, minor, patch));
    }

    private static int toInt(String version) {
        if (version == null || version.isEmpty()) {
            return 0;
        }
        try {
            String semanticVersionPattern = "(\\d+)\\.(\\d+)(\\.(\\d+))?\\D*";
            Matcher matcher = Pattern.compile("(\\d+)\\.(\\d+)(\\.(\\d+))?\\D*").matcher(version);
            int major = 0;
            int minor = 0;
            int patch = 0;
            if (matcher.find()) {
                if (matcher.groupCount() > 0) {
                    int n = major = matcher.group(1) == null ? 0 : Integer.parseInt(matcher.group(1));
                }
                if (matcher.groupCount() > 1) {
                    int n = minor = matcher.group(2) == null ? 0 : Integer.parseInt(matcher.group(2));
                }
                if (matcher.groupCount() > 3) {
                    patch = matcher.group(4) == null ? 0 : Integer.parseInt(matcher.group(4));
                }
            }
            return FastColor.ARGB32.m_13660_((int)0, (int)major, (int)minor, (int)patch);
        }
        catch (Exception e) {
            WunderLib.LOGGER.error("Failed to parse Version '" + version + "'.");
            return 0;
        }
    }

    public static int major(int version) {
        return FastColor.ARGB32.m_13665_((int)version);
    }

    public static int minor(int version) {
        return FastColor.ARGB32.m_13667_((int)version);
    }

    public static int patch(int version) {
        return FastColor.ARGB32.m_13669_((int)version);
    }

    public static Version fromInt(int version) {
        return new Version(Version.major(version), Version.minor(version), Version.patch(version));
    }

    public int toInt() {
        return Version.toInt(this.version);
    }

    public boolean isLargerThan(Version v2) {
        return this.toInt() > v2.toInt();
    }

    public boolean isLargerOrEqualVersion(Version v2) {
        return this.toInt() >= v2.toInt();
    }

    public boolean isLargerThan(String v2) {
        return this.toInt() > Version.toInt(v2);
    }

    public boolean isLargerOrEqualVersion(String v2) {
        return this.toInt() >= Version.toInt(v2);
    }

    public boolean isLessThan(Version v2) {
        return this.toInt() < v2.toInt();
    }

    public boolean isLessOrEqualVersion(Version v2) {
        return this.toInt() <= v2.toInt();
    }

    public boolean isLessThan(String v2) {
        return this.toInt() < Version.toInt(v2);
    }

    public boolean isLessOrEqualVersion(String v2) {
        return this.toInt() <= Version.toInt(v2);
    }

    public String toString() {
        return this.version;
    }

    public static interface ModVersionProvider {
        public Version getModVersion();

        public String getModID();

        default public ResourceLocation mk(String key) {
            return new ResourceLocation(this.getModID(), key);
        }
    }
}

