/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.ui.vanilla;

import de.ambertation.wunderlib.ui.ColorHelper;
import de.ambertation.wunderlib.ui.layout.components.HorizontalStack;
import de.ambertation.wunderlib.ui.layout.components.LayoutComponent;
import de.ambertation.wunderlib.ui.layout.components.Panel;
import de.ambertation.wunderlib.ui.layout.components.Text;
import de.ambertation.wunderlib.ui.layout.components.VerticalStack;
import de.ambertation.wunderlib.ui.layout.values.Value;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public abstract class LayoutScreen
extends Screen {
    protected final int topPadding;
    protected final int bottomPadding;
    protected final int sidePadding;
    protected final int titleSpacing;
    @Nullable
    protected Panel main;
    @Nullable
    public final Screen parent;

    public LayoutScreen(Component component) {
        this(null, component, 20, 10, 20, 15);
    }

    public LayoutScreen(@Nullable Screen parent, Component component) {
        this(parent, component, 20, 10, 20, 15);
    }

    public LayoutScreen(@Nullable Screen parent, Component component, int topPadding, int bottomPadding, int sidePadding) {
        this(parent, component, topPadding, bottomPadding, sidePadding, 15);
    }

    public LayoutScreen(@Nullable Screen parent, Component component, int topPadding, int bottomPadding, int sidePadding, int titleSpacing) {
        super(component);
        this.parent = parent;
        this.topPadding = topPadding;
        this.bottomPadding = topPadding;
        this.sidePadding = sidePadding;
        this.titleSpacing = titleSpacing;
    }

    protected abstract LayoutComponent<?, ?> initContent();

    protected void openLink(String uri) {
        ConfirmLinkScreen cls = new ConfirmLinkScreen(bl -> {
            if (bl) {
                Util.m_137581_().m_137646_(uri);
            }
            this.f_96541_.m_91152_((Screen)this);
        }, uri, true);
        Minecraft.m_91087_().m_91152_((Screen)cls);
    }

    protected final void m_7856_() {
        super.m_7856_();
        this.main = new Panel(this.f_96543_, this.f_96544_);
        this.main.setChild(this.createScreen(this.initContent()));
        this.main.calculateLayout();
        this.m_142416_((GuiEventListener)this.main);
    }

    protected LayoutComponent<?, ?> createTitle() {
        Text text = (Text)((Text)new Text(LayoutScreen.fit(), LayoutScreen.fit(), this.f_96539_).centerHorizontal()).setColor(ColorHelper.WHITE).setDebugName("title");
        return text;
    }

    protected LayoutComponent<?, ?> createScreen(LayoutComponent<?, ?> content) {
        VerticalStack rows = (VerticalStack)new VerticalStack(LayoutScreen.fill(), LayoutScreen.fill()).setDebugName("title stack");
        if (this.topPadding > 0) {
            rows.addSpacer(this.topPadding);
        }
        rows.add((LayoutComponent)this.createTitle());
        rows.addSpacer(this.titleSpacing);
        rows.add((LayoutComponent)content);
        if (this.bottomPadding > 0) {
            rows.addSpacer(this.bottomPadding);
        }
        if (this.sidePadding <= 0) {
            return rows;
        }
        HorizontalStack cols = (HorizontalStack)new HorizontalStack(LayoutScreen.fill(), LayoutScreen.fill()).setDebugName("padded side");
        cols.addSpacer(this.sidePadding);
        cols.add((LayoutComponent)rows);
        cols.addSpacer(this.sidePadding);
        return cols;
    }

    protected void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        this.m_280039_(guiGraphics);
    }

    public void m_88315_(GuiGraphics guiGraphics, int i, int j, float f) {
        this.renderBackground(guiGraphics, i, j, f);
        super.m_88315_(guiGraphics, i, j, f);
    }

    protected final void closeScreen() {
        this.m_7379_();
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parent);
    }

    public boolean m_7043_() {
        return true;
    }

    public static Value fit() {
        return Value.fit();
    }

    public static Value fitOrFill() {
        return Value.fitOrFill();
    }

    public static Value fill() {
        return Value.fill();
    }

    public static Value fixed(int size) {
        return Value.fixed(size);
    }

    public static Value relative(double percentage) {
        return Value.relative(percentage);
    }

    public static MutableComponent translatable(String key) {
        return Component.m_237115_((String)key);
    }

    public static MutableComponent literal(String content) {
        return Component.m_237113_((String)content);
    }
}

