/*
 * Decompiled with CFR 0.152.
 */
package net.nathanthecraziest.spawnersplus.util;

import net.fabricmc.fabric.api.loot.v2.FabricLootTableBuilder;
import net.fabricmc.fabric.api.loot.v2.LootTableEvents;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.EntityEquipmentPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.nathanthecraziest.spawnersplus.config.SpawnersPlusConfig;
import net.nathanthecraziest.spawnersplus.items.ModEnchantments;
import net.nathanthecraziest.spawnersplus.items.ModItems;

public class ModLootTableModifiers {
    public static final ResourceLocation ZOMBIE_ID = EntityType.f_20501_.m_20677_();
    public static final ResourceLocation SKELETON_ID = EntityType.f_20524_.m_20677_();
    public static final ResourceLocation SPIDER_ID = EntityType.f_20479_.m_20677_();
    public static final ResourceLocation CAVE_SPIDER_ID = EntityType.f_20554_.m_20677_();
    public static final ResourceLocation BLAZE_ID = EntityType.f_20551_.m_20677_();
    public static final ResourceLocation MAGMA_CUBE_ID = EntityType.f_20468_.m_20677_();
    public static final ResourceLocation STRAY_ID = EntityType.f_20481_.m_20677_();
    public static final ResourceLocation WITHER_SKELETON_ID = EntityType.f_20497_.m_20677_();
    public static final ResourceLocation HUSK_ID = EntityType.f_20458_.m_20677_();
    public static final ResourceLocation DROWNED_ID = EntityType.f_20562_.m_20677_();
    public static final ResourceLocation CREEPER_ID = EntityType.f_20558_.m_20677_();

    public static void modifyLootTables() {
        LootTableEvents.MODIFY.register((resourceManager, lootManager, id, tableBuilder, source) -> {
            if (source.isBuiltin() && ZOMBIE_ID.equals((Object)id)) {
                ModLootTableModifiers.addMobSoulDrop(ModItems.ZOMBIE_SOUL, ModLootTableModifiers.getConfigDropRate("zombie"), (FabricLootTableBuilder)tableBuilder);
            }
            if (source.isBuiltin() && SKELETON_ID.equals((Object)id)) {
                ModLootTableModifiers.addMobSoulDrop(ModItems.SKELETON_SOUL, ModLootTableModifiers.getConfigDropRate("skeleton"), (FabricLootTableBuilder)tableBuilder);
            }
            if (source.isBuiltin() && SPIDER_ID.equals((Object)id)) {
                ModLootTableModifiers.addMobSoulDrop(ModItems.SPIDER_SOUL, ModLootTableModifiers.getConfigDropRate("spider"), (FabricLootTableBuilder)tableBuilder);
            }
            if (source.isBuiltin() && CAVE_SPIDER_ID.equals((Object)id)) {
                ModLootTableModifiers.addMobSoulDrop(ModItems.CAVE_SPIDER_SOUL, ModLootTableModifiers.getConfigDropRate("cave_spider"), (FabricLootTableBuilder)tableBuilder);
            }
            if (source.isBuiltin() && BLAZE_ID.equals((Object)id)) {
                ModLootTableModifiers.addMobSoulDrop(ModItems.BLAZE_SOUL, ModLootTableModifiers.getConfigDropRate("blaze"), (FabricLootTableBuilder)tableBuilder);
            }
            if (source.isBuiltin() && MAGMA_CUBE_ID.equals((Object)id)) {
                ModLootTableModifiers.addMobSoulDrop(ModItems.MAGMA_CUBE_SOUL, ModLootTableModifiers.getConfigDropRate("magma_cube"), (FabricLootTableBuilder)tableBuilder);
            }
            if (source.isBuiltin() && STRAY_ID.equals((Object)id)) {
                ModLootTableModifiers.addMobSoulDrop(ModItems.STRAY_SOUL, ModLootTableModifiers.getConfigDropRate("stray"), (FabricLootTableBuilder)tableBuilder);
            }
            if (source.isBuiltin() && WITHER_SKELETON_ID.equals((Object)id)) {
                ModLootTableModifiers.addMobSoulDrop(ModItems.WITHER_SKELETON_SOUL, ModLootTableModifiers.getConfigDropRate("wither_skeleton"), (FabricLootTableBuilder)tableBuilder);
            }
            if (source.isBuiltin() && HUSK_ID.equals((Object)id)) {
                ModLootTableModifiers.addMobSoulDrop(ModItems.HUSK_SOUL, ModLootTableModifiers.getConfigDropRate("husk"), (FabricLootTableBuilder)tableBuilder);
            }
            if (source.isBuiltin() && DROWNED_ID.equals((Object)id)) {
                ModLootTableModifiers.addMobSoulDrop(ModItems.DROWNED_SOUL, ModLootTableModifiers.getConfigDropRate("drowned"), (FabricLootTableBuilder)tableBuilder);
            }
            if (source.isBuiltin() && CREEPER_ID.equals((Object)id)) {
                ModLootTableModifiers.addMobSoulDrop(ModItems.CREEPER_SOUL, ModLootTableModifiers.getConfigDropRate("creeper"), (FabricLootTableBuilder)tableBuilder);
            }
        });
    }

    public static void addMobSoulDrop(Item soulItem, float soulDropChance, FabricLootTableBuilder tableBuilder) {
        if (soulDropChance > 0.0f) {
            LootPool.Builder poolBuilder = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemRandomChanceCondition.m_81927_((float)soulDropChance)).m_79080_(LootItemEntityPropertyCondition.m_81867_((LootContext.EntityTarget)LootContext.EntityTarget.KILLER, (EntityPredicate)new EntityPredicate.Builder().m_36640_(EntityEquipmentPredicate.Builder.m_32204_().m_149928_(ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(ModEnchantments.SOUL_STEALING, MinMaxBounds.Ints.f_55364_)).m_45077_()).m_32207_()).m_36662_())).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)soulItem)).apply(SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)1.0f)).m_7453_());
            tableBuilder.pool(poolBuilder.m_79082_());
        }
    }

    public static float getConfigDropRate(String key) {
        float rate = SpawnersPlusConfig.getFloatValue(key + "_soul");
        if (rate <= 1.0f) {
            return rate;
        }
        return 1.0f;
    }
}

