/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.structures.piece;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.noise.OpenSimplexNoise;
import org.betterx.betternether.registry.NetherStructurePieces;
import org.betterx.betternether.world.structures.piece.CustomPiece;

public class CavePiece
extends CustomPiece {
    private static final BlockState LAVA = Blocks.f_49991_.m_49966_();
    private static final OpenSimplexNoise NOISE = new OpenSimplexNoise(927649L);
    private final BlockPos center;
    private final int radius;
    private final int radSqr;

    public CavePiece(BlockPos center, int radius, RandomSource random, BoundingBox blockBox) {
        super(NetherStructurePieces.CAVE_PIECE, random.m_188502_(), CavePiece.makeBoundingBox(center, radius));
        this.center = center.m_7949_();
        this.radius = radius;
        this.radSqr = radius * radius;
    }

    public CavePiece(StructurePieceSerializationContext context, CompoundTag tag) {
        super(NetherStructurePieces.CAVE_PIECE, tag);
        this.center = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("center"));
        this.radius = tag.m_128451_("radius");
        this.radSqr = this.radius * this.radius;
    }

    protected void m_183620_(StructurePieceSerializationContext structurePieceSerializationContext, CompoundTag tag) {
        tag.m_128365_("center", (Tag)NbtUtils.m_129224_((BlockPos)this.center));
        tag.m_128405_("radius", this.radius);
    }

    public void m_213694_(WorldGenLevel world, StructureManager arg, ChunkGenerator chunkGenerator, RandomSource random, BoundingBox blockBox, ChunkPos chunkPos, BlockPos blockPos) {
        BlockPos.MutableBlockPos POS = new BlockPos.MutableBlockPos();
        BlockState bottom = LAVA;
        if (!world.m_6042_().f_63856_()) {
            bottom = Blocks.f_50134_.m_49966_();
        }
        for (int x = blockBox.m_162395_(); x <= blockBox.m_162399_(); ++x) {
            int px = x - this.center.m_123341_();
            px *= px;
            for (int z = blockBox.m_162398_(); z <= blockBox.m_162401_(); ++z) {
                int pz = z - this.center.m_123343_();
                pz *= pz;
                for (int y = blockBox.m_162396_(); y <= blockBox.m_162400_(); ++y) {
                    int py = y - this.center.m_123342_() << 1;
                    if (!((double)(px + (py *= py) + pz) <= (double)this.radSqr + NOISE.eval((double)x * 0.1, (double)y * 0.1, (double)z * 0.1) * 800.0)) continue;
                    POS.m_122178_(x, y, z);
                    if (y > 31) {
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)POS, f_73382_);
                        continue;
                    }
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)POS, bottom);
                }
            }
        }
    }

    private static BoundingBox makeBoundingBox(BlockPos center, int radius) {
        int x1 = center.m_123341_() - radius;
        int x2 = center.m_123341_() + radius;
        int minY = Math.max(22, center.m_123342_() - radius);
        int maxY = Math.min(96, center.m_123342_() + radius);
        int z1 = center.m_123343_() - radius;
        int z2 = center.m_123343_() + radius;
        return new BoundingBox(x1, minY, z1, x2, maxY, z2);
    }
}

