/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.structures.city.palette;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import org.betterx.betternether.blocks.BNBlockProperties;
import org.betterx.betternether.blocks.BlockPottedPlant;
import org.betterx.betternether.blocks.BlockSmallLantern;
import org.betterx.betternether.registry.NetherBlocks;

public class CityPalette {
    private static final RandomSource RANDOM = new LegacyRandomSource(130520220057L);
    private final String name;
    private final List<Block> foundationBlocks = new ArrayList<Block>();
    private final List<Block> foundationSlabs = new ArrayList<Block>();
    private final List<Block> foundationStairs = new ArrayList<Block>();
    private final List<Block> foundationWalls = new ArrayList<Block>();
    private final List<Block> roofBlocks = new ArrayList<Block>();
    private final List<Block> roofSlabs = new ArrayList<Block>();
    private final List<Block> roofStairs = new ArrayList<Block>();
    private final List<Block> planksBlocks = new ArrayList<Block>();
    private final List<Block> planksSlabs = new ArrayList<Block>();
    private final List<Block> planksStairs = new ArrayList<Block>();
    private final List<Block> fences = new ArrayList<Block>();
    private final List<Block> walls = new ArrayList<Block>();
    private final List<Block> gates = new ArrayList<Block>();
    private final List<Block> logs = new ArrayList<Block>();
    private final List<Block> bark = new ArrayList<Block>();
    private final List<Block> stoneBlocks = new ArrayList<Block>();
    private final List<Block> stoneSlabs = new ArrayList<Block>();
    private final List<Block> stoneStairs = new ArrayList<Block>();
    private final List<Block> glowingBlocks = new ArrayList<Block>();
    private final List<Block> wallLights = new ArrayList<Block>();
    private final List<Block> ceilingLights = new ArrayList<Block>();
    private final List<Block> floorLights = new ArrayList<Block>();
    private final List<Block> doors = new ArrayList<Block>();
    private final List<Block> trapdoors = new ArrayList<Block>();
    private final List<Block> platesStone = new ArrayList<Block>();
    private final List<Block> platesWood = new ArrayList<Block>();
    private final List<Block> glassBlocks = new ArrayList<Block>();
    private final List<Block> glassPanes = new ArrayList<Block>();
    private final List<Block> pots = new ArrayList<Block>();

    public CityPalette(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    private CityPalette putBlocks(Block[] blocks, List<Block> list) {
        for (Block b : blocks) {
            list.add(b);
        }
        return this;
    }

    public CityPalette addFoundationBlocks(Block ... blocks) {
        return this.putBlocks(blocks, this.foundationBlocks);
    }

    public CityPalette addFoundationSlabs(Block ... blocks) {
        return this.putBlocks(blocks, this.foundationSlabs);
    }

    public CityPalette addFoundationStairs(Block ... blocks) {
        return this.putBlocks(blocks, this.foundationStairs);
    }

    public CityPalette addFoundationWalls(Block ... blocks) {
        return this.putBlocks(blocks, this.foundationWalls);
    }

    public CityPalette addRoofBlocks(Block ... blocks) {
        return this.putBlocks(blocks, this.roofBlocks);
    }

    public CityPalette addRoofSlabs(Block ... blocks) {
        return this.putBlocks(blocks, this.roofSlabs);
    }

    public CityPalette addRoofStairs(Block ... blocks) {
        return this.putBlocks(blocks, this.roofStairs);
    }

    public CityPalette addPlanksBlocks(Block ... blocks) {
        return this.putBlocks(blocks, this.planksBlocks);
    }

    public CityPalette addPlanksSlabs(Block ... blocks) {
        return this.putBlocks(blocks, this.planksSlabs);
    }

    public CityPalette addPlanksStairs(Block ... blocks) {
        return this.putBlocks(blocks, this.planksStairs);
    }

    public CityPalette addFences(Block ... blocks) {
        return this.putBlocks(blocks, this.fences);
    }

    public CityPalette addWalls(Block ... blocks) {
        return this.putBlocks(blocks, this.walls);
    }

    public CityPalette addGates(Block ... blocks) {
        return this.putBlocks(blocks, this.gates);
    }

    public CityPalette addLogs(Block ... blocks) {
        return this.putBlocks(blocks, this.logs);
    }

    public CityPalette addBark(Block ... blocks) {
        return this.putBlocks(blocks, this.bark);
    }

    public CityPalette addStoneBlocks(Block ... blocks) {
        return this.putBlocks(blocks, this.stoneBlocks);
    }

    public CityPalette addStoneSlabs(Block ... blocks) {
        return this.putBlocks(blocks, this.stoneSlabs);
    }

    public CityPalette addStoneStairs(Block ... blocks) {
        return this.putBlocks(blocks, this.stoneStairs);
    }

    public CityPalette addGlowingBlocks(Block ... blocks) {
        return this.putBlocks(blocks, this.glowingBlocks);
    }

    public CityPalette addWallLights(Block ... blocks) {
        return this.putBlocks(blocks, this.wallLights);
    }

    public CityPalette addCeilingLights(Block ... blocks) {
        return this.putBlocks(blocks, this.ceilingLights);
    }

    public CityPalette addFloorLights(Block ... blocks) {
        return this.putBlocks(blocks, this.floorLights);
    }

    public CityPalette addDoors(Block ... blocks) {
        return this.putBlocks(blocks, this.doors);
    }

    public CityPalette addTrapdoors(Block ... blocks) {
        return this.putBlocks(blocks, this.trapdoors);
    }

    public CityPalette addStonePlates(Block ... blocks) {
        return this.putBlocks(blocks, this.platesStone);
    }

    public CityPalette addWoodPlates(Block ... blocks) {
        return this.putBlocks(blocks, this.platesWood);
    }

    public CityPalette addGlassBlocks(Block ... blocks) {
        return this.putBlocks(blocks, this.glassBlocks);
    }

    public CityPalette addGlassPanes(Block ... blocks) {
        return this.putBlocks(blocks, this.glassPanes);
    }

    public CityPalette addPotsPanes(Block ... blocks) {
        return this.putBlocks(blocks, this.pots);
    }

    private Block getRandomBlock(BlockState state, List<Block> list) {
        if (list.isEmpty()) {
            return state.m_60734_();
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        String seed = BuiltInRegistries.f_256975_.m_7981_((Object)state.m_60734_()).m_135815_();
        RANDOM.m_188584_((long)seed.hashCode());
        return list.get(RANDOM.m_188503_(list.size()));
    }

    private BlockState getFullState(BlockState input, List<Block> list) {
        if (list.isEmpty()) {
            return input;
        }
        if (list.size() == 1) {
            return list.get(0).m_49966_();
        }
        return this.getRandomBlock(input, list).m_49966_();
    }

    private BlockState getSlabState(BlockState input, List<Block> list) {
        if (list.isEmpty()) {
            return input;
        }
        if (list.size() == 1) {
            return this.copySlab(input, list.get(0));
        }
        return this.copySlab(input, this.getRandomBlock(input, list));
    }

    private BlockState getStairState(BlockState input, List<Block> list) {
        if (list.isEmpty()) {
            return input;
        }
        if (list.size() == 1) {
            return this.copyStair(input, list.get(0));
        }
        return this.copyStair(input, this.getRandomBlock(input, list));
    }

    private BlockState copySlab(BlockState source, Block block) {
        BlockState state = (BlockState)((BlockState)block.m_49966_().m_61124_((Property)SlabBlock.f_56353_, (Comparable)((SlabType)source.m_61143_((Property)SlabBlock.f_56353_)))).m_61124_((Property)SlabBlock.f_56354_, (Comparable)((Boolean)source.m_61143_((Property)SlabBlock.f_56354_)));
        return state;
    }

    private BlockState copyStair(BlockState source, Block block) {
        BlockState state = (BlockState)((BlockState)((BlockState)((BlockState)block.m_49966_().m_61124_((Property)StairBlock.f_56841_, (Comparable)((Direction)source.m_61143_((Property)StairBlock.f_56841_)))).m_61124_((Property)StairBlock.f_56842_, (Comparable)((Half)source.m_61143_((Property)StairBlock.f_56842_)))).m_61124_((Property)StairBlock.f_56843_, (Comparable)((StairsShape)source.m_61143_((Property)StairBlock.f_56843_)))).m_61124_((Property)StairBlock.f_56844_, (Comparable)((Boolean)source.m_61143_((Property)StairBlock.f_56844_)));
        return state;
    }

    private BlockState copyWall(BlockState source, Block block) {
        BlockState state = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)block.m_49966_().m_61124_((Property)WallBlock.f_57950_, (Comparable)((WallSide)source.m_61143_((Property)WallBlock.f_57950_)))).m_61124_((Property)WallBlock.f_57951_, (Comparable)((WallSide)source.m_61143_((Property)WallBlock.f_57951_)))).m_61124_((Property)WallBlock.f_57952_, (Comparable)((WallSide)source.m_61143_((Property)WallBlock.f_57952_)))).m_61124_((Property)WallBlock.f_57953_, (Comparable)((WallSide)source.m_61143_((Property)WallBlock.f_57953_)))).m_61124_((Property)WallBlock.f_57949_, (Comparable)((Boolean)source.m_61143_((Property)WallBlock.f_57949_)))).m_61124_((Property)StairBlock.f_56844_, (Comparable)((Boolean)source.m_61143_((Property)StairBlock.f_56844_)));
        return state;
    }

    private BlockState copyFence(BlockState source, Block block) {
        BlockState state = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)block.m_49966_().m_61124_((Property)FenceBlock.f_52310_, (Comparable)((Boolean)source.m_61143_((Property)FenceBlock.f_52310_)))).m_61124_((Property)FenceBlock.f_52309_, (Comparable)((Boolean)source.m_61143_((Property)FenceBlock.f_52309_)))).m_61124_((Property)FenceBlock.f_52311_, (Comparable)((Boolean)source.m_61143_((Property)FenceBlock.f_52311_)))).m_61124_((Property)FenceBlock.f_52312_, (Comparable)((Boolean)source.m_61143_((Property)FenceBlock.f_52312_)))).m_61124_((Property)FenceBlock.f_52313_, (Comparable)((Boolean)source.m_61143_((Property)FenceBlock.f_52313_)));
        return state;
    }

    private BlockState copyGate(BlockState source, Block block) {
        BlockState state = (BlockState)((BlockState)((BlockState)((BlockState)block.m_49966_().m_61124_((Property)FenceGateBlock.f_53343_, (Comparable)((Boolean)source.m_61143_((Property)FenceGateBlock.f_53343_)))).m_61124_((Property)FenceGateBlock.f_53341_, (Comparable)((Boolean)source.m_61143_((Property)FenceGateBlock.f_53341_)))).m_61124_((Property)FenceGateBlock.f_53342_, (Comparable)((Boolean)source.m_61143_((Property)FenceGateBlock.f_53342_)))).m_61124_((Property)FenceGateBlock.f_54117_, (Comparable)((Direction)source.m_61143_((Property)FenceGateBlock.f_54117_)));
        return state;
    }

    private BlockState copyPillar(BlockState source, Block block) {
        BlockState state = (BlockState)block.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)((Direction.Axis)source.m_61143_((Property)RotatedPillarBlock.f_55923_)));
        return state;
    }

    private BlockState copyLanternWall(BlockState source, Block block) {
        if (source.m_60734_() instanceof BlockSmallLantern && !(block instanceof BlockSmallLantern)) {
            Direction facing = (Direction)source.m_61143_((Property)BlockSmallLantern.FACING);
            BlockState state = block.m_49966_();
            if (block instanceof WallTorchBlock) {
                return (BlockState)state.m_61124_((Property)WallTorchBlock.f_58119_, (Comparable)facing);
            }
            return state;
        }
        return source;
    }

    private BlockState copyLanternCeiling(BlockState source, Block block) {
        if (source.m_60734_() instanceof BlockSmallLantern && !(block instanceof BlockSmallLantern)) {
            BlockState state = block.m_49966_();
            if (block instanceof LanternBlock) {
                return (BlockState)state.m_61124_((Property)LanternBlock.f_153459_, (Comparable)Boolean.valueOf(true));
            }
            return state;
        }
        return source;
    }

    private BlockState copyDoor(BlockState source, Block block) {
        BlockState state = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)block.m_49966_().m_61124_((Property)DoorBlock.f_52726_, (Comparable)((Direction)source.m_61143_((Property)DoorBlock.f_52726_)))).m_61124_((Property)DoorBlock.f_52730_, (Comparable)((DoubleBlockHalf)source.m_61143_((Property)DoorBlock.f_52730_)))).m_61124_((Property)DoorBlock.f_52728_, (Comparable)((DoorHingeSide)source.m_61143_((Property)DoorBlock.f_52728_)))).m_61124_((Property)DoorBlock.f_52727_, (Comparable)((Boolean)source.m_61143_((Property)DoorBlock.f_52727_)))).m_61124_((Property)DoorBlock.f_52729_, (Comparable)((Boolean)source.m_61143_((Property)DoorBlock.f_52729_)));
        return state;
    }

    private BlockState copyTrapdoor(BlockState source, Block block) {
        BlockState state = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)block.m_49966_().m_61124_((Property)TrapDoorBlock.f_54117_, (Comparable)((Direction)source.m_61143_((Property)TrapDoorBlock.f_54117_)))).m_61124_((Property)TrapDoorBlock.f_57515_, (Comparable)((Half)source.m_61143_((Property)TrapDoorBlock.f_57515_)))).m_61124_((Property)TrapDoorBlock.f_57514_, (Comparable)((Boolean)source.m_61143_((Property)TrapDoorBlock.f_57514_)))).m_61124_((Property)TrapDoorBlock.f_57516_, (Comparable)((Boolean)source.m_61143_((Property)TrapDoorBlock.f_57516_)))).m_61124_((Property)TrapDoorBlock.f_57517_, (Comparable)((Boolean)source.m_61143_((Property)TrapDoorBlock.f_57517_)));
        return state;
    }

    private BlockState copyPane(BlockState source, Block block) {
        BlockState state = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)block.m_49966_().m_61124_((Property)IronBarsBlock.f_52310_, (Comparable)((Boolean)source.m_61143_((Property)IronBarsBlock.f_52310_)))).m_61124_((Property)IronBarsBlock.f_52309_, (Comparable)((Boolean)source.m_61143_((Property)IronBarsBlock.f_52309_)))).m_61124_((Property)IronBarsBlock.f_52311_, (Comparable)((Boolean)source.m_61143_((Property)IronBarsBlock.f_52311_)))).m_61124_((Property)IronBarsBlock.f_52312_, (Comparable)((Boolean)source.m_61143_((Property)IronBarsBlock.f_52312_)))).m_61124_((Property)IronBarsBlock.f_52313_, (Comparable)((Boolean)source.m_61143_((Property)IronBarsBlock.f_52313_)));
        return state;
    }

    public BlockState getFoundationBlock(BlockState input) {
        return this.getFullState(input, this.foundationBlocks);
    }

    public BlockState getFoundationSlab(BlockState input) {
        return this.getSlabState(input, this.foundationSlabs);
    }

    public BlockState getFoundationStair(BlockState input) {
        return this.getStairState(input, this.foundationStairs);
    }

    public BlockState getFoundationWall(BlockState input) {
        if (this.foundationWalls.isEmpty()) {
            return input;
        }
        if (this.foundationWalls.size() == 1) {
            return this.copyWall(input, this.foundationWalls.get(0));
        }
        return this.copyWall(input, this.getRandomBlock(input, this.foundationWalls));
    }

    public BlockState getRoofBlock(BlockState input) {
        return this.getFullState(input, this.roofBlocks);
    }

    public BlockState getRoofSlab(BlockState input) {
        return this.getSlabState(input, this.roofSlabs);
    }

    public BlockState getRoofStair(BlockState input) {
        return this.getStairState(input, this.roofStairs);
    }

    public BlockState getPlanksBlock(BlockState input) {
        return this.getFullState(input, this.planksBlocks);
    }

    public BlockState getPlanksSlab(BlockState input) {
        return this.getSlabState(input, this.planksSlabs);
    }

    public BlockState getPlanksStair(BlockState input) {
        return this.getStairState(input, this.planksStairs);
    }

    public BlockState getFence(BlockState input) {
        if (this.fences.isEmpty()) {
            return input;
        }
        if (this.fences.size() == 1) {
            return this.copyFence(input, this.fences.get(0));
        }
        return this.copyFence(input, this.getRandomBlock(input, this.fences));
    }

    public BlockState getWall(BlockState input) {
        if (this.walls.isEmpty()) {
            return input;
        }
        if (this.walls.size() == 1) {
            return this.copyWall(input, this.walls.get(0));
        }
        return this.copyWall(input, this.getRandomBlock(input, this.walls));
    }

    public BlockState getGate(BlockState input) {
        if (this.gates.isEmpty()) {
            return input;
        }
        if (this.gates.size() == 1) {
            return this.copyGate(input, this.gates.get(0));
        }
        return this.copyGate(input, this.getRandomBlock(input, this.gates));
    }

    public BlockState getLog(BlockState input) {
        if (this.logs.isEmpty()) {
            return input;
        }
        if (this.logs.size() == 1) {
            return this.copyPillar(input, this.logs.get(0));
        }
        return this.copyPillar(input, this.getRandomBlock(input, this.logs));
    }

    public BlockState getBark(BlockState input) {
        if (this.bark.isEmpty()) {
            return input;
        }
        if (this.bark.size() == 1) {
            return this.copyPillar(input, this.bark.get(0));
        }
        return this.copyPillar(input, this.getRandomBlock(input, this.bark));
    }

    public BlockState getStoneBlock(BlockState input) {
        return this.getFullState(input, this.stoneBlocks);
    }

    public BlockState getStoneSlab(BlockState input) {
        return this.getSlabState(input, this.stoneSlabs);
    }

    public BlockState getStoneStair(BlockState input) {
        return this.getStairState(input, this.stoneStairs);
    }

    public BlockState getGlowingBlock(BlockState input) {
        return this.getFullState(input, this.glowingBlocks);
    }

    public BlockState getWallLight(BlockState input) {
        if (this.wallLights.isEmpty()) {
            return input;
        }
        if (this.wallLights.size() == 1) {
            return this.copyLanternWall(input, this.bark.get(0));
        }
        return this.copyLanternWall(input, this.getRandomBlock(input, this.wallLights));
    }

    public BlockState getCeilingLight(BlockState input) {
        return this.copyLanternCeiling(input, this.getRandomBlock(input, this.ceilingLights));
    }

    public BlockState getFloorLight(BlockState input) {
        return this.getFullState(input, this.ceilingLights);
    }

    public BlockState getDoor(BlockState input) {
        return this.copyDoor(input, this.getRandomBlock(input, this.doors));
    }

    public BlockState getTrapdoor(BlockState input) {
        return this.copyTrapdoor(input, this.getRandomBlock(input, this.trapdoors));
    }

    public BlockState getWoodenPlate(BlockState input) {
        return this.getFullState(input, this.platesWood);
    }

    public BlockState getStonePlate(BlockState input) {
        return this.getFullState(input, this.platesStone);
    }

    public BlockState getGlassBlock(BlockState input) {
        return this.getFullState(input, this.glassBlocks);
    }

    public BlockState getGlassPane(BlockState input) {
        return this.copyPane(input, this.getRandomBlock(input, this.glassPanes));
    }

    public BlockState getPot(BlockState input) {
        return this.getFullState(input, this.pots);
    }

    public BlockState getPlant(BlockState input) {
        String seed = BuiltInRegistries.f_256975_.m_7981_((Object)input.m_60734_()).m_135815_();
        RANDOM.m_188584_((long)seed.hashCode());
        return (BlockState)NetherBlocks.POTTED_PLANT.m_49966_().m_61124_(BlockPottedPlant.PLANT, (Comparable)((Object)BNBlockProperties.PottedPlantShape.values()[RANDOM.m_188503_(BNBlockProperties.PottedPlantShape.values().length)]));
    }
}

