/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.structures.city;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import org.betterx.bclib.api.v2.levelgen.structures.BCLStructure;
import org.betterx.betternether.BetterNether;
import org.betterx.betternether.config.Configs;
import org.betterx.betternether.registry.NetherStructures;
import org.betterx.betternether.world.NetherBiomeBuilder;
import org.betterx.betternether.world.structures.city.CityGenerator;
import org.betterx.betternether.world.structures.city.palette.Palettes;
import org.betterx.betternether.world.structures.piece.CavePiece;
import org.betterx.betternether.world.structures.piece.CityPiece;
import org.jetbrains.annotations.NotNull;

public class CityStructure
extends Structure {
    private static CityGenerator generator;
    public static final int RADIUS = 64;
    private static final int DEFAULT_HEIGHT = 40;

    public CityStructure(Structure.StructureSettings structureSettings) {
        super(structureSettings);
    }

    public static void initGenerator() {
        generator = new CityGenerator();
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        if (Configs.GENERATOR.getBoolean("generator.world.cities", "generate", true) && BCLStructure.isValidBiome((Structure.GenerationContext)context, (int)40)) {
            ChunkPos cPos = context.f_226628_();
            ChunkGenerator chunkGenerator = context.f_226622_();
            LevelHeightAccessor heightAccessor = context.f_226629_();
            BlockPos center = CityStructure.getCenter(context, cPos, chunkGenerator, heightAccessor);
            return Optional.of(new Structure.GenerationStub(center, structurePiecesBuilder -> CityStructure.generatePieces(structurePiecesBuilder, context)));
        }
        return Optional.empty();
    }

    private static void generatePieces(StructurePiecesBuilder structurePiecesBuilder, Structure.GenerationContext context) {
        int d2;
        ChunkPos cPos = context.f_226628_();
        ChunkGenerator chunkGenerator = context.f_226622_();
        LevelHeightAccessor heightAccessor = context.f_226629_();
        WorldgenRandom random = context.f_226626_();
        BlockPos center = CityStructure.getCenter(context, cPos, chunkGenerator, heightAccessor);
        ArrayList<CityPiece> buildings = generator.generate(center, (RandomSource)random, Palettes.EMPTY);
        BoundingBox cityBox = new BoundingBox(center);
        for (CityPiece p : buildings) {
            cityBox = cityBox.m_162386_(p.m_73547_());
        }
        int d1 = Math.max(center.m_123341_() - cityBox.m_162395_(), cityBox.m_162399_() - center.m_123341_());
        int radius = Math.max(d1, d2 = Math.max(center.m_123343_() - cityBox.m_162398_(), cityBox.m_162401_() - center.m_123343_()));
        if (radius / 2 + center.m_123342_() < cityBox.m_162400_()) {
            radius = (cityBox.m_162400_() - center.m_123342_()) / 2;
        }
        if (!(chunkGenerator instanceof FlatLevelSource)) {
            CavePiece cave = new CavePiece(center, radius + (NetherBiomeBuilder.useLegacyGeneration ? 0 : 8), (RandomSource)random, cityBox);
            structurePiecesBuilder.m_142679_((StructurePiece)cave);
        }
        buildings.forEach(b -> structurePiecesBuilder.m_142679_((StructurePiece)b));
        BetterNether.LOGGER.info("BBox:" + structurePiecesBuilder.m_192798_().toString());
    }

    @NotNull
    private static BlockPos getCenter(Structure.GenerationContext context, ChunkPos cPos, ChunkGenerator chunkGenerator, LevelHeightAccessor heightAccessor) {
        int px = cPos.m_151382_(8);
        int pz = cPos.m_151391_(8);
        int y = chunkGenerator instanceof FlatLevelSource ? chunkGenerator.m_214096_(px, pz, Heightmap.Types.WORLD_SURFACE, heightAccessor, context.f_226624_()) : 40;
        BlockPos center = new BlockPos(px, y, pz);
        return center;
    }

    public StructureType<?> m_213658_() {
        return NetherStructures.CITY_STRUCTURE.structureType;
    }
}

