/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.features;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.betterx.bclib.api.v3.levelgen.features.UserGrowableFeature;
import org.betterx.bclib.blocks.BlockProperties;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.blocks.BNBlockProperties;
import org.betterx.betternether.blocks.BlockWillowBranch;
import org.betterx.betternether.blocks.BlockWillowLeaves;
import org.betterx.betternether.blocks.BlockWillowTrunk;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.world.features.ContextFeature;
import org.betterx.betternether.world.structures.StructureGeneratorThreadContext;

public class WillowTreeFeature
extends ContextFeature<NoneFeatureConfiguration>
implements UserGrowableFeature<NoneFeatureConfiguration> {
    private static final Direction[] HOR = HorizontalDirectionalBlock.f_54117_.m_6908_().toArray(new Direction[0]);

    public WillowTreeFeature() {
        super(NoneFeatureConfiguration.f_67815_);
    }

    @Override
    protected boolean place(ServerLevelAccessor world, BlockPos pos, RandomSource random, NoneFeatureConfiguration config, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        if (!BlocksHelper.isNetherGround(world.m_8055_(pos.m_7495_()))) {
            return false;
        }
        return this.grow(world, pos, random);
    }

    protected boolean grow(ServerLevelAccessor world, BlockPos pos, RandomSource random) {
        int i;
        int h2 = 5 + random.m_188503_(3);
        int mh = BlocksHelper.upRay((LevelAccessor)world, pos.m_7494_(), h2);
        if (mh < 5) {
            return false;
        }
        h2 = Math.min(h2, mh);
        Block trunk = NetherBlocks.MAT_WILLOW.getTrunk();
        BlocksHelper.setWithUpdate((LevelAccessor)world, pos, (BlockState)trunk.m_49966_().m_61124_(BlockWillowTrunk.SHAPE, (Comparable)BlockProperties.TripleShape.BOTTOM));
        for (int h = 1; h < h2; ++h) {
            if (!world.m_46859_(pos.m_6630_(h))) continue;
            BlocksHelper.setWithUpdate((LevelAccessor)world, pos.m_6630_(h), (BlockState)trunk.m_49966_().m_61124_(BlockWillowTrunk.SHAPE, (Comparable)BlockProperties.TripleShape.MIDDLE));
        }
        if (world.m_46859_(pos.m_6630_(h2))) {
            BlocksHelper.setWithUpdate((LevelAccessor)world, pos.m_6630_(h2), (BlockState)trunk.m_49966_().m_61124_(BlockWillowTrunk.SHAPE, (Comparable)BlockProperties.TripleShape.TOP));
        }
        for (i = 0; i < 4; ++i) {
            this.branch(world, pos.m_6630_(h2).m_121945_(HOR[i]), 3 + random.m_188503_(2), random, HOR[i], pos.m_6630_(h2), 0);
        }
        BlocksHelper.setWithUpdate((LevelAccessor)world, pos.m_6630_(h2 + 1), (BlockState)((BlockState)NetherBlocks.WILLOW_LEAVES.m_49966_().m_61124_((Property)BlockWillowLeaves.FACING, (Comparable)Direction.UP)).m_61124_((Property)LeavesBlock.f_54419_, (Comparable)Boolean.valueOf(true)));
        for (i = 0; i < 4; ++i) {
            BlocksHelper.setWithUpdate((LevelAccessor)world, pos.m_6630_(h2 + 1).m_121945_(HOR[i]), (BlockState)((BlockState)NetherBlocks.WILLOW_LEAVES.m_49966_().m_61124_((Property)BlockWillowLeaves.FACING, (Comparable)HOR[i])).m_61124_((Property)LeavesBlock.f_54419_, (Comparable)Boolean.valueOf(true)));
        }
        return true;
    }

    private void branch(ServerLevelAccessor world, BlockPos pos, int length, RandomSource random, Direction direction, BlockPos center, int level) {
        if (level > 5) {
            return;
        }
        BlockPos.MutableBlockPos bpos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos);
        BlocksHelper.setWithUpdate((LevelAccessor)world, (BlockPos)bpos, (BlockState)((BlockState)NetherBlocks.WILLOW_LEAVES.m_49966_().m_61124_((Property)BlockWillowLeaves.FACING, (Comparable)direction)).m_61124_((Property)LeavesBlock.f_54419_, (Comparable)Boolean.valueOf(true)));
        this.vine(world, pos.m_7495_(), 1 + random.m_188503_(1));
        Direction preDir = direction;
        int l2 = length * length;
        for (int i = 0; i < l2; ++i) {
            Direction dir2;
            BlockPos p2;
            Direction dir = random.m_188503_(3) > 0 ? preDir : (random.m_188499_() ? preDir.m_122427_() : preDir.m_122428_());
            BlockPos p = bpos.m_121945_(dir);
            if (!world.m_46859_(p)) continue;
            bpos.m_122190_((Vec3i)p);
            if (bpos.m_123333_((Vec3i)center) > length) break;
            BlocksHelper.setWithUpdate((LevelAccessor)world, (BlockPos)bpos, (BlockState)((BlockState)NetherBlocks.WILLOW_LEAVES.m_49966_().m_61124_((Property)BlockWillowLeaves.FACING, (Comparable)dir)).m_61124_((Property)LeavesBlock.f_54419_, (Comparable)Boolean.valueOf(true)));
            if (random.m_188499_()) {
                BlocksHelper.setWithUpdate((LevelAccessor)world, bpos.m_7494_(), (BlockState)((BlockState)NetherBlocks.WILLOW_LEAVES.m_49966_().m_61124_((Property)BlockWillowLeaves.FACING, (Comparable)Direction.UP)).m_61124_((Property)LeavesBlock.f_54419_, (Comparable)Boolean.valueOf(true)));
            }
            if (random.m_188503_(3) == 0) {
                bpos.m_142448_(bpos.m_123342_() - 1);
                BlocksHelper.setWithUpdate((LevelAccessor)world, (BlockPos)bpos, (BlockState)((BlockState)NetherBlocks.WILLOW_LEAVES.m_49966_().m_61124_((Property)BlockWillowLeaves.FACING, (Comparable)Direction.DOWN)).m_61124_((Property)LeavesBlock.f_54419_, (Comparable)Boolean.valueOf(true)));
            }
            if (random.m_188499_()) {
                this.vine(world, bpos.m_7495_(), 1 + random.m_188503_(4));
            }
            if (random.m_188499_()) {
                Direction right = dir.m_122427_();
                p2 = bpos.m_121945_(right);
                if (world.m_46859_(p2)) {
                    this.branch(world, p2, length, random, right, center, level + 1);
                }
                if (world.m_46859_(p2 = bpos.m_121945_(right = right.m_122424_()))) {
                    this.branch(world, p2, length, random, right, center, level + 1);
                }
            }
            if (world.m_46859_(p2 = bpos.m_121945_(dir2 = HOR[random.m_188503_(4)]))) {
                BlocksHelper.setWithUpdate((LevelAccessor)world, p2, (BlockState)((BlockState)NetherBlocks.WILLOW_LEAVES.m_49966_().m_61124_((Property)BlockWillowLeaves.FACING, (Comparable)dir2)).m_61124_((Property)LeavesBlock.f_54419_, (Comparable)Boolean.valueOf(true)));
            }
            preDir = dir;
        }
        if (random.m_188499_() && world.m_46859_((BlockPos)bpos)) {
            BlocksHelper.setWithUpdate((LevelAccessor)world, (BlockPos)bpos, (BlockState)NetherBlocks.WILLOW_LEAVES.m_49966_().m_61124_((Property)BlockWillowLeaves.FACING, (Comparable)preDir));
        }
    }

    private void vine(ServerLevelAccessor world, BlockPos pos, int length) {
        if (!world.m_46859_(pos)) {
            return;
        }
        Block branch = NetherBlocks.MAT_WILLOW.getBranch();
        for (int i = 0; i < length; ++i) {
            BlockPos p = pos.m_6625_(i);
            if (!world.m_46859_(p.m_7495_())) {
                BlocksHelper.setWithUpdate((LevelAccessor)world, p, (BlockState)branch.m_49966_().m_61124_(BlockWillowBranch.SHAPE, (Comparable)((Object)BNBlockProperties.WillowBranchShape.END)));
                return;
            }
            BlocksHelper.setWithUpdate((LevelAccessor)world, p, (BlockState)branch.m_49966_().m_61124_(BlockWillowBranch.SHAPE, (Comparable)((Object)BNBlockProperties.WillowBranchShape.MIDDLE)));
        }
        BlocksHelper.setWithUpdate((LevelAccessor)world, pos.m_6625_(length), (BlockState)branch.m_49966_().m_61124_(BlockWillowBranch.SHAPE, (Comparable)((Object)BNBlockProperties.WillowBranchShape.END)));
    }

    public boolean grow(ServerLevelAccessor level, BlockPos pos, RandomSource random, NoneFeatureConfiguration configuration) {
        return this.grow(level, pos, random);
    }
}

