/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.features;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.betterx.bclib.api.v3.levelgen.features.UserGrowableFeature;
import org.betterx.bclib.complexmaterials.set.wood.WoodSlots;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.MHelper;
import org.betterx.betternether.blocks.BNBlockProperties;
import org.betterx.betternether.blocks.BlockPlantWall;
import org.betterx.betternether.blocks.BlockWillowBranch;
import org.betterx.betternether.blocks.BlockWillowLeaves;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.world.features.NetherThreadDataStorage;
import org.betterx.betternether.world.features.NonOverlappingFeature;
import org.betterx.betternether.world.features.configs.NaturalTreeConfiguration;
import org.betterx.betternether.world.structures.StructureGeneratorThreadContext;

public class OldWillowTree
extends NonOverlappingFeature<NaturalTreeConfiguration>
implements UserGrowableFeature<NaturalTreeConfiguration> {
    private static final float[] CURVE_X = new float[]{9.0f, 7.0f, 1.5f, 0.5f, 3.0f, 7.0f};
    private static final float[] CURVE_Y = new float[]{20.0f, 17.0f, 12.0f, 4.0f, 0.0f, -2.0f};
    private static final Block[] wallPlants = new Block[]{NetherBlocks.WALL_MOSS, NetherBlocks.WALL_MOSS, NetherBlocks.WALL_MUSHROOM_BROWN, NetherBlocks.WALL_MUSHROOM_RED};

    public OldWillowTree() {
        super(NaturalTreeConfiguration.CODEC);
    }

    @Override
    protected boolean grow(ServerLevelAccessor world, BlockPos pos, RandomSource random, NaturalTreeConfiguration config, StructureGeneratorThreadContext context) {
        world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 0);
        float scale = MHelper.randRange(0.7f, 1.3f, random);
        int minCount = scale < 1.0f ? 3 : 4;
        int maxCount = scale < 1.0f ? 5 : 7;
        int count = MHelper.randRange(minCount, maxCount, random);
        BoundingBox blockBox = BlocksHelper.decorationBounds((LevelAccessor)world, pos);
        for (int n = 0; n < count; ++n) {
            float branchSize = MHelper.randRange(0.5f, 1.0f, random) * scale;
            float angle = (float)n * ((float)Math.PI * 2) / (float)count;
            float radius = CURVE_X[0] * branchSize;
            int x1 = Math.round((float)pos.m_123341_() + radius * (float)Math.cos(angle) + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
            int y1 = Math.round((float)pos.m_123342_() + CURVE_Y[0] * branchSize + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
            int z1 = Math.round((float)pos.m_123343_() + radius * (float)Math.sin(angle) + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
            float crownR = 10.0f * branchSize;
            if (crownR < 1.5f) {
                crownR = 1.5f;
            }
            this.crown((LevelAccessor)world, new BlockPos(x1, y1 + 1, z1), crownR, random, blockBox);
            boolean generate = true;
            for (int i = 1; i < CURVE_X.length && generate; ++i) {
                radius = CURVE_X[i] * branchSize;
                int x2 = Math.round((float)pos.m_123341_() + radius * (float)Math.cos(angle) + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
                int y2 = Math.round((float)pos.m_123342_() + CURVE_Y[i] * branchSize + (CURVE_Y[i] > 0.0f ? MHelper.randRange(-2.0f, 2.0f, random) * branchSize : 0.0f));
                int z2 = Math.round((float)pos.m_123343_() + radius * (float)Math.sin(angle) + MHelper.randRange(-2.0f, 2.0f, random) * branchSize);
                if (CURVE_Y[i] <= 0.0f && !this.isGround(world.m_8055_((BlockPos)context.POS.m_122178_(x2, y2, z2)))) {
                    boolean noGround = true;
                    for (int d = 1; d < 3; ++d) {
                        if (!this.isGround(world.m_8055_((BlockPos)context.POS.m_122178_(x2, y2 - d, z2)))) continue;
                        y2 -= d;
                        noGround = false;
                        break;
                    }
                    if (noGround) {
                        x2 = pos.m_123341_();
                        y2 = pos.m_123342_();
                        generate = false;
                    }
                }
                this.line((LevelAccessor)world, x1, y1, z1, x2, y2, z2, pos.m_123342_(), context);
                x1 = x2;
                y1 = y2;
                z1 = z2;
            }
        }
        for (BlockPos bpos : context.BLOCKS) {
            BlockState state;
            if (!blockBox.m_71051_((Vec3i)bpos) || !BlocksHelper.isNetherGround(state = world.m_8055_(bpos)) && !state.m_247087_()) continue;
            if (!context.BLOCKS.contains(bpos.m_7494_()) || !context.BLOCKS.contains(bpos.m_7495_())) {
                BlocksHelper.setWithUpdate((LevelAccessor)world, bpos, NetherBlocks.MAT_WILLOW.getBlock(WoodSlots.BARK).m_49966_());
            } else {
                BlocksHelper.setWithUpdate((LevelAccessor)world, bpos, NetherBlocks.MAT_WILLOW.getBlock(WoodSlots.LOG).m_49966_());
            }
            if (random.m_188503_(8) != 0) continue;
            state = wallPlants[random.m_188503_(wallPlants.length)].m_49966_();
            if (random.m_188503_(8) == 0 && !context.BLOCKS.contains(bpos.m_122012_()) && world.m_46859_(bpos.m_122012_())) {
                BlocksHelper.setWithUpdate((LevelAccessor)world, bpos.m_122012_(), (BlockState)state.m_61124_((Property)BlockPlantWall.FACING, (Comparable)Direction.NORTH));
            }
            if (random.m_188503_(8) == 0 && !context.BLOCKS.contains(bpos.m_122019_()) && world.m_46859_(bpos.m_122019_())) {
                BlocksHelper.setWithUpdate((LevelAccessor)world, bpos.m_122019_(), (BlockState)state.m_61124_((Property)BlockPlantWall.FACING, (Comparable)Direction.SOUTH));
            }
            if (random.m_188503_(8) == 0 && !context.BLOCKS.contains(bpos.m_122029_()) && world.m_46859_(bpos.m_122029_())) {
                BlocksHelper.setWithUpdate((LevelAccessor)world, bpos.m_122029_(), (BlockState)state.m_61124_((Property)BlockPlantWall.FACING, (Comparable)Direction.EAST));
            }
            if (random.m_188503_(8) != 0 || context.BLOCKS.contains(bpos.m_122024_()) || !world.m_46859_(bpos.m_122024_())) continue;
            BlocksHelper.setWithUpdate((LevelAccessor)world, bpos.m_122024_(), (BlockState)state.m_61124_((Property)BlockPlantWall.FACING, (Comparable)Direction.WEST));
        }
        context.BLOCKS.clear();
        return true;
    }

    @Override
    protected boolean place(ServerLevelAccessor world, BlockPos pos, RandomSource random, NaturalTreeConfiguration config, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        int length = BlocksHelper.upRay((LevelAccessor)world, pos, 27);
        if (length >= 25) {
            return super.place(world, pos, random, config, MAX_HEIGHT, context);
        }
        return false;
    }

    @Override
    protected boolean isStructure(BlockState state) {
        return state.m_60734_() == NetherBlocks.MAT_RUBEUS.getLog();
    }

    @Override
    protected boolean isGround(BlockState state) {
        return BlocksHelper.isNetherGround(state);
    }

    private void line(LevelAccessor world, int x1, int y1, int z1, int x2, int y2, int z2, int startY, StructureGeneratorThreadContext context) {
        BlockPos.MutableBlockPos POS = new BlockPos.MutableBlockPos();
        int dx = x2 - x1;
        int dy = y2 - y1;
        int dz = z2 - z1;
        int mx = Math.max(Math.max(Math.abs(dx), Math.abs(dy)), Math.abs(dz));
        float fdx = (float)dx / (float)mx;
        float fdy = (float)dy / (float)mx;
        float fdz = (float)dz / (float)mx;
        float px = x1;
        float py = y1;
        float pz = z1;
        BlockPos pos = POS.m_122178_(x1, y1, z1).m_7949_();
        context.BLOCKS.add(pos);
        pos = POS.m_122178_(x2, y2, z2).m_7949_();
        context.BLOCKS.add(pos);
        for (int i = 0; i < mx; ++i) {
            POS.m_122178_(Math.round(px += fdx), Math.round(py += fdy), Math.round(pz += fdz));
            double delta = POS.m_123342_() - startY;
            this.sphere((BlockPos)POS, Mth.m_14008_((double)(2.3 - Math.abs(delta) * (delta > 0.0 ? 0.1 : 0.3)), (double)0.5, (double)2.3), context);
        }
    }

    private void sphere(BlockPos pos, double radius, StructureGeneratorThreadContext context) {
        int x1 = MHelper.floor((double)pos.m_123341_() - radius);
        int y1 = MHelper.floor((double)pos.m_123342_() - radius);
        int z1 = MHelper.floor((double)pos.m_123343_() - radius);
        int x2 = MHelper.floor((double)pos.m_123341_() + radius + 1.0);
        int y2 = MHelper.floor((double)pos.m_123342_() + radius + 1.0);
        int z2 = MHelper.floor((double)pos.m_123343_() + radius + 1.0);
        radius *= radius;
        for (int x = x1; x <= x2; ++x) {
            int px2 = x - pos.m_123341_();
            px2 *= px2;
            for (int z = z1; z <= z2; ++z) {
                int pz2 = z - pos.m_123343_();
                pz2 *= pz2;
                for (int y = y1; y <= y2; ++y) {
                    int py2 = y - pos.m_123342_();
                    if (!((double)(px2 + pz2 + (py2 *= py2)) <= radius)) continue;
                    context.BLOCKS.add(new BlockPos(x, y, z));
                }
            }
        }
    }

    private void crown(LevelAccessor world, BlockPos pos, float radius, RandomSource random, BoundingBox bounds) {
        int start;
        BlockPos.MutableBlockPos POS = new BlockPos.MutableBlockPos();
        BlockState leaves = (BlockState)NetherBlocks.WILLOW_LEAVES.m_49966_().m_61124_((Property)BlockWillowLeaves.NATURAL, (Comparable)Boolean.valueOf(false));
        BlockState vine = NetherBlocks.MAT_WILLOW.getBranch().m_49966_();
        float halfR = radius * 0.5f;
        float r2 = radius * radius;
        int cy = start = (int)Math.floor(-radius);
        while ((float)cy <= radius) {
            int cy2_out = cy * cy;
            float cy2_in = (float)cy + halfR;
            cy2_in *= cy2_in;
            POS.m_142448_((int)((float)(pos.m_123342_() + cy) - halfR));
            int cx = start;
            while ((float)cx <= radius) {
                int cx2 = cx * cx * 2;
                POS.m_142451_(pos.m_123341_() + cx);
                int cz = start;
                while ((float)cz <= radius) {
                    block5: {
                        block8: {
                            block6: {
                                int length;
                                block7: {
                                    int cz2 = cz * cz * 2;
                                    if (!((float)(cx2 + cy2_out + cz2) < r2) || !((float)cx2 + cy2_in + (float)cz2 > r2)) break block5;
                                    POS.m_142443_(pos.m_123343_() + cz);
                                    if (!world.m_8055_((BlockPos)POS).m_247087_()) break block5;
                                    if (!random.m_188499_()) break block6;
                                    length = BlocksHelper.downRay(world, (BlockPos)POS, 12);
                                    if (length >= 3) break block7;
                                    BlocksHelper.setWithUpdate(world, (BlockPos)POS, leaves, bounds);
                                    break block5;
                                }
                                length = MHelper.randRange(3, length, random);
                                for (int i = 1; i < length - 1; ++i) {
                                    BlocksHelper.setWithUpdate(world, POS.m_6625_(i), vine, bounds);
                                }
                                BlocksHelper.setWithUpdate(world, POS.m_6625_(length - 1), (BlockState)vine.m_61124_(BlockWillowBranch.SHAPE, (Comparable)((Object)BNBlockProperties.WillowBranchShape.END)), bounds);
                                break block8;
                            }
                            if (random.m_188499_() && world.m_8055_(POS.m_7495_()).m_247087_()) {
                                BlocksHelper.setWithUpdate(world, POS.m_7495_(), leaves, bounds);
                            }
                        }
                        BlocksHelper.setWithUpdate(world, (BlockPos)POS, leaves, bounds);
                    }
                    ++cz;
                }
                ++cx;
            }
            ++cy;
        }
    }

    public boolean grow(ServerLevelAccessor level, BlockPos pos, RandomSource random, NaturalTreeConfiguration configuration) {
        return this.grow(level, pos, random, new NaturalTreeConfiguration(false, configuration.distance), NetherThreadDataStorage.generatorForThread().context);
    }
}

