/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.features;

import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.noise.OpenSimplexNoise;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.world.features.NetherSurfaceFeature;
import org.betterx.betternether.world.structures.StructureGeneratorThreadContext;

public class CrystalFeature
extends NetherSurfaceFeature {
    private static final Block[] PALETTES = new Block[]{NetherBlocks.OBSIDIAN_GLASS, Blocks.f_50080_, NetherBlocks.BLUE_OBSIDIAN_GLASS, NetherBlocks.BLUE_OBSIDIAN};
    private static final double SQRT05 = Math.sqrt(0.5);
    private static final float MAX_ANGLE_X = (float)Math.toRadians(45.0);
    private static final float MAX_ANGLE_Y = (float)Math.PI * 2;
    private static final float MAX_ANGLE_Z = (float)Math.toRadians(30.0);
    private static final OpenSimplexNoise NOISE = new OpenSimplexNoise(0L);

    @Override
    protected void generate(ServerLevelAccessor world, BlockPos pos, RandomSource random, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        BlockPos.MutableBlockPos POS = context.POS;
        float scale_factor = ((float)MAX_HEIGHT / 128.0f - 1.0f) * 0.5f + 1.0f;
        int index = random.m_188503_(PALETTES.length >> 1);
        boolean isBlue = index == 1;
        double a = random.m_188500_();
        double radius = 2.0 + a * a * 5.0 * (double)scale_factor;
        int sideXZ = (int)Math.ceil(radius * 2.0);
        int sideY = (int)Math.ceil(radius * 3.0);
        float angleX = random.m_188501_() * MAX_ANGLE_X;
        float angleY = random.m_188501_() * ((float)Math.PI * 2);
        float angleZ = (random.m_188501_() * 2.0f - 1.0f) * MAX_ANGLE_Z;
        for (int y = -sideY; y <= sideY; ++y) {
            for (int x = -sideXZ; x <= sideXZ; ++x) {
                for (int z = -sideXZ; z <= sideXZ; ++z) {
                    Vec3 v = new Vec3((double)x, (double)y, (double)z).m_82535_(angleZ).m_82496_(angleX).m_82524_(angleY);
                    double d = this.depth(v.f_82479_, v.f_82480_, v.f_82481_, radius);
                    if (!(d <= 0.0)) continue;
                    POS.m_142451_(pos.m_123341_() + x);
                    POS.m_142448_(pos.m_123342_() + y);
                    POS.m_142443_(pos.m_123343_() + z);
                    if (POS.m_123342_() <= 0 || POS.m_123342_() >= MAX_HEIGHT - 2) continue;
                    BlockState state = d <= -0.3 ? (random.m_188503_(12) == 0 ? (isBlue ? NetherBlocks.BLUE_WEEPING_OBSIDIAN : NetherBlocks.WEEPING_OBSIDIAN).m_49966_() : this.getState(index, v)) : (d <= -0.15 ? (random.m_188503_(9) == 0 ? (isBlue ? NetherBlocks.BLUE_CRYING_OBSIDIAN : Blocks.f_50723_).m_49966_() : this.getState(index, v)) : (this.isNotEdge(v.f_82479_, v.f_82480_, v.f_82481_, radius) ? (random.m_188503_(20) == 0 ? Blocks.f_50141_.m_49966_() : this.getState(index, v)) : (random.m_188503_(50) == 0 ? (random.m_188503_(4) == 0 ? (isBlue ? NetherBlocks.BLUE_WEEPING_OBSIDIAN : NetherBlocks.WEEPING_OBSIDIAN).m_49966_() : (isBlue ? NetherBlocks.BLUE_CRYING_OBSIDIAN : Blocks.f_50723_).m_49966_()) : this.getState(index, v))));
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)POS, state);
                }
            }
        }
    }

    private double depth(double x, double y, double z, double size) {
        return this.dodecahedronSDF(x / size, y / size * 0.3, z / size);
    }

    private boolean isInside(double x, double y, double z, double size) {
        return this.dodecahedronSDF(x / size, y / size * 0.3, z / size) <= 0.0;
    }

    private boolean isNotEdge(double x, double y, double z, double size) {
        return this.isInside(x + 1.0, y, z, size) && this.isInside(x - 1.0, y, z, size) && this.isInside(x, y + 1.0, z, size) && this.isInside(x, y - 1.0, z, size) && this.isInside(x, y, z + 1.0, size) && this.isInside(x, y, z - 1.0, size);
    }

    private double dodecahedronSDF(double x, double y, double z) {
        x = Math.abs(x);
        y = Math.abs(y);
        z = Math.abs(z);
        return (Math.max(Math.max(x + y, y + z), z + x) - 1.0) * SQRT05;
    }

    private double rigidNoise(Vec3 pos, double scale) {
        double val = NOISE.eval(pos.f_82479_ * scale, pos.f_82480_ * scale, pos.f_82481_ * scale);
        return Math.abs(val);
    }

    private BlockState getState(int index, Vec3 pos) {
        int subindex = this.rigidNoise(pos, 0.2) > 0.2 ? 0 : 1;
        int blockIndex = index << 1 | subindex;
        return PALETTES[blockIndex].m_49966_();
    }
}

