/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.features;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.blocks.BlockStalactite;
import org.betterx.betternether.world.features.NetherThreadDataStorage;
import org.betterx.betternether.world.structures.StructureGeneratorThreadContext;

public class BlockFixFeature
extends DefaultFeature {
    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> featurePlaceContext) {
        BlockPos worldPos = featurePlaceContext.m_159777_();
        WorldGenLevel level = featurePlaceContext.m_159774_();
        int sx = worldPos.m_123341_() >> 4 << 4;
        int sz = worldPos.m_123343_() >> 4 << 4;
        BlockFixFeature.fixBlocks(level, sx, 30, sz, sx + 15, 110, sz + 15);
        return true;
    }

    private static void fixBlocks(WorldGenLevel world, int x1, int y1, int z1, int x2, int y2, int z2) {
        StructureGeneratorThreadContext ctx = NetherThreadDataStorage.generatorForThread().context;
        BlockPos.MutableBlockPos popPos = ctx.POS;
        BlockPos.MutableBlockPos abovePos = ctx.POS2;
        BlockPos.MutableBlockPos belowPos = ctx.POS3;
        for (int y = y1; y <= y2; ++y) {
            popPos.m_142448_(y);
            abovePos.m_142448_(y + 1);
            belowPos.m_142448_(y - 1);
            for (int x = x1; x <= x2; ++x) {
                popPos.m_142451_(x);
                abovePos.m_142451_(x);
                belowPos.m_142451_(x);
                for (int z = z1; z <= z2; ++z) {
                    popPos.m_142443_(z);
                    abovePos.m_142443_(z);
                    belowPos.m_142443_(z);
                    BlockState state = world.m_8055_((BlockPos)popPos);
                    if (!state.m_60710_((LevelReader)world, (BlockPos)popPos)) {
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)popPos, AIR);
                        continue;
                    }
                    BlockState aboveState = world.m_8055_((BlockPos)abovePos);
                    if (!state.m_60815_() && aboveState.m_60713_(Blocks.f_50197_)) {
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)popPos, Blocks.f_50197_.m_49966_());
                        continue;
                    }
                    if (org.betterx.bclib.util.BlocksHelper.isLava((BlockState)state) && world.m_46859_((BlockPos)abovePos) && world.m_46859_((BlockPos)belowPos)) {
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)popPos, AIR);
                        continue;
                    }
                    if (state.m_60734_() == Blocks.f_50451_ || state.m_60734_() == Blocks.f_50692_) {
                        if (!world.m_46859_((BlockPos)belowPos) || !world.m_46859_((BlockPos)abovePos) || !world.m_46859_(popPos.m_122012_()) || !world.m_46859_(popPos.m_122019_()) || !world.m_46859_(popPos.m_122029_()) || !world.m_46859_(popPos.m_122024_())) continue;
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)popPos, AIR);
                        continue;
                    }
                    if (!(state.m_60734_() instanceof BlockStalactite) || (state = world.m_8055_((BlockPos)belowPos)).m_60838_((BlockGetter)world, (BlockPos)belowPos) || state.m_60734_() instanceof BlockStalactite) continue;
                    BlockPos.MutableBlockPos sp = new BlockPos.MutableBlockPos().m_122190_((Vec3i)popPos);
                    while (world.m_8055_((BlockPos)sp).m_60734_() instanceof BlockStalactite) {
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)sp, AIR);
                        sp.m_121945_(Direction.UP);
                    }
                }
            }
        }
    }
}

