/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.features;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.betterx.bclib.blocks.BlockProperties;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.MHelper;
import org.betterx.betternether.blocks.BlockAnchorTreeVine;
import org.betterx.betternether.blocks.BlockPlantWall;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.world.features.AnchorTreeFeature;
import org.betterx.betternether.world.features.ContextFeature;
import org.betterx.betternether.world.features.LucisFeature;
import org.betterx.betternether.world.structures.StructureGeneratorThreadContext;

public class AnchorTreeRootFeature
extends ContextFeature<NoneFeatureConfiguration> {
    private static final LucisFeature LUCIS = new LucisFeature();

    public AnchorTreeRootFeature() {
        super(NoneFeatureConfiguration.f_67815_);
    }

    @Override
    protected boolean place(ServerLevelAccessor world, BlockPos pos, RandomSource random, NoneFeatureConfiguration config, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        if ((double)pos.m_123342_() < (double)MAX_HEIGHT * 0.75) {
            return false;
        }
        double angle = random.m_188500_() * Math.PI * 2.0;
        double dx = Math.sin(angle);
        double dz = Math.cos(angle);
        double size = (double)MHelper.randRange(10, 25, random) * 0.5;
        int count = MHelper.floor(size * 2.0);
        if (count < 3) {
            count = 3;
        }
        if ((count & 1) == 0) {
            ++count;
        }
        context.POS.m_122169_((double)pos.m_123341_() - dx * size, (double)(pos.m_123342_() + 10), (double)pos.m_123343_() - dz * size);
        BlockPos start = context.POS.m_6630_(BlocksHelper.upRay((LevelAccessor)world, (BlockPos)context.POS, (int)((double)MAX_HEIGHT * 0.75)));
        if (start.m_123342_() < pos.m_123342_()) {
            start = context.POS.m_122190_((Vec3i)start).m_7918_(0, 10, 0).m_7949_();
        }
        context.POS.m_122169_((double)pos.m_123341_() + dx * size, (double)(pos.m_123342_() + 10), (double)pos.m_123343_() + dz * size);
        BlockPos end = context.POS.m_6630_(BlocksHelper.upRay((LevelAccessor)world, (BlockPos)context.POS, (int)((double)MAX_HEIGHT * 0.75)));
        if (end.m_123342_() < pos.m_123342_()) {
            end = context.POS.m_122190_((Vec3i)end).m_7918_(0, 10, 0).m_7949_();
        }
        List<BlockPos> blocks = this.lineParable(start, end, count, random, 0.2);
        context.BLOCKS.clear();
        this.buildLine(blocks, 1.3 + random.m_188500_(), context);
        BlockState vine = NetherBlocks.ANCHOR_TREE_VINE.m_49966_();
        int minBuildHeight = world.m_141937_() + 1;
        BoundingBox blockBox = BlocksHelper.decorationBounds((LevelAccessor)world, pos, minBuildHeight, MAX_HEIGHT - 2);
        for (BlockPos bpos : context.BLOCKS) {
            int length;
            BlockState state;
            if (bpos.m_123342_() < minBuildHeight || bpos.m_123342_() > MAX_HEIGHT - 2 || !BlocksHelper.isNetherGround(state = world.m_8055_(bpos)) && !this.canReplace(state)) continue;
            boolean blockDown = true;
            boolean blockUp = context.BLOCKS.contains(bpos.m_7494_());
            if (blockUp && (blockDown = context.BLOCKS.contains(bpos.m_7495_()))) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, bpos, NetherBlocks.MAT_ANCHOR_TREE.getLog().m_49966_());
            } else {
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, bpos, NetherBlocks.MAT_ANCHOR_TREE.getBark().m_49966_());
            }
            if (!blockUp && world.m_8055_(bpos.m_7494_()).m_247087_()) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, bpos.m_7494_(), NetherBlocks.MOSS_COVER.m_49966_());
            }
            if ((bpos.m_123342_() & 3) == 0 && AnchorTreeFeature.NOISE.eval((double)bpos.m_123341_() * 0.1, (double)bpos.m_123342_() * 0.1, (double)bpos.m_123343_() * 0.1) > 0.0) {
                if (random.m_188503_(32) == 0 && !context.BLOCKS.contains(bpos.m_122012_())) {
                    if (random.m_188499_()) {
                        AnchorTreeFeature.makeMushroom(world, bpos.m_122012_(), random.m_188500_() + 1.5, blockBox);
                    } else {
                        LUCIS.grow(world, bpos, random, false);
                    }
                }
                if (random.m_188503_(32) == 0 && !context.BLOCKS.contains(bpos.m_122019_())) {
                    if (random.m_188499_()) {
                        AnchorTreeFeature.makeMushroom(world, bpos.m_122019_(), random.m_188500_() + 1.5, blockBox);
                    } else {
                        LUCIS.grow(world, bpos, random, false);
                    }
                }
                if (random.m_188503_(32) == 0 && !context.BLOCKS.contains(bpos.m_122029_())) {
                    if (random.m_188499_()) {
                        AnchorTreeFeature.makeMushroom(world, bpos.m_122029_(), random.m_188500_() + 1.5, blockBox);
                    } else {
                        LUCIS.grow(world, bpos, random, false);
                    }
                }
                if (random.m_188503_(32) == 0 && !context.BLOCKS.contains(bpos.m_122024_())) {
                    if (random.m_188499_()) {
                        AnchorTreeFeature.makeMushroom(world, bpos.m_122024_(), random.m_188500_() + 1.5, blockBox);
                    } else {
                        LUCIS.grow(world, bpos, random, false);
                    }
                }
            }
            state = AnchorTreeFeature.wallPlants[random.m_188503_(AnchorTreeFeature.wallPlants.length)].m_49966_();
            BlockPos _pos = bpos.m_122012_();
            if (random.m_188503_(8) == 0 && !context.BLOCKS.contains(_pos) && world.m_46859_(_pos)) {
                BlocksHelper.setWithUpdate((LevelAccessor)world, _pos, (BlockState)state.m_61124_((Property)BlockPlantWall.FACING, (Comparable)Direction.NORTH));
            }
            _pos = bpos.m_122019_();
            if (random.m_188503_(8) == 0 && !context.BLOCKS.contains(_pos) && world.m_46859_(_pos)) {
                BlocksHelper.setWithUpdate((LevelAccessor)world, _pos, (BlockState)state.m_61124_((Property)BlockPlantWall.FACING, (Comparable)Direction.SOUTH));
            }
            _pos = bpos.m_122029_();
            if (random.m_188503_(8) == 0 && !context.BLOCKS.contains(_pos) && world.m_46859_(_pos)) {
                BlocksHelper.setWithUpdate((LevelAccessor)world, _pos, (BlockState)state.m_61124_((Property)BlockPlantWall.FACING, (Comparable)Direction.EAST));
            }
            _pos = bpos.m_122024_();
            if (random.m_188503_(8) == 0 && !context.BLOCKS.contains(_pos) && world.m_46859_(_pos)) {
                BlocksHelper.setWithUpdate((LevelAccessor)world, _pos, (BlockState)state.m_61124_((Property)BlockPlantWall.FACING, (Comparable)Direction.WEST));
            }
            if (!blockUp || blockDown || random.m_188503_(16) != 0 || (length = BlocksHelper.downRay((LevelAccessor)world, bpos = bpos.m_7495_(), 17)) <= 4) continue;
            length = MHelper.randRange(3, length, random);
            for (int i = 0; i < length - 2; ++i) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, bpos.m_6625_(i), vine);
            }
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, bpos.m_6625_(length - 2), (BlockState)vine.m_61124_(BlockAnchorTreeVine.SHAPE, (Comparable)BlockProperties.TripleShape.MIDDLE));
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, bpos.m_6625_(length - 1), (BlockState)vine.m_61124_(BlockAnchorTreeVine.SHAPE, (Comparable)BlockProperties.TripleShape.BOTTOM));
        }
        return true;
    }

    private boolean canReplace(BlockState state) {
        return state.m_247087_() || state.m_60734_() == NetherBlocks.GIANT_LUCIS || state.m_60734_() == NetherBlocks.LUCIS_MUSHROOM || state.m_60734_() instanceof BlockPlantWall;
    }

    private void buildLine(List<BlockPos> blocks, double radius, StructureGeneratorThreadContext context) {
        for (int i = 0; i < blocks.size() - 1; ++i) {
            BlockPos a = blocks.get(i);
            BlockPos b = blocks.get(i + 1);
            if (b.m_123342_() < a.m_123342_()) {
                BlockPos c = b;
                b = a;
                a = c;
            }
            int count = (int)Math.ceil(Math.sqrt(b.m_123331_((Vec3i)a)));
            for (int j = 0; j < count; ++j) {
                this.sphere(this.lerpCos(a, b, (double)j / (double)count), radius, context);
            }
        }
    }

    private BlockPos lerpCos(BlockPos start, BlockPos end, double mix) {
        double v = this.lcos(mix);
        double x = Mth.m_14139_((double)v, (double)start.m_123341_(), (double)end.m_123341_());
        double y = Mth.m_14139_((double)v, (double)start.m_123342_(), (double)end.m_123342_());
        double z = Mth.m_14139_((double)v, (double)start.m_123343_(), (double)end.m_123343_());
        return new BlockPos((int)x, (int)y, (int)z);
    }

    private double lcos(double mix) {
        return Mth.m_14008_((double)(0.5 - Math.cos(mix * Math.PI) * 0.5), (double)0.0, (double)1.0);
    }

    private List<BlockPos> lineParable(BlockPos start, BlockPos end, int count, RandomSource random, double range) {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>(count);
        int max = count - 1;
        int middle = count / 2;
        result.add(start);
        double size = Math.sqrt(start.m_123331_((Vec3i)end)) * 0.8;
        for (int i = 1; i < max; ++i) {
            double offset = (double)(i - middle) / (double)middle;
            offset = 1.0 - offset * offset;
            double delta = (double)i / (double)max;
            double x = Mth.m_14139_((double)delta, (double)start.m_123341_(), (double)end.m_123341_()) + random.m_188583_() * range;
            double y = Mth.m_14139_((double)delta, (double)start.m_123342_(), (double)end.m_123342_()) - offset * size;
            double z = Mth.m_14139_((double)delta, (double)start.m_123343_(), (double)end.m_123343_()) + random.m_188583_() * range;
            result.add(new BlockPos((int)x, (int)y, (int)z));
        }
        result.add(end);
        return result;
    }

    private void sphere(BlockPos pos, double radius, StructureGeneratorThreadContext context) {
        int x1 = MHelper.floor((double)pos.m_123341_() - radius);
        int y1 = MHelper.floor((double)pos.m_123342_() - radius);
        int z1 = MHelper.floor((double)pos.m_123343_() - radius);
        int x2 = MHelper.floor((double)pos.m_123341_() + radius + 1.0);
        int y2 = MHelper.floor((double)pos.m_123342_() + radius + 1.0);
        int z2 = MHelper.floor((double)pos.m_123343_() + radius + 1.0);
        radius *= radius;
        for (int x = x1; x <= x2; ++x) {
            int px2 = x - pos.m_123341_();
            px2 *= px2;
            for (int z = z1; z <= z2; ++z) {
                int pz2 = z - pos.m_123343_();
                pz2 *= pz2;
                for (int y = y1; y <= y2; ++y) {
                    int py2 = y - pos.m_123342_();
                    if (!((double)(px2 + pz2 + (py2 *= py2)) <= radius)) continue;
                    context.BLOCKS.add(new BlockPos(x, y, z));
                }
            }
        }
    }
}

