/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.biomes;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.SurfaceRules;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeBuilder;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeSettings;
import org.betterx.bclib.api.v2.levelgen.surface.SurfaceRuleBuilder;
import org.betterx.bclib.api.v2.levelgen.surface.rules.Conditions;
import org.betterx.bclib.api.v2.levelgen.surface.rules.SwitchRuleSource;
import org.betterx.betternether.registry.NetherEntities;
import org.betterx.betternether.registry.NetherFeatures;
import org.betterx.betternether.registry.features.placed.NetherObjectsPlaced;
import org.betterx.betternether.registry.features.placed.NetherTerrainPlaced;
import org.betterx.betternether.registry.features.placed.NetherVegetationPlaced;
import org.betterx.betternether.world.NetherBiome;
import org.betterx.betternether.world.NetherBiomeConfig;
import org.betterx.betternether.world.biomes.NetherGrasslands;

public class NetherWartForestEdge
extends NetherBiome {
    public NetherWartForestEdge(ResourceKey<Biome> biomeID, BCLBiomeSettings settings) {
        super(biomeID, settings);
    }

    public static class Config
    extends NetherBiomeConfig {
        public Config(String name) {
            super(name);
        }

        @Override
        protected void addCustomBuildData(BCLBiomeBuilder builder) {
            builder.fogColor(191, 28, 28).loop((Holder)SoundEvents.f_11954_).additions((Holder)SoundEvents.f_11901_).mood((Holder)SoundEvents.f_12007_).music((Holder)SoundEvents.f_12157_).feature(NetherFeatures.NETHER_RUBY_ORE).feature(NetherTerrainPlaced.REPLACE_SOUL_SANDSTONE).feature(NetherObjectsPlaced.BASALT_STALAGMITE).feature(NetherVegetationPlaced.BLACK_BUSH).feature(NetherVegetationPlaced.VEGETATION_WART_FOREST_EDGE).addNetherClimateParamater(-0.5f, 0.45f, 0.0f);
        }

        @Override
        public SurfaceRuleBuilder surface() {
            return super.surface().rule(SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189375_, (SurfaceRules.RuleSource)new SwitchRuleSource(Conditions.NETHER_NOISE, List.of(NetherGrasslands.SOUL_SOIL, NetherGrasslands.SOUL_SAND, NetherGrasslands.MOSS, NETHERRACK))), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)Conditions.NETHER_VOLUME_NOISE, (SurfaceRules.RuleSource)NetherGrasslands.SOUL_SAND), NETHERRACK}));
        }

        @Override
        public BCLBiomeBuilder.BiomeSupplier<NetherBiome> getSupplier() {
            return NetherWartForestEdge::new;
        }

        @Override
        public <M extends Mob> int spawnWeight(NetherEntities.KnownSpawnTypes type) {
            int res = super.spawnWeight(type);
            switch (type) {
                case FLYING_PIG: {
                    res = type.weight;
                    break;
                }
                case NAGA: {
                    res = 0;
                }
            }
            return res;
        }
    }
}

