/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.biomes;

import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.SurfaceRules;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeBuilder;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeSettings;
import org.betterx.bclib.api.v2.levelgen.surface.SurfaceRuleBuilder;
import org.betterx.bclib.api.v2.levelgen.surface.rules.Conditions;
import org.betterx.bclib.api.v2.levelgen.surface.rules.NoiseCondition;
import org.betterx.betternether.registry.NetherEntities;
import org.betterx.betternether.registry.SoundsRegistry;
import org.betterx.betternether.registry.features.placed.NetherObjectsPlaced;
import org.betterx.betternether.registry.features.placed.NetherVegetationPlaced;
import org.betterx.betternether.world.NetherBiome;
import org.betterx.betternether.world.NetherBiomeConfig;

public class NetherGravelDesert
extends NetherBiome {
    public static final SurfaceRules.RuleSource GRAVEL = SurfaceRules.m_189390_((BlockState)Blocks.f_49994_.m_49966_());

    public NetherGravelDesert(ResourceKey<Biome> biomeID, BCLBiomeSettings settings) {
        super(biomeID, settings);
    }

    public static class Config
    extends NetherBiomeConfig {
        public Config(String name) {
            super(name);
        }

        @Override
        protected void addCustomBuildData(BCLBiomeBuilder builder) {
            builder.fogColor(170, 48, 0).mood((Holder)SoundEvents.f_12166_).loop(SoundsRegistry.AMBIENT_GRAVEL_DESERT).additions((Holder)SoundEvents.f_12060_).music((Holder)SoundEvents.f_12155_).particles((ParticleOptions)ParticleTypes.f_123783_, 0.02f).structure(BiomeTags.f_207599_).structure(BiomeTags.f_207597_).feature(NetherVegetationPlaced.NETHER_CACTUS).feature(NetherVegetationPlaced.VEGETATION_GRAVEL_DESERT).feature(NetherObjectsPlaced.STALACTITE).addNetherClimateParamater(0.5f, -0.7f, 0.0f);
        }

        @Override
        public BCLBiomeBuilder.BiomeSupplier<NetherBiome> getSupplier() {
            return NetherGravelDesert::new;
        }

        @Override
        public SurfaceRuleBuilder surface() {
            return super.surface().ceil(Blocks.f_50134_.m_49966_()).floor(Blocks.f_49994_.m_49966_()).rule(3, SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189376_, (SurfaceRules.RuleSource)GRAVEL)).belowFloor(Blocks.f_49994_.m_49966_(), 4, (NoiseCondition)Conditions.NETHER_VOLUME_NOISE);
        }

        @Override
        public <M extends Mob> int spawnWeight(NetherEntities.KnownSpawnTypes type) {
            int res = super.spawnWeight(type);
            switch (type) {
                case NAGA: {
                    res = 20;
                }
            }
            return res;
        }
    }
}

