/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.Carvers;
import net.minecraft.data.worldgen.placement.MiscOverworldPlacements;
import net.minecraft.data.worldgen.placement.NetherPlacements;
import net.minecraft.data.worldgen.placement.OrePlacements;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiome;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeBuilder;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.betternether.BetterNether;
import org.betterx.betternether.registry.NetherEntities;
import org.betterx.betternether.registry.NetherFeatures;
import org.betterx.betternether.registry.NetherStructures;
import org.betterx.betternether.registry.NetherTags;
import org.betterx.betternether.registry.features.placed.NetherVegetationPlaced;
import org.betterx.betternether.world.NetherBiome;
import org.betterx.betternether.world.NetherBiomeConfig;

public class NetherBiomeBuilder {
    public static boolean useLegacyGeneration = false;
    static final SurfaceRules.RuleSource BEDROCK = SurfaceRules.m_189390_((BlockState)Blocks.f_50752_.m_49966_());
    static final SurfaceRules.VerticalGradientConditionSource BEDROCK_BOTTOM = new SurfaceRules.VerticalGradientConditionSource(BetterNether.makeID("bedrock_floor"), VerticalAnchor.m_158921_(), VerticalAnchor.m_158930_((int)5));
    static final SurfaceRules.VerticalGradientConditionSource BEDROCK_TOP = new SurfaceRules.VerticalGradientConditionSource(BetterNether.makeID("bedrock_roof"), VerticalAnchor.m_158935_((int)5), VerticalAnchor.m_158929_());

    private static void addVanillaStructures(BCLBiomeBuilder builder) {
        builder.carver(GenerationStep.Carving.AIR, Carvers.f_126853_);
        builder.structure(BiomeTags.f_207600_);
    }

    private static void addVanillaFeatures(BCLBiomeBuilder builder) {
        builder.feature(GenerationStep.Decoration.VEGETAL_DECORATION, MiscOverworldPlacements.f_195274_).defaultMushrooms().feature(GenerationStep.Decoration.UNDERGROUND_DECORATION, NetherPlacements.f_195296_).feature(GenerationStep.Decoration.UNDERGROUND_DECORATION, NetherPlacements.f_195299_).feature(GenerationStep.Decoration.UNDERGROUND_DECORATION, NetherPlacements.f_195298_).feature(GenerationStep.Decoration.UNDERGROUND_DECORATION, NetherPlacements.f_195284_).feature(GenerationStep.Decoration.UNDERGROUND_DECORATION, NetherPlacements.f_195285_).feature(GenerationStep.Decoration.UNDERGROUND_DECORATION, VegetationPlacements.f_195404_).feature(GenerationStep.Decoration.UNDERGROUND_DECORATION, VegetationPlacements.f_195405_).feature(GenerationStep.Decoration.UNDERGROUND_DECORATION, OrePlacements.f_195315_).feature(GenerationStep.Decoration.UNDERGROUND_DECORATION, NetherPlacements.f_195294_);
    }

    private static void addBNStructures(BCLBiomeBuilder builder) {
        builder.structure(NetherStructures.PYRAMIDS);
        builder.structure(NetherStructures.GHAST_HIVE);
        builder.structure(NetherTags.BETTER_NETHER_DECORATIONS);
    }

    public static NetherBiome create(NetherBiomeConfig data) {
        return NetherBiomeBuilder.create(data, null);
    }

    public static NetherBiome create(NetherBiomeConfig data, BCLBiome edgeBiome) {
        return NetherBiomeBuilder.create(data, null, edgeBiome);
    }

    public static NetherBiome createSubBiome(NetherBiomeConfig data, BCLBiome parentBiome) {
        return NetherBiomeBuilder.create(data, parentBiome, null);
    }

    private static NetherBiome create(NetherBiomeConfig data, BCLBiome parentBiome, BCLBiome edgeBiome) {
        ResourceLocation ID = data.ID;
        BCLBiomeBuilder builder = BCLBiomeBuilder.start((ResourceLocation)ID).surface(data.surface().build()).tag(new TagKey[]{NetherTags.BETTER_NETHER}).temperature(BCLBiomeBuilder.DEFAULT_NETHER_TEMPERATURE).wetness(BCLBiomeBuilder.DEFAULT_NETHER_WETNESS).precipitation(Biome.Precipitation.NONE).waterColor(BCLBiomeBuilder.DEFAULT_NETHER_WATER_COLOR).waterFogColor(BCLBiomeBuilder.DEFAULT_NETHER_WATER_FOG_COLOR).skyColor(BCLBiomeBuilder.calculateSkyColor((float)BCLBiomeBuilder.DEFAULT_NETHER_TEMPERATURE)).music((Holder)SoundEvents.f_12155_).mood((Holder)SoundEvents.f_12166_).loop((Holder)SoundEvents.f_12113_).additions((Holder)SoundEvents.f_12060_).edge(edgeBiome).parentBiome(parentBiome).netherBiome().feature(NetherVegetationPlaced.WART_CAP);
        if (data.hasVanillaStructures()) {
            NetherBiomeBuilder.addVanillaStructures(builder);
        }
        if (data.hasBNStructures()) {
            NetherBiomeBuilder.addBNStructures(builder);
        }
        if (data.hasVanillaFeatures()) {
            NetherBiomeBuilder.addVanillaFeatures(builder);
        }
        if (data.hasVanillaOres()) {
            builder.netherDefaultOres();
        }
        if (data.hasBNFeatures()) {
            NetherFeatures.addDefaultBNFeatures(builder);
        }
        for (NetherEntities.KnownSpawnTypes spawnType : NetherEntities.KnownSpawnTypes.values()) {
            spawnType.addSpawn(builder, data);
        }
        NetherFeatures.addDefaultFeatures(builder);
        if (data.hasDefaultOres()) {
            NetherFeatures.addDefaultOres(builder);
        }
        if (data.hasNetherCity()) {
            builder.structure(NetherStructures.CITY_STRUCTURE);
        }
        data.addCustomBuildData(builder);
        return (NetherBiome)builder.build(data.getSupplier()).biome();
    }

    public static List<BCLBiome> getAllBnBiomes() {
        return BiomeAPI.getAllBiomes((BiomeAPI.BiomeType)BiomeAPI.BiomeType.NETHER);
    }
}

