/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.registry;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.food.Foods;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.items.DebugDataItem;
import org.betterx.bclib.items.complex.EquipmentSet;
import org.betterx.bclib.registry.ItemRegistry;
import org.betterx.betternether.BetterNether;
import org.betterx.betternether.blocks.BNBlockProperties;
import org.betterx.betternether.config.Configs;
import org.betterx.betternether.integrations.VanillaExcavatorsIntegration;
import org.betterx.betternether.integrations.VanillaHammersIntegration;
import org.betterx.betternether.items.ItemBlackApple;
import org.betterx.betternether.items.ItemBowlFood;
import org.betterx.betternether.items.complex.DiamondSet;
import org.betterx.betternether.items.complex.NetherSet;
import org.betterx.betternether.items.materials.BNArmorMaterial;
import org.betterx.betternether.items.materials.BNToolMaterial;
import org.betterx.betternether.loot.BNLoot;
import org.betterx.worlds.together.tag.v3.CommonItemTags;
import org.betterx.worlds.together.tag.v3.TagManager;
import org.jetbrains.annotations.NotNull;

public class NetherItems
extends ItemRegistry {
    private static final List<String> ITEMS = new ArrayList<String>();
    private static final ArrayList<Item> MOD_BLOCKS = new ArrayList();
    private static final ArrayList<Item> MOD_ITEMS = new ArrayList();
    public static final Item BLACK_APPLE = NetherItems.registerItem("black_apple", new ItemBlackApple(), new TagKey[0]);
    public static final Item STALAGNATE_BOWL = NetherItems.registerItem("stalagnate_bowl", new ItemBowlFood(null, BNBlockProperties.FoodShape.NONE), new TagKey[0]);
    public static final Item STALAGNATE_BOWL_WART = NetherItems.registerItem("stalagnate_bowl_wart", new ItemBowlFood(Foods.f_38821_, BNBlockProperties.FoodShape.WART), new TagKey[0]);
    public static final Item STALAGNATE_BOWL_MUSHROOM = NetherItems.registerItem("stalagnate_bowl_mushroom", new ItemBowlFood(Foods.f_38834_, BNBlockProperties.FoodShape.MUSHROOM), new TagKey[0]);
    public static final Item STALAGNATE_BOWL_APPLE = NetherItems.registerItem("stalagnate_bowl_apple", new ItemBowlFood(Foods.f_38810_, BNBlockProperties.FoodShape.APPLE), new TagKey[0]);
    public static final Item HOOK_MUSHROOM_COOKED = NetherItems.registerFood("hook_mushroom_cooked", 4, 0.4f);
    public static final Item CINCINNASITE = NetherItems.registerItem("cincinnasite", new Item(NetherItems.defaultSettings()), new TagKey[0]);
    public static final Item CINCINNASITE_INGOT = NetherItems.registerItem("cincinnasite_ingot", new Item(NetherItems.defaultSettings()), CommonItemTags.IRON_INGOTS);
    public static final Item NETHER_RUBY = NetherItems.registerItem("nether_ruby", new Item(NetherItems.defaultSettings()), new TagKey[0]);
    public static final NetherSet CINCINNASITE_SET = new NetherSet("cincinnasite", BNToolMaterial.CINCINNASITE, BNArmorMaterial.CINCINNASITE, true).init();
    public static final NetherSet NETHER_RUBY_SET = new NetherSet("nether_ruby", BNToolMaterial.NETHER_RUBY, BNArmorMaterial.NETHER_RUBY, false).init();
    public static final DiamondSet CINCINNASITE_DIAMOND_SET = new DiamondSet(CINCINNASITE_SET).init();
    public static final NetherSet FLAMING_RUBY_SET = new NetherSet("flaming_ruby", NETHER_RUBY_SET, BNToolMaterial.FLAMING_RUBY, BNArmorMaterial.FLAMING_RUBY, false).init();
    public static final Item CINCINNASITE_HAMMER = NetherItems.registerItem("cincinnasite_hammer", VanillaHammersIntegration.makeHammer(BNToolMaterial.CINCINNASITE, 4, -2.0f), new TagKey[0]);
    public static final Item CINCINNASITE_HAMMER_DIAMOND = NetherItems.registerItem("cincinnasite_hammer_diamond", VanillaHammersIntegration.makeHammer(BNToolMaterial.CINCINNASITE_DIAMOND, 5, -2.0f), new TagKey[0]);
    public static final Item NETHER_RUBY_HAMMER = NetherItems.registerItem("nether_ruby_hammer", VanillaHammersIntegration.makeHammer(BNToolMaterial.NETHER_RUBY, 5, -2.0f), new TagKey[0]);
    public static final Item CINCINNASITE_EXCAVATOR = NetherItems.registerItem("cincinnasite_excavator", VanillaExcavatorsIntegration.makeExcavator(BNToolMaterial.CINCINNASITE, 4, -1.6f), new TagKey[0]);
    public static final Item CINCINNASITE_EXCAVATOR_DIAMOND = NetherItems.registerItem("cincinnasite_excavator_diamond", VanillaExcavatorsIntegration.makeExcavator(BNToolMaterial.CINCINNASITE_DIAMOND, 5, -2.0f), new TagKey[0]);
    public static final Item NETHER_RUBY_EXCAVATOR = NetherItems.registerItem("nether_ruby_excavator", VanillaExcavatorsIntegration.makeExcavator(BNToolMaterial.NETHER_RUBY, 5, -2.0f), new TagKey[0]);
    public static final Item GLOWSTONE_PILE = NetherItems.registerItem("glowstone_pile", new Item(NetherItems.defaultSettings()), new TagKey[0]);
    public static final Item LAPIS_PILE = NetherItems.registerItem("lapis_pile", new Item(NetherItems.defaultSettings()), new TagKey[0]);
    public static final Item AGAVE_LEAF = NetherItems.registerItem("agave_leaf", new Item(NetherItems.defaultSettings()), new TagKey[0]);
    public static final Item AGAVE_MEDICINE = NetherItems.registerMedicine("agave_medicine", 40, 2, true);
    public static final Item HERBAL_MEDICINE = NetherItems.registerMedicine("herbal_medicine", 10, 5, true);
    private static ItemRegistry ITEMS_REGISTRY;

    protected NetherItems() {
        super(Configs.ITEMS);
    }

    @NotNull
    public static ItemRegistry getItemRegistry() {
        if (ITEMS_REGISTRY == null) {
            ITEMS_REGISTRY = new NetherItems();
        }
        return ITEMS_REGISTRY;
    }

    public static List<Item> getModItems() {
        return NetherItems.getModItems((String)"betternether");
    }

    public static Item registerShears(String name, Item item) {
        if (item != Items.f_41852_) {
            return NetherItems.getItemRegistry().registerTool(BetterNether.makeID(name), item);
        }
        return item;
    }

    public static Item registerTool(String name, Item item, TagKey<Item> ... tags) {
        if (item != Items.f_41852_) {
            NetherItems.getItemRegistry().registerTool(BetterNether.makeID(name), item);
            if (tags.length > 0) {
                TagManager.ITEMS.add((Object)item, tags);
            }
            MOD_ITEMS.add(item);
        }
        ITEMS.add(name);
        return item;
    }

    public static Item registerItem(String name, Item item, TagKey<Item> ... tags) {
        if ((item instanceof BlockItem || Configs.ITEMS.getBoolean("items", name, true)) && item != Items.f_41852_) {
            NetherItems.getItemRegistry().register(BetterNether.makeID(name), item);
            if (tags.length > 0) {
                TagManager.ITEMS.add((Object)item, tags);
            }
            if (item instanceof BlockItem) {
                MOD_BLOCKS.add(item);
            } else {
                MOD_ITEMS.add(item);
            }
        }
        if (!(item instanceof BlockItem)) {
            ITEMS.add(name);
        }
        return item;
    }

    public static Item registerFood(String name, int hunger, float saturationMultiplier) {
        return NetherItems.registerItem(name, new Item(NetherItems.defaultSettings().m_41489_(new FoodProperties.Builder().m_38760_(hunger).m_38758_(saturationMultiplier).m_38767_())), new TagKey[0]);
    }

    public static Item registerMedicine(String name, int ticks, int power, boolean bowl) {
        if (bowl) {
            Item item = new Item(NetherItems.defaultSettings().m_41487_(16).m_41489_(new FoodProperties.Builder().m_38762_(new MobEffectInstance(MobEffects.f_19605_, ticks, power), 1.0f).m_38767_())){

                public ItemStack m_5922_(ItemStack stack, Level world, LivingEntity user) {
                    Player player;
                    if (stack.m_41613_() == 1) {
                        super.m_5922_(stack, world, user);
                        return new ItemStack((ItemLike)STALAGNATE_BOWL, stack.m_41613_());
                    }
                    if (user instanceof Player && !(player = (Player)user).m_7500_()) {
                        player.m_36356_(new ItemStack((ItemLike)STALAGNATE_BOWL));
                    }
                    return super.m_5922_(stack, world, user);
                }
            };
            return NetherItems.registerItem(name, item, new TagKey[0]);
        }
        return NetherItems.registerItem(name, new Item(NetherItems.defaultSettings().m_41489_(new FoodProperties.Builder().m_38762_(new MobEffectInstance(MobEffects.f_19605_, ticks, power), 1.0f).m_38767_())), new TagKey[0]);
    }

    public static Item.Properties defaultSettings() {
        return new Item.Properties();
    }

    public static Item makeEgg(String name, EntityType<? extends Mob> type, int background, int dots) {
        if (Configs.MOBS.getBoolean("mobs", name, true)) {
            SpawnEggItem egg = new SpawnEggItem(type, background, dots, NetherItems.defaultSettings());
            DefaultDispenseItemBehavior behavior = new DefaultDispenseItemBehavior(){

                public ItemStack m_7498_(BlockSource pointer, ItemStack stack) {
                    Direction direction = (Direction)pointer.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
                    EntityType entityType = ((SpawnEggItem)stack.m_41720_()).m_43228_(stack.m_41783_());
                    entityType.m_20592_(pointer.m_7727_(), stack, null, pointer.m_7961_().m_121945_(direction), MobSpawnType.DISPENSER, direction != Direction.UP, false);
                    stack.m_41774_(1);
                    return stack;
                }
            };
            DispenserBlock.m_52672_((ItemLike)egg, (DispenseItemBehavior)behavior);
            NetherItems.registerItem(name, (Item)egg, new TagKey[0]);
            return egg;
        }
        return Items.f_41852_;
    }

    public static Item registerNetherItem(String name, Item item) {
        return NetherItems.getItemRegistry().register(BetterNether.makeID(name), item);
    }

    private static CompoundTag buildItem(int count, Item item, Enchantment ... enchantments) {
        ResourceLocation id = BuiltInRegistries.f_257033_.m_7981_((Object)item);
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("id", id.toString());
        tag.m_128344_("Count", (byte)count);
        if (enchantments.length > 0) {
            ListTag chants = new ListTag();
            tag.m_128365_("Enchantments", (Tag)chants);
            for (Enchantment e : enchantments) {
                ResourceLocation eID = BuiltInRegistries.f_256876_.m_7981_((Object)e);
                chants.add((Object)EnchantmentHelper.m_182443_((ResourceLocation)eID, (int)e.m_6586_()));
            }
        }
        return tag;
    }

    @NotNull
    private static CompoundTag buildCitySpawnerData() {
        ListTag handItems = new ListTag();
        handItems.add((Object)NetherItems.buildItem(1, CINCINNASITE_DIAMOND_SET.getSlot(EquipmentSet.SWORD_SLOT), new Enchantment[0]));
        handItems.add((Object)NetherItems.buildItem(1, Items.f_42740_, new Enchantment[0]));
        ListTag armorItems = new ListTag();
        armorItems.add((Object)NetherItems.buildItem(1, CINCINNASITE_SET.getSlot(EquipmentSet.BOOTS_SLOT), Enchantments.f_44965_));
        armorItems.add((Object)NetherItems.buildItem(1, CINCINNASITE_SET.getSlot(EquipmentSet.LEGGINGS_SLOT), Enchantments.f_44965_));
        armorItems.add((Object)NetherItems.buildItem(1, CINCINNASITE_SET.getSlot(EquipmentSet.CHESTPLATE_SLOT), Enchantments.f_44965_, Enchantments.f_44972_));
        armorItems.add((Object)NetherItems.buildItem(1, CINCINNASITE_SET.getSlot(EquipmentSet.HELMET_SLOT), Enchantments.f_44965_));
        ListTag handDropChance = new ListTag();
        handDropChance.add((Object)FloatTag.m_128566_((float)0.0f));
        handDropChance.add((Object)FloatTag.m_128566_((float)0.0f));
        ListTag armorDropChance = new ListTag();
        armorDropChance.add((Object)FloatTag.m_128566_((float)0.0f));
        armorDropChance.add((Object)FloatTag.m_128566_((float)0.0f));
        armorDropChance.add((Object)FloatTag.m_128566_((float)0.0f));
        armorDropChance.add((Object)FloatTag.m_128566_((float)0.0f));
        CompoundTag entity = new CompoundTag();
        entity.m_128359_("id", BuiltInRegistries.f_256780_.m_7981_((Object)EntityType.f_20497_).toString());
        entity.m_128379_("PersistenceRequired", true);
        entity.m_128365_("HandItems", (Tag)handItems);
        entity.m_128365_("ArmorItems", (Tag)armorItems);
        entity.m_128365_("HandDropChances", (Tag)handDropChance);
        entity.m_128365_("ArmorDropChances", (Tag)armorDropChance);
        CompoundTag skyLightLimit = new CompoundTag();
        skyLightLimit.m_128344_("max_inclusive", (byte)13);
        CompoundTag blockLightLimit = new CompoundTag();
        skyLightLimit.m_128344_("max_inclusive", (byte)13);
        CompoundTag customSpawnRules = new CompoundTag();
        customSpawnRules.m_128365_("sky_light_limit", (Tag)skyLightLimit);
        customSpawnRules.m_128365_("block_light_limit", (Tag)blockLightLimit);
        CompoundTag spawnData = new CompoundTag();
        spawnData.m_128365_("entity", (Tag)entity);
        spawnData.m_128365_("custom_spawn_rules", (Tag)customSpawnRules);
        CompoundTag root = new CompoundTag();
        root.m_128376_("SpawnRange", (short)4);
        root.m_128376_("SpawnCount", (short)8);
        root.m_128376_("MaxNearbyEntities", (short)18);
        root.m_128376_("Delay", (short)499);
        root.m_128376_("MinSpawnDelay", (short)300);
        root.m_128376_("MaxSpawnDelay", (short)1600);
        root.m_128376_("RequiredPlayerRange", (short)20);
        root.m_128365_("SpawnData", (Tag)spawnData);
        return root;
    }

    static {
        if (BCLib.isDevEnvironment()) {
            BetterNether.LOGGER.warning("Generating Debug Helpers", new Object[0]);
            NetherItems.registerNetherItem("debug/city_loot", (Item)DebugDataItem.forLootTable((ResourceLocation)BNLoot.CITY_LOOT, (Item)Items.f_42416_));
            NetherItems.registerNetherItem("debug/city_loot_common", (Item)DebugDataItem.forLootTable((ResourceLocation)BNLoot.CITY_LOOT_COMMON, (Item)Items.f_42417_));
            NetherItems.registerNetherItem("debug/city_loot_surprise", (Item)DebugDataItem.forLootTable((ResourceLocation)BNLoot.CITY_LOOT_SURPRISE, (Item)Items.f_42415_));
            CompoundTag root = NetherItems.buildCitySpawnerData();
            NetherItems.registerNetherItem("debug/city_spawner", (Item)DebugDataItem.forSpawner((CompoundTag)root, (Item)Items.f_42737_));
        }
    }
}

