/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.registry;

import java.util.List;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import org.betterx.bclib.api.v3.tag.BCLBlockTags;
import org.betterx.bclib.blocks.BaseButtonBlock;
import org.betterx.bclib.blocks.BaseChestBlock;
import org.betterx.bclib.blocks.BasePressurePlateBlock;
import org.betterx.bclib.blocks.BaseSlabBlock;
import org.betterx.bclib.blocks.BaseStairsBlock;
import org.betterx.bclib.complexmaterials.set.wood.BarStool;
import org.betterx.bclib.complexmaterials.set.wood.Chair;
import org.betterx.bclib.complexmaterials.set.wood.Taburet;
import org.betterx.bclib.complexmaterials.set.wood.WoodSlots;
import org.betterx.bclib.furniture.block.BaseBarStool;
import org.betterx.bclib.furniture.block.BaseChair;
import org.betterx.bclib.furniture.block.BaseTaburet;
import org.betterx.bclib.registry.BlockRegistry;
import org.betterx.betternether.blocks.BNBoneBlock;
import org.betterx.betternether.blocks.BNBrewingStand;
import org.betterx.betternether.blocks.BNChain;
import org.betterx.betternether.blocks.BNGlass;
import org.betterx.betternether.blocks.BNLeaves;
import org.betterx.betternether.blocks.BNNetherBrick;
import org.betterx.betternether.blocks.BNObsidian;
import org.betterx.betternether.blocks.BNPane;
import org.betterx.betternether.blocks.BNPillar;
import org.betterx.betternether.blocks.BNWall;
import org.betterx.betternether.blocks.BNWoodlikeDoor;
import org.betterx.betternether.blocks.BaseBlockNetherGrass;
import org.betterx.betternether.blocks.BlockAgave;
import org.betterx.betternether.blocks.BlockAnchorTreeVine;
import org.betterx.betternether.blocks.BlockBNPot;
import org.betterx.betternether.blocks.BlockBarrelCactus;
import org.betterx.betternether.blocks.BlockBase;
import org.betterx.betternether.blocks.BlockBlackApple;
import org.betterx.betternether.blocks.BlockBlackAppleSeed;
import org.betterx.betternether.blocks.BlockBlackBush;
import org.betterx.betternether.blocks.BlockBlackVine;
import org.betterx.betternether.blocks.BlockBoneMushroom;
import org.betterx.betternether.blocks.BlockBrownLargeMushroom;
import org.betterx.betternether.blocks.BlockChestOfDrawers;
import org.betterx.betternether.blocks.BlockCincinnasitPillar;
import org.betterx.betternether.blocks.BlockCincinnasite;
import org.betterx.betternether.blocks.BlockCincinnasiteAnvil;
import org.betterx.betternether.blocks.BlockCincinnasiteForge;
import org.betterx.betternether.blocks.BlockCincinnasiteFrame;
import org.betterx.betternether.blocks.BlockCincinnasiteLantern;
import org.betterx.betternether.blocks.BlockCincinnasitePedestal;
import org.betterx.betternether.blocks.BlockEggPlant;
import org.betterx.betternether.blocks.BlockEyeSeed;
import org.betterx.betternether.blocks.BlockEyeVine;
import org.betterx.betternether.blocks.BlockEyeball;
import org.betterx.betternether.blocks.BlockEyeballSmall;
import org.betterx.betternether.blocks.BlockFarmland;
import org.betterx.betternether.blocks.BlockFeatherFern;
import org.betterx.betternether.blocks.BlockFireBowl;
import org.betterx.betternether.blocks.BlockGeyser;
import org.betterx.betternether.blocks.BlockGiantLucis;
import org.betterx.betternether.blocks.BlockGiantMold;
import org.betterx.betternether.blocks.BlockGiantMoldSapling;
import org.betterx.betternether.blocks.BlockGoldenVine;
import org.betterx.betternether.blocks.BlockGrayMold;
import org.betterx.betternether.blocks.BlockHookMushroom;
import org.betterx.betternether.blocks.BlockInkBush;
import org.betterx.betternether.blocks.BlockInkBushSeed;
import org.betterx.betternether.blocks.BlockJellyfishMushroom;
import org.betterx.betternether.blocks.BlockJellyfishMushroomSapling;
import org.betterx.betternether.blocks.BlockLucisMushroom;
import org.betterx.betternether.blocks.BlockLucisSpore;
import org.betterx.betternether.blocks.BlockLumabusSeed;
import org.betterx.betternether.blocks.BlockLumabusVine;
import org.betterx.betternether.blocks.BlockMagmaFlower;
import org.betterx.betternether.blocks.BlockMossCover;
import org.betterx.betternether.blocks.BlockNeonEquisetum;
import org.betterx.betternether.blocks.BlockNetherCactus;
import org.betterx.betternether.blocks.BlockNetherFurnace;
import org.betterx.betternether.blocks.BlockNetherGrass;
import org.betterx.betternether.blocks.BlockNetherMycelium;
import org.betterx.betternether.blocks.BlockNetherReed;
import org.betterx.betternether.blocks.BlockNetherRuby;
import org.betterx.betternether.blocks.BlockNetherSakuraLeaves;
import org.betterx.betternether.blocks.BlockObsidianGlass;
import org.betterx.betternether.blocks.BlockOrangeMushroom;
import org.betterx.betternether.blocks.BlockOre;
import org.betterx.betternether.blocks.BlockPlantWall;
import org.betterx.betternether.blocks.BlockPottedPlant;
import org.betterx.betternether.blocks.BlockRedLargeMushroom;
import org.betterx.betternether.blocks.BlockRedMold;
import org.betterx.betternether.blocks.BlockRubeusLeaves;
import org.betterx.betternether.blocks.BlockSmallLantern;
import org.betterx.betternether.blocks.BlockSmoker;
import org.betterx.betternether.blocks.BlockSoulGrass;
import org.betterx.betternether.blocks.BlockSoulLily;
import org.betterx.betternether.blocks.BlockSoulLilySapling;
import org.betterx.betternether.blocks.BlockSoulSandstone;
import org.betterx.betternether.blocks.BlockSoulVein;
import org.betterx.betternether.blocks.BlockStalactite;
import org.betterx.betternether.blocks.BlockStatueRespawner;
import org.betterx.betternether.blocks.BlockTerrain;
import org.betterx.betternether.blocks.BlockVeinedSand;
import org.betterx.betternether.blocks.BlockWhisperingGourd;
import org.betterx.betternether.blocks.BlockWhisperingGourdLantern;
import org.betterx.betternether.blocks.BlockWhisperingGourdVine;
import org.betterx.betternether.blocks.BlockWillowLeaves;
import org.betterx.betternether.blocks.BlueCryingObsidianBlock;
import org.betterx.betternether.blocks.BlueWeepingObsidianBlock;
import org.betterx.betternether.blocks.RedstoneOreBlock;
import org.betterx.betternether.blocks.VanillaWeepingObsidianBlock;
import org.betterx.betternether.blocks.complex.AnchorTreeMaterial;
import org.betterx.betternether.blocks.complex.ColoredGlassMaterial;
import org.betterx.betternether.blocks.complex.MushroomFirMaterial;
import org.betterx.betternether.blocks.complex.NetherMushroomMaterial;
import org.betterx.betternether.blocks.complex.NetherReedMaterial;
import org.betterx.betternether.blocks.complex.NetherSakuraMaterial;
import org.betterx.betternether.blocks.complex.RubeusMaterial;
import org.betterx.betternether.blocks.complex.StalagnateMaterial;
import org.betterx.betternether.blocks.complex.WartMaterial;
import org.betterx.betternether.blocks.complex.WillowMaterial;
import org.betterx.betternether.blocks.complex.slots.VanillaNetherWood;
import org.betterx.betternether.blocks.complex.slots.VanillaWood;
import org.betterx.betternether.config.Configs;
import org.betterx.betternether.recipes.RecipesHelper;
import org.betterx.betternether.registry.NetherItems;
import org.betterx.betternether.registry.NetherTags;
import org.betterx.betternether.registry.features.configured.NetherVines;
import org.betterx.worlds.together.tag.v3.CommonBlockTags;
import org.betterx.worlds.together.tag.v3.TagManager;
import org.jetbrains.annotations.NotNull;

public class NetherBlocks
extends BlockRegistry {
    public static final Block NETHER_REED_STEM = NetherBlocks.registerBlock("nether_reed_stem", new BlockNetherReed(), new TagKey[0]);
    public static final NetherReedMaterial MAT_REED = (NetherReedMaterial)((Object)new NetherReedMaterial().init());
    public static final StalagnateMaterial MAT_STALAGNATE = (StalagnateMaterial)((Object)new StalagnateMaterial().init());
    public static final WillowMaterial MAT_WILLOW = new WillowMaterial().init();
    public static final Block WILLOW_LEAVES = NetherBlocks.registerBlock("willow_leaves", new BlockWillowLeaves(MAT_WILLOW.getSapling()), new TagKey[0]);
    public static final WartMaterial MAT_WART = (WartMaterial)((Object)new WartMaterial("wart", MapColor.f_283913_, MapColor.f_283913_).init());
    public static final Block CINCINNASITE_ORE = NetherBlocks.registerBlock("cincinnasite_ore", new BlockOre(() -> NetherItems.CINCINNASITE, 1, 3, 0, Tiers.IRON.m_6604_(), true), new TagKey[0]);
    public static final Block CINCINNASITE_BLOCK = NetherBlocks.registerBlock("cincinnasite_block", new BlockCincinnasite(), new TagKey[0]);
    public static final Block CINCINNASITE_FORGED = NetherBlocks.registerBlock("cincinnasite_forged", new BlockCincinnasite(), new TagKey[0]);
    public static final Block CINCINNASITE_PILLAR = NetherBlocks.registerBlock("cincinnasite_pillar", new BlockCincinnasitPillar(), new TagKey[0]);
    public static final Block CINCINNASITE_BRICKS = NetherBlocks.registerBlock("cincinnasite_bricks", new BlockCincinnasite(), new TagKey[0]);
    public static final Block CINCINNASITE_BRICK_PLATE = NetherBlocks.registerBlock("cincinnasite_brick_plate", new BlockCincinnasite(), new TagKey[0]);
    public static final Block CINCINNASITE_STAIRS = NetherBlocks.registerStairs("cincinnasite_stairs", CINCINNASITE_FORGED, false, new TagKey[0]);
    public static final Block CINCINNASITE_SLAB = NetherBlocks.registerSlab("cincinnasite_slab", CINCINNASITE_FORGED, false, new TagKey[0]);
    public static final Block TABURET_CINCINNASITE = NetherBlocks.registerTaburet("taburet_cincinnasite", CINCINNASITE_SLAB);
    public static final Block CHAIR_CINCINNASITE = NetherBlocks.registerChair("chair_cincinnasite", CINCINNASITE_SLAB);
    public static final Block BAR_STOOL_CINCINNASITE = NetherBlocks.registerBarStool("bar_stool_cincinnasite", CINCINNASITE_SLAB);
    public static final Block CINCINNASITE_BUTTON = NetherBlocks.registerBlock("cincinnasite_button", BaseButtonBlock.from((Block)CINCINNASITE_FORGED, (BlockSetType)BlockSetType.f_271208_), new TagKey[0]);
    public static final Block CINCINNASITE_PLATE = NetherBlocks.registerPlate("cincinnasite_plate", CINCINNASITE_FORGED, BlockSetType.f_271208_);
    public static final Block CINCINNASITE_LANTERN = NetherBlocks.registerBlock("cincinnasite_lantern", new BlockCincinnasiteLantern(), new TagKey[0]);
    public static final Block CINCINNASITE_TILE_LARGE = NetherBlocks.registerBlock("cincinnasite_tile_large", new BlockCincinnasite(), new TagKey[0]);
    public static final Block CINCINNASITE_TILE_SMALL = NetherBlocks.registerBlock("cincinnasite_tile_small", new BlockCincinnasite(), new TagKey[0]);
    public static final Block CINCINNASITE_CARVED = NetherBlocks.registerBlock("cincinnasite_carved", new BlockCincinnasite(), new TagKey[0]);
    public static final Block CINCINNASITE_WALL = NetherBlocks.registerWall("cincinnasite_wall", CINCINNASITE_FORGED);
    public static final Block CINCINNASITE_BRICKS_PILLAR = NetherBlocks.registerBlock("cincinnasite_bricks_pillar", new BNPillar.Metal(CINCINNASITE_FORGED), new TagKey[0]);
    public static final Block CINCINNASITE_BARS = NetherBlocks.registerBlock("cincinnasite_bars", new BNPane.Metal(CINCINNASITE_FORGED, true), new TagKey[0]);
    public static final Block CINCINNASITE_PEDESTAL = NetherBlocks.registerBlock("cincinnasite_pedestal", new BlockCincinnasitePedestal(), new TagKey[0]);
    public static final Block CINCINNASITE_FRAME = NetherBlocks.registerBlock("cincinnasite_frame", new BlockCincinnasiteFrame(), new TagKey[0]);
    public static final Block CINCINNASITE_LANTERN_SMALL = NetherBlocks.registerBlock("cincinnasite_lantern_small", new BlockSmallLantern.Metal(), new TagKey[0]);
    public static final Block CINCINNASITE_CHAIN = NetherBlocks.registerBlock("cincinnasite_chain", new BNChain(), new TagKey[0]);
    public static final Block NETHER_RUBY_ORE = NetherBlocks.registerBlock("nether_ruby_ore", new BlockOre(() -> NetherItems.NETHER_RUBY, 1, 2, 5, Tiers.DIAMOND.m_6604_(), true), new TagKey[0]);
    public static final Block NETHER_RUBY_BLOCK = NetherBlocks.registerBlock("nether_ruby_block", new BlockNetherRuby(), new TagKey[0]);
    public static final Block NETHER_RUBY_STAIRS = NetherBlocks.registerStairs("nether_ruby_stairs", NETHER_RUBY_BLOCK, true, new TagKey[0]);
    public static final Block NETHER_RUBY_SLAB = NetherBlocks.registerSlab("nether_ruby_slab", NETHER_RUBY_BLOCK, true, new TagKey[0]);
    public static final Block NETHER_LAPIS_ORE = NetherBlocks.registerBlock("nether_lapis_ore", new BlockOre(() -> NetherItems.LAPIS_PILE, 3, 6, 3, Tiers.IRON.m_6604_(), false), new TagKey[0]);
    public static final Block NETHER_REDSTONE_ORE = NetherBlocks.registerBlock("nether_redstone_ore", new RedstoneOreBlock(), new TagKey[0]);
    public static final Block NETHER_BRICK_TILE_LARGE = NetherBlocks.registerBlock("nether_brick_tile_large", new BNNetherBrick(), new TagKey[0]);
    public static final Block NETHER_BRICK_TILE_SMALL = NetherBlocks.registerBlock("nether_brick_tile_small", new BNNetherBrick(), new TagKey[0]);
    public static final Block NETHER_BRICK_WALL = NetherBlocks.registerWall("nether_brick_wall", NETHER_BRICK_TILE_LARGE);
    public static final Block NETHER_BRICK_TILE_SLAB = NetherBlocks.registerSlab("nether_brick_tile_slab", NETHER_BRICK_TILE_SMALL, false, new TagKey[0]);
    public static final Block NETHER_BRICK_TILE_STAIRS = NetherBlocks.registerStairs("nether_brick_tile_stairs", NETHER_BRICK_TILE_SMALL, false, new TagKey[0]);
    public static final Block BONE_BLOCK = NetherBlocks.registerBlock("bone_block", new BNBoneBlock(), new TagKey[0]);
    public static final Block BONE_STAIRS = NetherBlocks.registerStairs("bone_stairs", BONE_BLOCK, false, new TagKey[0]);
    public static final Block BONE_SLAB = NetherBlocks.registerSlab("bone_slab", BONE_BLOCK, false, new TagKey[0]);
    public static final Block BONE_BUTTON = NetherBlocks.registerButton("bone_button", BONE_BLOCK, BlockSetType.f_271290_);
    public static final Block BONE_PLATE = NetherBlocks.registerPlate("bone_plate", BONE_BLOCK, BlockSetType.f_271290_);
    public static final Block BONE_WALL = NetherBlocks.registerWall("bone_wall", BONE_BLOCK);
    public static final Block BONE_TILE = NetherBlocks.registerBlock("bone_tile", new BNBoneBlock(), new TagKey[0]);
    public static final Block BONE_REED_DOOR = NetherBlocks.registerBlock("bone_reed_door", new BNWoodlikeDoor(BONE_BLOCK, WoodType.f_61836_), new TagKey[0]);
    public static final Block BONE_CINCINNASITE_DOOR = NetherBlocks.registerBlock("bone_cincinnasite_door", new BNWoodlikeDoor(BONE_BLOCK, WoodType.f_61836_), new TagKey[0]);
    public static final Block QUARTZ_GLASS = NetherBlocks.registerBlock("quartz_glass", new BNGlass(Blocks.f_50058_), new TagKey[0]);
    public static final Block QUARTZ_GLASS_FRAMED = NetherBlocks.registerBlock("quartz_glass_framed", new BNGlass(CINCINNASITE_BLOCK), new TagKey[0]);
    public static final ColoredGlassMaterial QUARTZ_GLASS_FRAMED_COLORED = new ColoredGlassMaterial("quartz_glass_framed", QUARTZ_GLASS_FRAMED);
    public static final Block QUARTZ_GLASS_PANE = NetherBlocks.registerBlock("quartz_glass_pane", new BNPane.Glass(QUARTZ_GLASS, true), new TagKey[0]);
    public static final ColoredGlassMaterial QUARTZ_GLASS_PANE_COLORED = new ColoredGlassMaterial("quartz_glass_pane", QUARTZ_GLASS_PANE, false);
    public static final Block QUARTZ_GLASS_FRAMED_PANE = NetherBlocks.registerBlock("quartz_glass_framed_pane", new BNPane.Metal(CINCINNASITE_BLOCK, true), new TagKey[0]);
    public static final ColoredGlassMaterial QUARTZ_GLASS_FRAMED_PANE_COLORED = new ColoredGlassMaterial("quartz_glass_framed_pane", QUARTZ_GLASS_FRAMED_PANE, true);
    public static final ColoredGlassMaterial QUARTZ_GLASS_COLORED = new ColoredGlassMaterial("quartz_glass", QUARTZ_GLASS);
    public static final Block BLUE_WEEPING_OBSIDIAN = NetherBlocks.registerBlock("blue_weeping_obsidian", new BlueWeepingObsidianBlock(), new TagKey[0]);
    public static final Block WEEPING_OBSIDIAN = NetherBlocks.registerBlock("weeping_obsidian", new VanillaWeepingObsidianBlock(), new TagKey[0]);
    public static final Block BLUE_CRYING_OBSIDIAN = NetherBlocks.registerBlock("blue_crying_obsidian", new BlueCryingObsidianBlock(), new TagKey[0]);
    public static final Block OBSIDIAN_BRICKS = NetherBlocks.registerBlock("obsidian_bricks", new BNObsidian(), new TagKey[0]);
    public static final Block OBSIDIAN_BRICKS_STAIRS = NetherBlocks.registerStairs("obsidian_bricks_stairs", OBSIDIAN_BRICKS, false, new TagKey[0]);
    public static final Block OBSIDIAN_BRICKS_SLAB = NetherBlocks.registerSlab("obsidian_bricks_slab", OBSIDIAN_BRICKS, false, new TagKey[0]);
    public static final Block OBSIDIAN_TILE = NetherBlocks.registerBlock("obsidian_tile", new BNObsidian(), new TagKey[0]);
    public static final Block OBSIDIAN_TILE_SMALL = NetherBlocks.registerBlock("obsidian_tile_small", new BNObsidian(), new TagKey[0]);
    public static final Block OBSIDIAN_TILE_STAIRS = NetherBlocks.registerStairs("obsidian_tile_stairs", OBSIDIAN_TILE_SMALL, false, new TagKey[0]);
    public static final Block OBSIDIAN_TILE_SLAB = NetherBlocks.registerSlab("obsidian_tile_slab", OBSIDIAN_TILE_SMALL, false, new TagKey[0]);
    public static final Block OBSIDIAN_ROD_TILES = NetherBlocks.registerBlock("obsidian_rod_tiles", new BNObsidian(), new TagKey[0]);
    public static final Block OBSIDIAN_GLASS = NetherBlocks.registerBlock("obsidian_glass", new BlockObsidianGlass(), new TagKey[0]);
    public static final Block OBSIDIAN_GLASS_PANE = NetherBlocks.registerBlock("obsidian_glass_pane", new BNPane.Glass(OBSIDIAN_GLASS, true), new TagKey[0]);
    public static final Block BLUE_OBSIDIAN = NetherBlocks.registerBlock("blue_obsidian", new BNObsidian(BLUE_CRYING_OBSIDIAN), new TagKey[0]);
    public static final Block BLUE_OBSIDIAN_BRICKS = NetherBlocks.registerBlock("blue_obsidian_bricks", new BNObsidian(), new TagKey[0]);
    public static final Block BLUE_OBSIDIAN_BRICKS_STAIRS = NetherBlocks.registerStairs("blue_obsidian_bricks_stairs", BLUE_OBSIDIAN_BRICKS, false, new TagKey[0]);
    public static final Block BLUE_OBSIDIAN_BRICKS_SLAB = NetherBlocks.registerSlab("blue_obsidian_bricks_slab", BLUE_OBSIDIAN_BRICKS, false, new TagKey[0]);
    public static final Block BLUE_OBSIDIAN_TILE = NetherBlocks.registerBlock("blue_obsidian_tile", new BNObsidian(), new TagKey[0]);
    public static final Block BLUE_OBSIDIAN_TILE_SMALL = NetherBlocks.registerBlock("blue_obsidian_tile_small", new BNObsidian(), new TagKey[0]);
    public static final Block BLUE_OBSIDIAN_TILE_STAIRS = NetherBlocks.registerStairs("blue_obsidian_tile_stairs", BLUE_OBSIDIAN_TILE_SMALL, false, new TagKey[0]);
    public static final Block BLUE_OBSIDIAN_TILE_SLAB = NetherBlocks.registerSlab("blue_obsidian_tile_slab", BLUE_OBSIDIAN_TILE_SMALL, false, new TagKey[0]);
    public static final Block BLUE_OBSIDIAN_ROD_TILES = NetherBlocks.registerBlock("blue_obsidian_rod_tiles", new BNObsidian(), new TagKey[0]);
    public static final Block BLUE_OBSIDIAN_GLASS = NetherBlocks.registerBlock("blue_obsidian_glass", new BlockObsidianGlass(), new TagKey[0]);
    public static final Block BLUE_OBSIDIAN_GLASS_PANE = NetherBlocks.registerBlock("blue_obsidian_glass_pane", new BNPane.Glass(BLUE_OBSIDIAN_GLASS, true), new TagKey[0]);
    public static final Block SOUL_SANDSTONE = NetherBlocks.registerMakeable2X2Soul("soul_sandstone", new BlockSoulSandstone(), "soul_sandstone", RecipeCategory.BUILDING_BLOCKS, Blocks.f_50135_);
    public static final Block SOUL_SANDSTONE_CUT = NetherBlocks.registerMakeable2X2Soul("soul_sandstone_cut", new BlockSoulSandstone(), "soul_sandstone", RecipeCategory.BUILDING_BLOCKS, SOUL_SANDSTONE);
    public static final Block SOUL_SANDSTONE_CUT_STAIRS = NetherBlocks.registerStairs("soul_sandstone_cut_stairs", SOUL_SANDSTONE_CUT, false, BlockTags.f_13080_, BlockTags.f_13085_);
    public static final Block SOUL_SANDSTONE_CUT_SLAB = NetherBlocks.registerSlab("soul_sandstone_cut_slab", SOUL_SANDSTONE_CUT, false, new TagKey[0]);
    public static final Block SOUL_SANDSTONE_WALL = NetherBlocks.registerWall("soul_sandstone_wall", SOUL_SANDSTONE_CUT);
    public static final Block SOUL_SANDSTONE_SMOOTH = NetherBlocks.registerSoulBlock("soul_sandstone_smooth", new BlockBase.Stone(Blocks.f_50062_));
    public static final Block SOUL_SANDSTONE_CHISELED = NetherBlocks.registerMakeable2X2Soul("soul_sandstone_chiseled", new BlockBase.Stone(Blocks.f_50062_), "soul_sandstone", RecipeCategory.BUILDING_BLOCKS, SOUL_SANDSTONE_SMOOTH);
    public static final Block SOUL_SANDSTONE_STAIRS = NetherBlocks.registerStairs("soul_sandstone_stairs", SOUL_SANDSTONE, false, BlockTags.f_13080_, BlockTags.f_13085_);
    public static final Block SOUL_SANDSTONE_SMOOTH_STAIRS = NetherBlocks.registerStairs("soul_sandstone_smooth_stairs", SOUL_SANDSTONE_SMOOTH, false, BlockTags.f_13080_, BlockTags.f_13085_);
    public static final Block SOUL_SANDSTONE_SLAB = NetherBlocks.registerSlab("soul_sandstone_slab", SOUL_SANDSTONE, false, new TagKey[0]);
    public static final Block SOUL_SANDSTONE_SMOOTH_SLAB = NetherBlocks.registerSlab("soul_sandstone_smooth_slab", SOUL_SANDSTONE_SMOOTH, false, new TagKey[0]);
    public static final Block BASALT_BRICKS = NetherBlocks.registerMakeable2X2("basalt_bricks", new BlockBase.Stone((BlockBehaviour.Properties)FabricBlockSettings.copyOf((BlockBehaviour)Blocks.f_50137_)), "basalt_bricks", RecipeCategory.BUILDING_BLOCKS, Blocks.f_50138_);
    public static final Block BASALT_BRICKS_STAIRS = NetherBlocks.registerStairs("basalt_bricks_stairs", BASALT_BRICKS, false, new TagKey[0]);
    public static final Block BASALT_BRICKS_SLAB = NetherBlocks.registerSlab("basalt_bricks_slab", BASALT_BRICKS, false, new TagKey[0]);
    public static final Block BASALT_BRICKS_WALL = NetherBlocks.registerWall("basalt_bricks_wall", BASALT_BRICKS);
    public static final Block BASALT_SLAB = NetherBlocks.registerSlab("basalt_slab", Blocks.f_50137_, false, new TagKey[0]);
    public static final Block ORANGE_MUSHROOM = NetherBlocks.registerBlock("orange_mushroom", new BlockOrangeMushroom(), new TagKey[0]);
    public static final Block RED_MOLD = NetherBlocks.registerBlock("red_mold", new BlockRedMold(), new TagKey[0]);
    public static final Block GRAY_MOLD = NetherBlocks.registerBlock("gray_mold", new BlockGrayMold(), new TagKey[0]);
    public static final Block LUCIS_SPORE = NetherBlocks.registerBlock("lucis_spore", new BlockLucisSpore(), new TagKey[0]);
    public static final Block GIANT_LUCIS = NetherBlocks.registerBlock("giant_lucis", new BlockGiantLucis(), new TagKey[0]);
    public static final Block GIANT_MOLD_SAPLING = NetherBlocks.registerBlock("giant_mold_sapling", new BlockGiantMoldSapling(), new TagKey[0]);
    public static final Block JELLYFISH_MUSHROOM_SAPLING = NetherBlocks.registerBlock("jellyfish_mushroom_sapling", new BlockJellyfishMushroomSapling(), new TagKey[0]);
    public static final Block EYE_SEED = NetherBlocks.registerBlock("eye_seed", new BlockEyeSeed(), new TagKey[0]);
    public static final Block NETHER_GRASS = NetherBlocks.registerBlock("nether_grass", new BlockNetherGrass(), new TagKey[0]);
    public static final Block SWAMP_GRASS = NetherBlocks.registerBlock("swamp_grass", new BlockNetherGrass(), new TagKey[0]);
    public static final Block SOUL_GRASS = NetherBlocks.registerBlock("soul_grass", new BlockSoulGrass(), new TagKey[0]);
    public static final Block JUNGLE_PLANT = NetherBlocks.registerBlock("jungle_plant", new BlockNetherGrass(), new TagKey[0]);
    public static final Block BONE_GRASS = NetherBlocks.registerBlock("bone_grass", new BaseBlockNetherGrass.OnEverything(), new TagKey[0]);
    public static final Block SEPIA_BONE_GRASS = NetherBlocks.registerBlock("sepia_bone_grass", new BaseBlockNetherGrass.OnEverything(), new TagKey[0]);
    public static final Block BLACK_VINE = NetherBlocks.registerBlock("black_vine", new BlockBlackVine(), new TagKey[0]);
    public static final Block BLOOMING_VINE = NetherBlocks.registerBlock("blooming_vine", new BlockBlackVine(), new TagKey[0]);
    public static final Block GOLDEN_VINE = NetherBlocks.registerBlock("golden_vine", new BlockGoldenVine(), new TagKey[0]);
    public static final BlockLumabusVine LUMABUS_VINE = NetherBlocks.registerBlockNI("lumabus_vine", new BlockLumabusVine(), new TagKey[0]);
    public static final BlockLumabusVine GOLDEN_LUMABUS_VINE = NetherBlocks.registerBlockNI("golden_lumabus_vine", new BlockLumabusVine(), new TagKey[0]);
    public static final Block SOUL_VEIN = NetherBlocks.registerBlock("soul_vein", new BlockSoulVein(), new TagKey[0]);
    public static final Block BONE_MUSHROOM = NetherBlocks.registerBlock("bone_mushroom", new BlockBoneMushroom(), new TagKey[0]);
    public static final Block BLACK_BUSH = NetherBlocks.registerBlock("black_bush", new BlockBlackBush(), new TagKey[0]);
    public static final Block INK_BUSH = NetherBlocks.registerBlockNI("ink_bush", new BlockInkBush(), new TagKey[0]);
    public static final Block INK_BUSH_SEED = NetherBlocks.registerBlock("ink_bush_seed", new BlockInkBushSeed(), new TagKey[0]);
    public static final Block SMOKER = NetherBlocks.registerBlock("smoker", new BlockSmoker(), new TagKey[0]);
    public static final Block EGG_PLANT = NetherBlocks.registerBlock("egg_plant", new BlockEggPlant(), new TagKey[0]);
    public static final Block BLACK_APPLE = NetherBlocks.registerBlockNI("black_apple", new BlockBlackApple(), new TagKey[0]);
    public static final Block BLACK_APPLE_SEED = NetherBlocks.registerBlock("black_apple_seed", new BlockBlackAppleSeed(), new TagKey[0]);
    public static final Block MAGMA_FLOWER = NetherBlocks.registerBlock("magma_flower", new BlockMagmaFlower(), new TagKey[0]);
    public static final Block FEATHER_FERN = NetherBlocks.registerBlock("feather_fern", new BlockFeatherFern(), new TagKey[0]);
    public static final Block MOSS_COVER = NetherBlocks.registerBlock("moss_cover", new BlockMossCover(), new TagKey[0]);
    public static final Block NEON_EQUISETUM = NetherBlocks.registerBlock("neon_equisetum", new BlockNeonEquisetum(), new TagKey[0]);
    public static final Block HOOK_MUSHROOM = NetherBlocks.registerBlock("hook_mushroom", new BlockHookMushroom(), new TagKey[0]);
    public static final Block WHISPERING_GOURD_VINE = NetherBlocks.registerBlock("whispering_gourd_vine", new BlockWhisperingGourdVine(), new TagKey[0]);
    public static final Block WHISPERING_GOURD = NetherBlocks.registerBlock("whispering_gourd", new BlockWhisperingGourd(), new TagKey[0]);
    public static final Block WHISPERING_GOURD_LANTERN = NetherBlocks.registerBlock("whispering_gourd_lantern", new BlockWhisperingGourdLantern(), new TagKey[0]);
    public static final Block AGAVE = NetherBlocks.registerBlock("agave", new BlockAgave(), new TagKey[0]);
    public static final Block BARREL_CACTUS = NetherBlocks.registerBlock("barrel_cactus", new BlockBarrelCactus(), new TagKey[0]);
    public static final Block NETHER_CACTUS = NetherBlocks.registerBlock("nether_cactus", new BlockNetherCactus(), new TagKey[0]);
    public static final Block WALL_MOSS = NetherBlocks.registerBlock("wall_moss", new BlockPlantWall(MapColor.f_283913_), new TagKey[0]);
    public static final Block WALL_MUSHROOM_BROWN = NetherBlocks.registerBlock("wall_mushroom_brown", new BlockPlantWall(MapColor.f_283748_), new TagKey[0]);
    public static final Block WALL_MUSHROOM_RED = NetherBlocks.registerBlock("wall_mushroom_red", new BlockPlantWall(MapColor.f_283913_), new TagKey[0]);
    public static final Block JUNGLE_MOSS = NetherBlocks.registerBlock("jungle_moss", new BlockPlantWall(MapColor.f_283916_), new TagKey[0]);
    public static final Block PIG_STATUE_RESPAWNER = NetherBlocks.registerBlock("pig_statue_respawner", new BlockStatueRespawner(), new TagKey[0]);
    public static final Block CINCINNASITE_POT = NetherBlocks.registerBlock("cincinnasite_pot", new BlockBNPot.Metal(CINCINNASITE_BLOCK), new TagKey[0]);
    public static final Block BRICK_POT = NetherBlocks.registerBlock("brick_pot", new BlockBNPot.Stone(Blocks.f_50197_), new TagKey[0]);
    public static final Block GEYSER = NetherBlocks.registerBlock("geyser", new BlockGeyser(), new TagKey[0]);
    public static final Block NETHERRACK_STALACTITE = NetherBlocks.registerStalactite("netherrack_stalactite", Blocks.f_50134_);
    public static final Block GLOWSTONE_STALACTITE = NetherBlocks.registerStalactite("glowstone_stalactite", Blocks.f_50141_);
    public static final Block BLACKSTONE_STALACTITE = NetherBlocks.registerStalactite("blackstone_stalactite", Blocks.f_50730_);
    public static final Block BASALT_STALACTITE = NetherBlocks.registerStalactite("basalt_stalactite", Blocks.f_50137_);
    public static final Block BONE_STALACTITE = NetherBlocks.registerStalactite("bone_stalactite", BONE_BLOCK);
    public static final Block CINCINNASITE_FIRE_BOWL = NetherBlocks.registerFireBowl("cincinnasite_fire_bowl", CINCINNASITE_FORGED, Blocks.f_50134_, NetherItems.CINCINNASITE_INGOT);
    public static final Block BRICKS_FIRE_BOWL = NetherBlocks.registerFireBowl("bricks_fire_bowl", NETHER_BRICK_TILE_LARGE, Blocks.f_50134_, Items.f_42691_);
    public static final Block NETHERITE_FIRE_BOWL = NetherBlocks.registerFireBowl("netherite_fire_bowl", Blocks.f_50721_, Blocks.f_50134_, Items.f_42418_);
    public static final Block CINCINNASITE_FIRE_BOWL_SOUL = NetherBlocks.registerFireBowl("cincinnasite_fire_bowl_soul", CINCINNASITE_FORGED, Blocks.f_50135_, NetherItems.CINCINNASITE_INGOT);
    public static final Block BRICKS_FIRE_BOWL_SOUL = NetherBlocks.registerFireBowl("bricks_fire_bowl_soul", NETHER_BRICK_TILE_LARGE, Blocks.f_50135_, Items.f_42691_);
    public static final Block NETHERITE_FIRE_BOWL_SOUL = NetherBlocks.registerFireBowl("netherite_fire_bowl_soul", Blocks.f_50721_, Blocks.f_50135_, Items.f_42418_);
    public static final BlockTerrain NETHERRACK_MOSS = NetherBlocks.registerBlock("netherrack_moss", new BlockTerrain(), BCLBlockTags.BONEMEAL_SOURCE_NETHERRACK);
    public static final BlockNetherMycelium NETHER_MYCELIUM = NetherBlocks.registerBlock("nether_mycelium", new BlockNetherMycelium(), CommonBlockTags.MYCELIUM, CommonBlockTags.NETHER_MYCELIUM, BCLBlockTags.BONEMEAL_SOURCE_NETHERRACK, CommonBlockTags.NETHER_MYCELIUM);
    public static final BlockTerrain JUNGLE_GRASS = NetherBlocks.registerBlock("jungle_grass", new BlockTerrain(), BlockTags.f_13077_, BCLBlockTags.BONEMEAL_SOURCE_NETHERRACK);
    public static final BlockTerrain MUSHROOM_GRASS = NetherBlocks.registerBlock("mushroom_grass", new BlockTerrain(), BlockTags.f_13077_, BCLBlockTags.BONEMEAL_SOURCE_NETHERRACK);
    public static final BlockTerrain SEPIA_MUSHROOM_GRASS = NetherBlocks.registerBlock("sepia_mushroom_grass", new BlockTerrain(), BlockTags.f_13077_, BCLBlockTags.BONEMEAL_SOURCE_NETHERRACK);
    public static final BlockTerrain SWAMPLAND_GRASS = NetherBlocks.registerBlock("swampland_grass", new BlockTerrain(), BlockTags.f_13077_, BCLBlockTags.BONEMEAL_SOURCE_NETHERRACK);
    public static final Block FARMLAND = NetherBlocks.registerBlock("farmland", new BlockFarmland(), new TagKey[0]);
    public static final BlockTerrain CEILING_MUSHROOMS = NetherBlocks.registerBlock("ceiling_mushrooms", new BlockTerrain(), BCLBlockTags.BONEMEAL_SOURCE_NETHERRACK);
    public static final Block ROOF_TILE_NETHER_BRICKS = NetherBlocks.registerRoof("roof_tile_nether_bricks", Blocks.f_50197_);
    public static final Block ROOF_TILE_NETHER_BRICKS_STAIRS = NetherBlocks.registerStairs("roof_tile_nether_bricks_stairs", ROOF_TILE_NETHER_BRICKS, false, new TagKey[0]);
    public static final Block ROOF_TILE_NETHER_BRICKS_SLAB = NetherBlocks.registerSlab("roof_tile_nether_bricks_slab", ROOF_TILE_NETHER_BRICKS, false, new TagKey[0]);
    public static final Block ROOF_TILE_CINCINNASITE = NetherBlocks.registerRoof("roof_tile_cincinnasite", CINCINNASITE_FORGED);
    public static final Block ROOF_TILE_CINCINNASITE_STAIRS = NetherBlocks.registerStairs("roof_tile_cincinnasite_stairs", ROOF_TILE_CINCINNASITE, false, new TagKey[0]);
    public static final Block ROOF_TILE_CINCINNASITE_SLAB = NetherBlocks.registerSlab("roof_tile_cincinnasite_slab", ROOF_TILE_CINCINNASITE, false, new TagKey[0]);
    public static final Block BLACKSTONE_FURNACE = NetherBlocks.registerFurnace("blackstone_furnace", Blocks.f_50730_);
    public static final Block BASALT_FURNACE = NetherBlocks.registerFurnace("basalt_furnace", Blocks.f_50137_);
    public static final Block NETHERRACK_FURNACE = NetherBlocks.registerFurnace("netherrack_furnace", Blocks.f_50134_);
    public static final Block CINCINNASITE_FORGE = NetherBlocks.registerBlock("cincinnasite_forge", new BlockCincinnasiteForge(), new TagKey[0]);
    public static final Block NETHER_BREWING_STAND = NetherBlocks.registerBlock("nether_brewing_stand", new BNBrewingStand(), new TagKey[0]);
    public static final Block CINCINNASITE_ANVIL = NetherBlocks.registerBlock("cincinnasite_anvil", new BlockCincinnasiteAnvil(), BlockTags.f_13033_);
    public static final VanillaNetherWood WARPED_WOOD = (VanillaNetherWood)((Object)new VanillaNetherWood("warped", Blocks.f_50656_.m_284356_(), MapColor.f_283749_).init());
    public static final VanillaNetherWood CRIMSON_WOOD = (VanillaNetherWood)((Object)new VanillaNetherWood("crimson", Blocks.f_50655_.m_284356_(), MapColor.f_283804_).init());
    public static final VanillaWood OAK_WOOD = VanillaWood.create("oak");
    public static final VanillaWood SPRUCE_WOOD = VanillaWood.create("spruce");
    public static final VanillaWood BIRCH_WOOD = VanillaWood.create("birch");
    public static final VanillaWood JUNGLE_WOOD = VanillaWood.create("jungle");
    public static final VanillaWood ACACIA_WOOD = VanillaWood.create("acacia");
    public static final VanillaWood DARK_OAK_WOOD = VanillaWood.create("dark_oak");
    public static final VanillaWood CHERRY_WOOD = VanillaWood.create("cherry");
    public static final VanillaWood BAMBOO_WOOD = VanillaWood.create("bamboo");
    public static final VanillaWood MANGROVE_WOOD = VanillaWood.create("mangrove");
    public static final Block CHEST_OF_DRAWERS = NetherBlocks.registerBlock("chest_of_drawers", new BlockChestOfDrawers(), new TagKey[0]);
    private static BlockRegistry BLOCKS_REGISTRY;
    public static final RubeusMaterial MAT_RUBEUS;
    public static final Block RUBEUS_LEAVES;
    public static final MushroomFirMaterial MAT_MUSHROOM_FIR;
    public static final Block TRIMMED_MUSHROOM_FIR_CHEST;
    public static final NetherMushroomMaterial MAT_NETHER_MUSHROOM;
    public static final AnchorTreeMaterial MAT_ANCHOR_TREE;
    public static final Block ANCHOR_TREE_LEAVES;
    public static final Block ANCHOR_TREE_VINE;
    public static final NetherSakuraMaterial MAT_NETHER_SAKURA;
    public static final Block NETHER_SAKURA_LEAVES;
    public static final Block SOUL_LILY;
    public static final Block SOUL_LILY_SAPLING;
    public static final Block RED_LARGE_MUSHROOM;
    public static final Block BROWN_LARGE_MUSHROOM;
    public static final Block LUCIS_MUSHROOM;
    public static final Block GIANT_MOLD;
    public static final Block JELLYFISH_MUSHROOM;
    public static final Block EYEBALL;
    public static final Block EYEBALL_SMALL;
    public static final Block EYE_VINE;
    public static final Block POTTED_PLANT;
    public static final Block VEINED_SAND;
    public static final Block LUMABUS_SEED;
    public static final Block GOLDEN_LUMABUS_SEED;

    protected NetherBlocks() {
        super(Configs.BLOCKS);
    }

    @NotNull
    public static BlockRegistry getBlockRegistry() {
        if (BLOCKS_REGISTRY == null) {
            BLOCKS_REGISTRY = new NetherBlocks();
        }
        return BLOCKS_REGISTRY;
    }

    public static List<Block> getModBlocks() {
        return BlockRegistry.getModBlocks((String)"betternether");
    }

    public static List<Item> getModBlockItems() {
        return BlockRegistry.getModBlockItems((String)"betternether");
    }

    @SafeVarargs
    public static <T extends Block> T registerBlock(String name, T block, TagKey<Block> ... tags) {
        if (Configs.BLOCKS.getBoolean("blocks", name, true)) {
            NetherBlocks.registerBlockDirectly(name, block);
            if (tags.length > 0) {
                TagManager.BLOCKS.add(block, tags);
            }
        }
        return block;
    }

    @SafeVarargs
    private static <B extends Block> B registerBlockNI(String name, B block, TagKey<Block> ... tags) {
        if (Configs.BLOCKS.getBoolean("blocks", name, true)) {
            return NetherBlocks.registerBlock(name, block, false, tags);
        }
        return block;
    }

    public static void registerBlockDirectly(String name, Block block) {
        NetherBlocks.registerBlock(name, block, true, new TagKey[0]);
    }

    @SafeVarargs
    private static <B extends Block> B registerBlock(String name, B block, boolean hasItem, TagKey<Block> ... tags) {
        BlockRegistry blockRegistry = NetherBlocks.getBlockRegistry();
        ResourceLocation location = new ResourceLocation("betternether", name);
        if (hasItem) {
            blockRegistry.register(location, block);
        } else {
            blockRegistry.registerBlockOnly(location, block);
        }
        if (tags.length > 0) {
            TagManager.BLOCKS.add(block, tags);
        }
        return block;
    }

    private static void addFuel(Block source, Block result) {
        if (source.m_49966_().m_278200_()) {
            FuelRegistry.INSTANCE.add((ItemLike)result, (Object)40);
        }
    }

    public static Block registerStairs(String name, Block source, boolean fireproof, TagKey<Block> ... tags) {
        BaseStairsBlock stairs = BaseStairsBlock.from((Block)source, (boolean)fireproof);
        if (Configs.BLOCKS.getBoolean("blocks", name, true)) {
            NetherBlocks.registerBlockDirectly(name, (Block)stairs);
            if (stairs.m_49966_().m_278200_()) {
                NetherBlocks.addFuel(source, (Block)stairs);
            }
            RecipesHelper.makeStairsRecipe(source, (Block)stairs);
            if (tags.length > 0) {
                TagManager.BLOCKS.add((Object)stairs, tags);
            }
        }
        return stairs;
    }

    public static Block registerSlab(String name, Block source, boolean fireproof, TagKey<Block> ... tags) {
        BaseSlabBlock slab = BaseSlabBlock.from((Block)source, (boolean)fireproof);
        if (Configs.BLOCKS.getBoolean("blocks", name, true)) {
            NetherBlocks.registerBlockDirectly(name, (Block)slab);
            if (slab.m_49966_().m_278200_()) {
                NetherBlocks.addFuel(source, (Block)slab);
            }
            RecipesHelper.makeSlabRecipe(source, (Block)slab);
            if (tags.length > 0) {
                TagManager.BLOCKS.add((Object)slab, tags);
            }
        }
        return slab;
    }

    private static Block registerRoof(String name, Block source) {
        BlockBase roof = BlockBase.from(source);
        if (Configs.BLOCKS.getBoolean("blocks", name, true)) {
            NetherBlocks.registerBlockDirectly(name, roof);
            NetherBlocks.addFuel(source, roof);
            RecipesHelper.makeRoofRecipe(source, roof);
        }
        return roof;
    }

    public static Block registerButton(String name, Block source, BlockSetType type) {
        BaseButtonBlock button = BaseButtonBlock.from((Block)source, (BlockSetType)type);
        if (Configs.BLOCKS.getBoolean("blocks", name, true)) {
            NetherBlocks.registerBlockDirectly(name, (Block)button);
            NetherBlocks.addFuel(source, (Block)button);
            RecipesHelper.makeButtonRecipe(source, (Block)button);
        }
        return button;
    }

    public static Block registerPlate(String name, Block source, BlockSetType type) {
        BasePressurePlateBlock plate = BasePressurePlateBlock.from((Block)source, (BlockSetType)type);
        if (Configs.BLOCKS.getBoolean("blocks", name, true)) {
            NetherBlocks.registerBlockDirectly(name, (Block)plate);
            NetherBlocks.addFuel(source, (Block)plate);
            RecipesHelper.makePlateRecipe(source, (Block)plate);
        }
        return plate;
    }

    public static Block registerSoulBlock(String name, Block block) {
        return NetherBlocks.registerBlock(name, block, BlockTags.f_13085_, BlockTags.f_13080_);
    }

    public static Block registerMakeable2X2Soul(String name, Block result, String group, RecipeCategory category, Block ... sources) {
        Block block = NetherBlocks.registerMakeable2X2(name, result, group, category, sources);
        TagManager.BLOCKS.add((Object)block, new TagKey[]{BlockTags.f_13085_, BlockTags.f_13080_});
        return block;
    }

    public static Block registerMakeable2X2(String name, Block result, String group, RecipeCategory category, Block ... sources) {
        if (Configs.BLOCKS.getBoolean("blocks", name, true)) {
            NetherBlocks.registerBlockDirectly(name, result);
            for (Block source : sources) {
                RecipesHelper.makeSimpleRecipe2(source, result, 4, group, category);
            }
        }
        return result;
    }

    public static Block registerWall(String name, Block source) {
        BNWall wall = BNWall.from(source);
        if (Configs.BLOCKS.getBoolean("blocks", name, true)) {
            NetherBlocks.registerBlockDirectly(name, (Block)wall);
            TagManager.BLOCKS.add((Object)wall, new TagKey[]{BlockTags.f_13032_});
            RecipesHelper.makeWallRecipe(source, (Block)wall);
        }
        return wall;
    }

    public static Block registerTaburet(String name, Block source) {
        BaseTaburet block = BaseTaburet.from((Block)source);
        if (Configs.BLOCKS.getBoolean("blocks", name, true)) {
            NetherBlocks.registerBlockDirectly(name, (Block)block);
            NetherBlocks.addFuel(source, (Block)block);
            Taburet.makeTaburetRecipe((ResourceLocation)new ResourceLocation("betternether", name), (Block)block, (Block)source);
            TagManager.BLOCKS.add((Object)block, new TagKey[]{BlockTags.f_144282_});
        }
        return block;
    }

    public static Block registerChair(String name, Block source) {
        BaseChair block = BaseChair.from((Block)source);
        if (Configs.BLOCKS.getBoolean("blocks", name, true)) {
            NetherBlocks.registerBlockDirectly(name, (Block)block);
            NetherBlocks.addFuel(source, (Block)block);
            Chair.makeChairRecipe((ResourceLocation)new ResourceLocation("betternether", name), (Block)block, (Block)source);
            TagManager.BLOCKS.add((Object)block, new TagKey[]{BlockTags.f_144282_});
        }
        return block;
    }

    public static Block registerBarStool(String name, Block source) {
        BaseBarStool block = BaseBarStool.from((Block)source);
        if (Configs.BLOCKS.getBoolean("blocks", name, true)) {
            NetherBlocks.registerBlockDirectly(name, (Block)block);
            NetherBlocks.addFuel(source, (Block)block);
            BarStool.makeBarStoolRecipe((ResourceLocation)new ResourceLocation("betternether", name), (Block)block, (Block)source);
            TagManager.BLOCKS.add((Object)block, new TagKey[]{BlockTags.f_144282_});
        }
        return block;
    }

    public static Block registerFurnace(String name, Block source) {
        BlockNetherFurnace block = new BlockNetherFurnace(source);
        if (Configs.BLOCKS.getBoolean("blocks", name, true)) {
            NetherBlocks.registerBlockDirectly(name, (Block)block);
            RecipesHelper.makeRoundRecipe(source, (Block)block, "nether_furnace", RecipeCategory.DECORATIONS);
        }
        return block;
    }

    private static Block registerStalactite(String name, Block source) {
        BlockStalactite block = new BlockStalactite(source);
        if (Configs.BLOCKS.getBoolean("blocks", name, true)) {
            NetherBlocks.registerBlockDirectly(name, block);
            RecipesHelper.makeSimpleRecipe2(block, source, 1, "nether_stalactite", RecipeCategory.DECORATIONS);
        }
        return block;
    }

    private static Block registerFireBowl(String name, Block source, Block inside, Item leg) {
        BlockFireBowl block;
        boolean isNetherite = name.startsWith("netherite");
        BlockFireBowl blockFireBowl = block = isNetherite ? new BlockFireBowl.Metal(source) : BlockFireBowl.from(source);
        if (Configs.BLOCKS.getBoolean("blocks", name, true)) {
            NetherBlocks.registerBlockDirectly(name, block);
            if (!isNetherite) {
                RecipesHelper.makeFireBowlRecipe(source, inside, leg, block);
            }
        }
        return block;
    }

    static {
        MAT_RUBEUS = (RubeusMaterial)((Object)new RubeusMaterial().init());
        RUBEUS_LEAVES = NetherBlocks.registerBlock("rubeus_leaves", new BlockRubeusLeaves(MAT_RUBEUS.getSapling()), new TagKey[0]);
        MAT_MUSHROOM_FIR = (MushroomFirMaterial)((Object)new MushroomFirMaterial().init());
        TRIMMED_MUSHROOM_FIR_CHEST = NetherBlocks.registerBlock("mushroom_fir_trimmed_chest", new BaseChestBlock.Wood(MAT_MUSHROOM_FIR.getBlock(WoodSlots.PLANKS)), new TagKey[0]);
        MAT_NETHER_MUSHROOM = (NetherMushroomMaterial)((Object)new NetherMushroomMaterial().init());
        MAT_ANCHOR_TREE = (AnchorTreeMaterial)((Object)new AnchorTreeMaterial().init());
        ANCHOR_TREE_LEAVES = NetherBlocks.registerBlock("anchor_tree_leaves", new BNLeaves(MAT_ANCHOR_TREE.getSapling(), MapColor.f_283784_), new TagKey[0]);
        ANCHOR_TREE_VINE = NetherBlocks.registerBlockNI("anchor_tree_vine", new BlockAnchorTreeVine(), new TagKey[0]);
        MAT_NETHER_SAKURA = (NetherSakuraMaterial)((Object)new NetherSakuraMaterial().init());
        NETHER_SAKURA_LEAVES = NetherBlocks.registerBlock("nether_sakura_leaves", new BlockNetherSakuraLeaves(MAT_NETHER_SAKURA.getSapling()), new TagKey[0]);
        SOUL_LILY = NetherBlocks.registerBlockNI("soul_lily", new BlockSoulLily(), new TagKey[0]);
        SOUL_LILY_SAPLING = NetherBlocks.registerBlock("soul_lily_sapling", new BlockSoulLilySapling(), new TagKey[0]);
        RED_LARGE_MUSHROOM = NetherBlocks.registerBlockNI("red_large_mushroom", new BlockRedLargeMushroom(), new TagKey[0]);
        BROWN_LARGE_MUSHROOM = NetherBlocks.registerBlockNI("brown_large_mushroom", new BlockBrownLargeMushroom(), new TagKey[0]);
        LUCIS_MUSHROOM = NetherBlocks.registerBlockNI("lucis_mushroom", new BlockLucisMushroom(), new TagKey[0]);
        GIANT_MOLD = NetherBlocks.registerBlockNI("giant_mold", new BlockGiantMold(), new TagKey[0]);
        JELLYFISH_MUSHROOM = NetherBlocks.registerBlockNI("jellyfish_mushroom", new BlockJellyfishMushroom(), new TagKey[0]);
        EYEBALL = NetherBlocks.registerBlockNI("eyeball", new BlockEyeball(), new TagKey[0]);
        EYEBALL_SMALL = NetherBlocks.registerBlockNI("eyeball_small", new BlockEyeballSmall(), new TagKey[0]);
        EYE_VINE = NetherBlocks.registerBlockNI("eye_vine", new BlockEyeVine(), new TagKey[0]);
        POTTED_PLANT = NetherBlocks.registerBlockNI("potted_plant", new BlockPottedPlant(), new TagKey[0]);
        VEINED_SAND = NetherBlocks.registerBlockNI("veined_sand", new BlockVeinedSand(), NetherTags.NETHER_SAND);
        LUMABUS_SEED = NetherBlocks.registerBlock("lumabus_seed", new BlockLumabusSeed(LUMABUS_VINE, NetherVines.LUMABUS_VINE), new TagKey[0]);
        GOLDEN_LUMABUS_SEED = NetherBlocks.registerBlock("golden_lumabus_seed", new BlockLumabusSeed(GOLDEN_LUMABUS_VINE, NetherVines.GOLDEN_LUMABUS_VINE), new TagKey[0]);
    }
}

