/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.registry;

import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeRegistry;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.bclib.interfaces.NumericProvider;
import org.betterx.betternether.BN;
import org.betterx.betternether.BetterNether;
import org.betterx.betternether.registry.NetherEntities;
import org.betterx.betternether.registry.NetherFeatures;
import org.betterx.betternether.registry.NetherStructures;
import org.betterx.betternether.world.NetherBiome;
import org.betterx.betternether.world.biomes.providers.NetherGrasslandsNumericProvider;
import org.betterx.betternether.world.biomes.providers.NetherMushroomForestEdgeNumericProvider;

public class NetherBiomes {
    public static void register() {
        BCLBiomeRegistry.registerBiomeCodec((ResourceLocation)BN.id("biome"), NetherBiome.KEY_CODEC);
        BiomeAPI.registerNetherBiomeModification((biomeID, biome) -> {
            if (!biomeID.m_135827_().equals("betternether")) {
                NetherEntities.modifyNonBNBiome(biomeID, (Holder<Biome>)biome);
                NetherFeatures.modifyNonBNBiome(biomeID, (Holder<Biome>)biome);
            }
        });
        BiomeAPI.onFinishingNetherBiomeTags((biomeID, biome) -> {
            if (!biomeID.m_135827_().equals("betternether")) {
                NetherStructures.addNonBNBiomeTags(biomeID, (Holder<Biome>)biome);
            }
        });
        NetherBiomes.registerNumericProviders();
    }

    private static void registerNumericProviders() {
        Registry.m_122965_((Registry)NumericProvider.NUMERIC_PROVIDER, (ResourceLocation)BetterNether.makeID("nether_grasslands"), NetherGrasslandsNumericProvider.CODEC);
        Registry.m_122965_((Registry)NumericProvider.NUMERIC_PROVIDER, (ResourceLocation)BetterNether.makeID("nether_mushroom_forrest_edge"), NetherMushroomForestEdgeNumericProvider.CODEC);
    }
}

