/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.registry;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.EntityModelLayerRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import org.betterx.bclib.registry.BaseBlockEntityRenders;
import org.betterx.betternether.entity.model.ModelEntityFirefly;
import org.betterx.betternether.entity.model.ModelEntityFlyingPig;
import org.betterx.betternether.entity.model.ModelEntityHydrogenJellyfish;
import org.betterx.betternether.entity.model.ModelJungleSkeleton;
import org.betterx.betternether.entity.model.ModelNaga;
import org.betterx.betternether.entity.model.ModelSkull;
import org.betterx.betternether.entity.render.RenderFirefly;
import org.betterx.betternether.entity.render.RenderFlyingPig;
import org.betterx.betternether.entity.render.RenderHydrogenJellyfish;
import org.betterx.betternether.entity.render.RenderJungleSkeleton;
import org.betterx.betternether.entity.render.RenderNaga;
import org.betterx.betternether.entity.render.RenderNagaProjectile;
import org.betterx.betternether.entity.render.RenderSkull;
import org.betterx.betternether.registry.NetherEntities;

@Environment(value=EnvType.CLIENT)
public class EntityRenderRegistry {
    private static final String DEFAULT_LAYER = "main";
    public static final ModelLayerLocation FIREFLY_MODEL = EntityRenderRegistry.registerMain("firefly");
    public static final ModelLayerLocation NAGA_MODEL = EntityRenderRegistry.registerMain("naga");
    public static final ModelLayerLocation JUNGLE_SKELETON_MODEL = EntityRenderRegistry.registerMain("jungle_skeleton");
    public static final ModelLayerLocation FLYING_PIG_MODEL = EntityRenderRegistry.registerMain("flying_pig");
    public static final ModelLayerLocation HYDROGEN_JELLYFISH_MODEL = EntityRenderRegistry.registerMain("hydrogen_jelly");
    public static final ModelLayerLocation SKULL_MODEL = EntityRenderRegistry.registerMain("skull");

    public static ModelLayerLocation registerMain(String id) {
        return new ModelLayerLocation(new ResourceLocation("betternether", id), DEFAULT_LAYER);
    }

    public static void register() {
        EntityRenderRegistry.registerRenderMob(NetherEntities.FIREFLY.type(), RenderFirefly.class);
        EntityRenderRegistry.registerRenderMob(NetherEntities.HYDROGEN_JELLYFISH.type(), RenderHydrogenJellyfish.class);
        EntityRenderRegistry.registerRenderMob(NetherEntities.NAGA.type(), RenderNaga.class);
        BaseBlockEntityRenders.registerRender(NetherEntities.NAGA_PROJECTILE, RenderNagaProjectile.class);
        EntityRenderRegistry.registerRenderMob(NetherEntities.FLYING_PIG.type(), RenderFlyingPig.class);
        EntityRenderRegistry.registerRenderMob(NetherEntities.JUNGLE_SKELETON.type(), RenderJungleSkeleton.class);
        EntityRenderRegistry.registerRenderMob(NetherEntities.SKULL.type(), RenderSkull.class);
        EntityModelLayerRegistry.registerModelLayer((ModelLayerLocation)FIREFLY_MODEL, ModelEntityFirefly::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer((ModelLayerLocation)NAGA_MODEL, ModelNaga::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer((ModelLayerLocation)JUNGLE_SKELETON_MODEL, ModelJungleSkeleton::createBodyLayer);
        EntityModelLayerRegistry.registerModelLayer((ModelLayerLocation)FLYING_PIG_MODEL, ModelEntityFlyingPig::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer((ModelLayerLocation)HYDROGEN_JELLYFISH_MODEL, ModelEntityHydrogenJellyfish::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer((ModelLayerLocation)SKULL_MODEL, ModelSkull::getTexturedModelData);
    }

    private static void registerRenderMob(EntityType<?> entity, Class<? extends MobRenderer<?, ?>> renderer) {
        EntityRendererRegistry.register(entity, context -> {
            MobRenderer render = null;
            try {
                render = (MobRenderer)renderer.getConstructor(context.getClass()).newInstance(context);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return render;
        });
    }
}

