/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.registry;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import org.betterx.betternether.registry.NetherBlocks;

public class BrewingRegistry {
    private static final List<BrewingRecipe> RECIPES = new ArrayList<BrewingRecipe>();

    public static void register() {
        BrewingRegistry.register(new ItemStack((ItemLike)NetherBlocks.BARREL_CACTUS), new ItemStack((ItemLike)Items.f_42590_), BrewingRegistry.makePotion(Potions.f_43599_));
        BrewingRegistry.register(new ItemStack((ItemLike)NetherBlocks.HOOK_MUSHROOM), BrewingRegistry.makePotion(Potions.f_43602_), BrewingRegistry.makePotion(Potions.f_43623_));
    }

    private static void register(ItemStack source, ItemStack bottle, ItemStack result) {
        RECIPES.add(new BrewingRecipe(source, bottle, result));
    }

    private static ItemStack makePotion(Potion potion) {
        return PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)potion);
    }

    public static ItemStack getResult(ItemStack source, ItemStack bottle) {
        for (BrewingRecipe recipe : RECIPES) {
            if (!recipe.isValid(source, bottle)) continue;
            return recipe.getResult();
        }
        return null;
    }

    public static boolean isValidIngridient(ItemStack source) {
        for (BrewingRecipe recipe : RECIPES) {
            if (!recipe.isValid(source)) continue;
            return true;
        }
        return false;
    }

    public static class BrewingRecipe {
        private final ItemStack source;
        private final ItemStack bottle;
        private final ItemStack result;

        public BrewingRecipe(ItemStack source, ItemStack bottle, ItemStack result) {
            this.source = source;
            this.bottle = bottle;
            this.result = result;
        }

        public boolean isValid(ItemStack source, ItemStack bottle) {
            return ItemStack.m_41656_((ItemStack)this.source, (ItemStack)source) && ItemStack.m_41656_((ItemStack)this.bottle, (ItemStack)bottle);
        }

        public boolean isValid(ItemStack source) {
            return ItemStack.m_41656_((ItemStack)this.source, (ItemStack)source);
        }

        public ItemStack getResult() {
            return this.result;
        }
    }
}

