/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.recipes;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.betterx.bclib.recipes.BCLRecipeBuilder;
import org.betterx.bclib.recipes.CraftingRecipeBuilder;
import org.betterx.bclib.recipes.StonecutterRecipeBuilder;
import org.betterx.betternether.BN;

public class RecipesHelper {
    private static final String[] SHAPE_ROOF = new String[]{"# #", "###", " # "};
    private static final String[] SHAPE_STAIR = new String[]{"#  ", "## ", "###"};
    private static final String[] SHAPE_SLAB = new String[]{"###"};
    private static final String[] SHAPE_BUTTON = new String[]{"#"};
    private static final String[] SHAPE_PLATE = new String[]{"##"};
    private static final String[] SHAPE_X2 = new String[]{"##", "##"};
    private static final String[] SHAPE_3X2 = new String[]{"###", "###"};
    private static final String[] SHAPE_COLORING = new String[]{"###", "#I#", "###"};
    private static final String[] SHAPE_ROUND = new String[]{"###", "# #", "###"};
    private static final String[] SHAPE_FIRE_BOWL = new String[]{"#I#", " # ", "L L"};

    private static void makeSingleRecipe(String group, Block source, Block result, String[] shape, int count, RecipeCategory category) {
        if (BuiltInRegistries.f_256975_.m_7981_((Object)source) != BuiltInRegistries.f_256975_.m_122315_()) {
            String name = BuiltInRegistries.f_256975_.m_7981_((Object)source).m_135815_() + "_" + BuiltInRegistries.f_256975_.m_7981_((Object)result).m_135815_();
            ((CraftingRecipeBuilder)BCLRecipeBuilder.crafting((ResourceLocation)BN.id(name), (ItemLike)result).setOutputCount(count).setGroup(group).setCategory(category)).setShape(shape).addMaterial('#', new ItemLike[]{source}).build();
        }
    }

    public static void makeRoofRecipe(Block source, Block roof) {
        RecipesHelper.makeSingleRecipe("roof_tile", source, roof, SHAPE_ROOF, 6, RecipeCategory.BUILDING_BLOCKS);
    }

    public static void makeStairsRecipe(Block source, Block stairs) {
        String name = BuiltInRegistries.f_256975_.m_7981_((Object)stairs).m_135815_();
        String group = BuiltInRegistries.f_256975_.m_7981_((Object)stairs).m_135815_().contains("roof_tile") ? "roof_tile_stairs" : "nether_rock_stairs";
        RecipesHelper.makeSingleRecipe(group, source, stairs, SHAPE_STAIR, 4, RecipeCategory.BUILDING_BLOCKS);
        ((StonecutterRecipeBuilder)((StonecutterRecipeBuilder)BCLRecipeBuilder.stonecutting((ResourceLocation)BN.id(name + "_stonecutting"), (ItemLike)stairs).setOutputCount(1).setPrimaryInputAndUnlock(new ItemLike[]{source})).setCategory(RecipeCategory.BUILDING_BLOCKS)).setGroup(group).build();
    }

    public static void makeSlabRecipe(Block source, Block slab) {
        String name = BuiltInRegistries.f_256975_.m_7981_((Object)slab).m_135815_();
        String group = BuiltInRegistries.f_256975_.m_7981_((Object)slab).m_135815_().contains("roof_tile") ? "roof_tile_slab" : "nether_rock_slab";
        RecipesHelper.makeSingleRecipe(group, source, slab, SHAPE_SLAB, 6, RecipeCategory.BUILDING_BLOCKS);
        ((StonecutterRecipeBuilder)((StonecutterRecipeBuilder)BCLRecipeBuilder.stonecutting((ResourceLocation)BN.id(name + "_stonecutting"), (ItemLike)slab).setOutputCount(2).setPrimaryInputAndUnlock(new ItemLike[]{source})).setCategory(RecipeCategory.BUILDING_BLOCKS)).setGroup(group).build();
    }

    public static void makeButtonRecipe(Block source, Block button) {
        String group = "nether_rock_plate";
        RecipesHelper.makeSingleRecipe(group, source, button, SHAPE_BUTTON, 1, RecipeCategory.REDSTONE);
    }

    public static void makePlateRecipe(Block source, Block plate) {
        String group = "nether_rock_plate";
        RecipesHelper.makeSingleRecipe(group, source, plate, SHAPE_PLATE, 1, RecipeCategory.REDSTONE);
    }

    public static void makeSimpleRecipe2(Block source, Block result, int count, String group, RecipeCategory category) {
        RecipesHelper.makeSingleRecipe(group, source, result, SHAPE_X2, count, category);
    }

    public static void makeWallRecipe(Block source, Block wall) {
        if (BuiltInRegistries.f_256975_.m_7981_((Object)source) != BuiltInRegistries.f_256975_.m_122315_()) {
            String name = BuiltInRegistries.f_256975_.m_7981_((Object)wall).m_135815_();
            ((CraftingRecipeBuilder)BCLRecipeBuilder.crafting((ResourceLocation)BN.id(name), (ItemLike)wall).setOutputCount(6).setGroup("nether_wall").setShape(SHAPE_3X2).setCategory(RecipeCategory.DECORATIONS)).addMaterial('#', new ItemLike[]{source}).build();
            ((StonecutterRecipeBuilder)((StonecutterRecipeBuilder)BCLRecipeBuilder.stonecutting((ResourceLocation)BN.id(name + "_stonecutting"), (ItemLike)wall).setOutputCount(1).setPrimaryInputAndUnlock(new ItemLike[]{source})).setCategory(RecipeCategory.BUILDING_BLOCKS)).setGroup("nether_wall").build();
        }
    }

    public static void makeColoringRecipe(Block source, Block result, Item dye, String group, RecipeCategory category) {
        if (BuiltInRegistries.f_256975_.m_7981_((Object)source) != BuiltInRegistries.f_256975_.m_122315_()) {
            String name = BuiltInRegistries.f_256975_.m_7981_((Object)result).m_135815_();
            ((CraftingRecipeBuilder)BCLRecipeBuilder.crafting((ResourceLocation)BN.id(name), (ItemLike)result).setOutputCount(8).setGroup(group).setCategory(category)).setShape(SHAPE_COLORING).addMaterial('#', new ItemLike[]{source}).addMaterial('I', new ItemLike[]{dye}).build();
        }
    }

    public static void makeRoundRecipe(Block source, Block result, String group, RecipeCategory category) {
        if (BuiltInRegistries.f_256975_.m_7981_((Object)source) != BuiltInRegistries.f_256975_.m_122315_()) {
            String name = BuiltInRegistries.f_256975_.m_7981_((Object)result).m_135815_();
            ((CraftingRecipeBuilder)BCLRecipeBuilder.crafting((ResourceLocation)BN.id(name), (ItemLike)result).setGroup(group).setCategory(category)).setShape(SHAPE_ROUND).addMaterial('#', new ItemLike[]{source}).build();
        }
    }

    public static void makeFireBowlRecipe(Block material, Block inside, Item leg, Block result) {
        if (BuiltInRegistries.f_256975_.m_7981_((Object)material) != BuiltInRegistries.f_256975_.m_122315_() && BuiltInRegistries.f_256975_.m_7981_((Object)inside) != BuiltInRegistries.f_256975_.m_122315_() && BuiltInRegistries.f_257033_.m_7981_((Object)leg) != BuiltInRegistries.f_257033_.m_122315_()) {
            String name = BuiltInRegistries.f_256975_.m_7981_((Object)result).m_135815_();
            ((CraftingRecipeBuilder)BCLRecipeBuilder.crafting((ResourceLocation)BN.id(name), (ItemLike)result).setGroup("fire_bowl").setShape(SHAPE_FIRE_BOWL).addMaterial('#', new ItemLike[]{material}).addMaterial('I', new ItemLike[]{inside}).addMaterial('L', new ItemLike[]{leg}).setCategory(RecipeCategory.DECORATIONS)).build();
        }
    }
}

