/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.commands;

import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.time.Duration;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceOrTagKeyArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.commands.LocateCommand;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.feature.RandomPatchFeature;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.phys.Vec3;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiome;
import org.betterx.bclib.api.v3.levelgen.features.BCLFeature;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.commands.PlaceCommand;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.registry.features.placed.NetherVegetationPlaced;
import org.betterx.betternether.world.NetherBiomeBuilder;
import org.betterx.worlds.together.world.event.WorldBootstrap;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;

public class CommandRegistry {
    private static final DynamicCommandExceptionType ERROR_BIOME_NOT_FOUND = new DynamicCommandExceptionType(object -> Component.m_237113_((String)("The next biome (" + object + ") was not found.")));
    private static final int MAX_SEARCH_RADIUS = 12800;
    private static final int SAMPLE_RESOLUTION_HORIZONTAL = 32;
    private static final int SAMPLE_RESOLUTION_VERTICAL = 64;
    private static int biomeIndex = 0;
    private static int placeMapIdx = 0;
    private static final BlockState[] states = new BlockState[]{Blocks.f_50214_.m_49966_(), Blocks.f_50211_.m_49966_(), Blocks.f_50204_.m_49966_(), Blocks.f_50205_.m_49966_(), Blocks.f_50206_.m_49966_(), Blocks.f_50213_.m_49966_(), Blocks.f_50147_.m_49966_(), Blocks.f_50215_.m_49966_(), Blocks.f_50148_.m_49966_(), Blocks.f_50203_.m_49966_()};
    private static final BlockState[] states2 = new BlockState[]{Blocks.f_50504_.m_49966_(), Blocks.f_50501_.m_49966_(), Blocks.f_50494_.m_49966_(), Blocks.f_50495_.m_49966_(), Blocks.f_50496_.m_49966_(), Blocks.f_50503_.m_49966_(), Blocks.f_50542_.m_49966_(), Blocks.f_50505_.m_49966_(), Blocks.f_50543_.m_49966_(), Blocks.f_50545_.m_49966_()};

    public static void register() {
        CommandRegistrationCallback.EVENT.register(CommandRegistry::register);
    }

    private static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandBuildContext, Commands.CommandSelection commandSelection) {
        LiteralArgumentBuilder<CommandSourceStack> bnContext = (LiteralArgumentBuilder<CommandSourceStack>)Commands.m_82127_((String)"bn").requires(source -> source.m_6761_(4));
        bnContext = PlaceCommand.register(bnContext);
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)bnContext.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"test_place").requires(source -> source.m_6761_(4))).executes(ctx -> CommandRegistry.testPlace((CommandContext<CommandSourceStack>)ctx)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"find_surface").requires(source -> source.m_6761_(4))).executes(ctx -> CommandRegistry.findSurface((CommandContext<CommandSourceStack>)ctx)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"tpnext").requires(source -> source.m_6761_(4))).executes(ctx -> CommandRegistry.teleportToNextBiome((CommandContext<CommandSourceStack>)ctx)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"place_all").requires(source -> source.m_6761_(4))).executes(ctx -> CommandRegistry.placeAllBlocks((CommandContext<CommandSourceStack>)ctx)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"place_matching").requires(source -> source.m_6761_(4))).then(Commands.m_82129_((String)"type", (ArgumentType)StringArgumentType.string()).executes(ctx -> CommandRegistry.placeMatchingBlocks((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"type"))))));
    }

    private static int teleportToNextBiome(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        BlockPos target;
        BlockState state;
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        List<BCLBiome> biomes = NetherBiomeBuilder.getAllBnBiomes();
        if (biomeIndex < 0 || biomeIndex >= biomes.size()) {
            source.m_81352_((Component)Component.m_237113_((String)"Failed to find the next Biome...").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
            return 0;
        }
        final BCLBiome biome = biomes.get(biomeIndex);
        source.m_288197_(() -> Component.m_237113_((String)("Locating Biome " + biome)).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_GREEN)), false);
        biomeIndex = (biomeIndex + 1) % biomes.size();
        BlockPos currentPosition = new BlockPos((int)source.m_81371_().f_82479_, (int)source.m_81371_().f_82480_, (int)source.m_81371_().f_82481_);
        BlockPos biomePosition = (BlockPos)source.m_81372_().m_215069_(b -> ((ResourceKey)b.m_203543_().orElseThrow()).m_135782_().equals((Object)biome.getID()), currentPosition, 12800, 32, 64).getFirst();
        final String biomeName = biome.toString();
        if (biomePosition == null) {
            throw ERROR_BIOME_NOT_FOUND.create((Object)biomeName);
        }
        ServerPlayer player = source.m_81375_();
        double yPos = source.m_81371_().m_7098_();
        boolean didWrap = false;
        do {
            target = new BlockPos(biomePosition.m_123341_(), (int)yPos, biomePosition.m_123343_());
            state = player.m_9236_().m_8055_(target);
            if (!((yPos -= 1.0) <= (double)(player.m_9236_().m_141937_() + 1))) continue;
            if (didWrap) break;
            yPos = 127.0;
            didWrap = true;
        } while (!state.m_60795_() && yPos > (double)player.m_9236_().m_141937_() && yPos < (double)player.m_9236_().m_151558_());
        Vector3d targetPlayerPos = new Vector3d((double)target.m_123341_() + 0.5, (double)(target.m_123342_() - 1), (double)target.m_123343_() + 0.5);
        player.f_8906_.m_9780_(targetPlayerPos.x, targetPlayerPos.y, targetPlayerPos.z, 0.0f, 0.0f, Collections.EMPTY_SET);
        ResourceOrTagKeyArgument.Result result = new ResourceOrTagKeyArgument.Result(){

            public Either<ResourceKey, TagKey> m_245276_() {
                return Either.left((Object)biome.getBiomeKey());
            }

            public Optional<ResourceOrTagKeyArgument.Result> m_245137_(ResourceKey resourceKey) {
                return Optional.empty();
            }

            public String m_245390_() {
                return biomeName;
            }

            public boolean test(Object o) {
                return false;
            }
        };
        ResourceKey a = biome.getBiomeKey();
        if (WorldBootstrap.getLastRegistryAccess() != null) {
            Stopwatch stopwatch = Stopwatch.createStarted((Ticker)Util.f_211544_);
            Holder h = (Holder)WorldBootstrap.getLastRegistryAccess().m_175515_(Registries.f_256952_).m_203636_(a).orElseThrow();
            stopwatch.stop();
            return LocateCommand.m_262810_((CommandSourceStack)source, (ResourceOrTagKeyArgument.Result)result, (BlockPos)currentPosition, (Pair)new Pair((Object)biomePosition, (Object)h), (String)"commands.locatebiome.success", (boolean)false, (Duration)stopwatch.elapsed());
        }
        return 1;
    }

    private static int placeMatchingBlocks(CommandContext<CommandSourceStack> ctx, String type) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        ServerPlayer player = source.m_81375_();
        Vec3 pos = source.m_81371_();
        LinkedList<Block> blocks = new LinkedList<Block>();
        for (Block block : NetherBlocks.getModBlocks().stream().sorted(CommandRegistry::compareBlockNames).collect(Collectors.toList())) {
            String name = BuiltInRegistries.f_256975_.m_7981_((Object)block).m_135815_();
            if (name.indexOf(type) < 0) continue;
            blocks.add(block);
        }
        CommandRegistry.placeBlockRow(player, pos, blocks, 1, true);
        return 1;
    }

    @NotNull
    private static int compareBlockNames(Block a, Block b) {
        String as = BuiltInRegistries.f_256975_.m_7981_((Object)a).m_135815_();
        String bs = BuiltInRegistries.f_256975_.m_7981_((Object)b).m_135815_();
        return as.compareTo(bs);
    }

    private static int findSurface(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        ServerPlayer player = source.m_81375_();
        Vec3 pos = source.m_81371_();
        ServerLevel level = source.m_81372_();
        BlockPos.MutableBlockPos mPos = new BlockPos((int)pos.f_82479_, (int)pos.f_82480_, (int)pos.f_82481_).m_122032_();
        System.out.println("Staring at: " + mPos + " -> " + level.m_8055_((BlockPos)mPos));
        boolean found = org.betterx.bclib.util.BlocksHelper.findSurroundingSurface((LevelAccessor)level, (BlockPos.MutableBlockPos)mPos, (Direction)Direction.DOWN, (int)12, state -> BlocksHelper.isNetherGroundMagma(state));
        System.out.println("Ending at: " + mPos + " -> " + level.m_8055_((BlockPos)mPos) + " = " + found);
        org.betterx.bclib.util.BlocksHelper.setWithoutUpdate((LevelAccessor)level, (BlockPos)new BlockPos((int)pos.f_82479_, (int)pos.f_82480_, (int)pos.f_82481_), (Block)Blocks.f_50494_);
        org.betterx.bclib.util.BlocksHelper.setWithoutUpdate((LevelAccessor)level, (BlockPos)mPos, (Block)Blocks.f_50545_);
        return 1;
    }

    private static int testPlace(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        ServerPlayer player = source.m_81375_();
        Vec3 pos = source.m_81371_();
        ServerLevel level = source.m_81372_();
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (int x = -16; x <= 16; ++x) {
            for (int y = -16; y <= 16; ++y) {
                double v = Biome.f_47433_.m_75449_(((double)x + pos.f_82479_) / 200.0, ((double)y + pos.f_82481_) / 200.0, false);
                if (v < min) {
                    min = v;
                }
                if (!(v > max)) continue;
                max = v;
            }
        }
        System.out.println("Noise: " + min + " - " + max);
        BCLFeature<RandomPatchFeature, RandomPatchConfiguration> feature = NetherVegetationPlaced.VEGETATION_GRASSLANDS;
        PlacedFeature pFeature = (PlacedFeature)((Holder.Reference)level.m_9598_().m_175515_(Registries.f_256988_).m_203636_((ResourceKey)feature.getPlacedFeature().m_203543_().get()).get()).m_203334_();
        List placements = pFeature.f_191776_();
        PlacementContext pctx = new PlacementContext((WorldGenLevel)level, level.m_7726_().m_8481_(), Optional.of(pFeature));
        Stream<Object> s = Stream.of(new BlockPos((int)pos.f_82479_, (int)pos.f_82480_, (int)pos.f_82481_));
        LegacyRandomSource rnd = new LegacyRandomSource(121212L);
        placeMapIdx = 0;
        LinkedList posStates = new LinkedList();
        for (PlacementModifier p2 : placements) {
            s = s.flatMap(arg_0 -> CommandRegistry.lambda$testPlace$15(p2, pctx, (RandomSource)rnd, arg_0));
            List<Object> list = s.toList();
            placeMapIdx = (placeMapIdx + 1) % states.length;
            BlockState state1 = states[placeMapIdx];
            System.out.println(p2.getClass().getSimpleName() + " -> " + list.size() + ", " + state1);
            list.forEach(bp -> {
                BlockState state = states[placeMapIdx];
                if (org.betterx.bclib.util.BlocksHelper.isTerrain((BlockState)level.m_8055_(bp))) {
                    state = states2[placeMapIdx];
                }
                posStates.add(new Pair(bp, (Object)state));
            });
            s = list.stream();
        }
        posStates.forEach(p -> BlocksHelper.setWithoutUpdate((LevelAccessor)level, (BlockPos)p.getFirst(), (BlockState)p.getSecond()));
        return 1;
    }

    private static int placeAllBlocks(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        ServerPlayer player = source.m_81375_();
        Vec3 pos = source.m_81371_();
        LinkedList<Block> pickaxes = new LinkedList<Block>();
        LinkedList<Block> axes = new LinkedList<Block>();
        LinkedList<Block> hoes = new LinkedList<Block>();
        LinkedList<Block> shovels = new LinkedList<Block>();
        LinkedList<Block> other = new LinkedList<Block>();
        for (Block block : NetherBlocks.getModBlocks().stream().sorted(CommandRegistry::compareBlockNames).collect(Collectors.toList())) {
            BlockState state = block.m_49966_();
            if (state.m_204336_(BlockTags.f_144282_)) {
                pickaxes.add(block);
                continue;
            }
            if (state.m_204336_(BlockTags.f_144280_)) {
                axes.add(block);
                continue;
            }
            if (state.m_204336_(BlockTags.f_144281_)) {
                hoes.add(block);
                continue;
            }
            if (state.m_204336_(BlockTags.f_144283_)) {
                shovels.add(block);
                continue;
            }
            other.add(block);
        }
        CommandRegistry.placeBlockRow(player, pos, pickaxes, 1, false);
        CommandRegistry.placeBlockRow(player, pos, axes, 2, false);
        CommandRegistry.placeBlockRow(player, pos, hoes, 3, false);
        CommandRegistry.placeBlockRow(player, pos, shovels, 4, false);
        CommandRegistry.placeBlockRow(player, pos, other, 5, false);
        return 1;
    }

    private static void placeBlockRow(ServerPlayer player, Vec3 pos, List<Block> blocklist, int offset, boolean square) {
        int i = 0;
        int j = 0;
        int rowLen = (int)Math.ceil(Math.sqrt(blocklist.size()));
        blocklist.sort((a, b) -> {
            if (a instanceof DoorBlock && !(b instanceof DoorBlock)) {
                return 1;
            }
            if (!(a instanceof DoorBlock) && b instanceof DoorBlock) {
                return -1;
            }
            return 0;
        });
        for (Block bl : blocklist) {
            BlockState state = bl.m_49966_();
            BlockPos blockPos = new BlockPos((int)pos.f_82479_ + i, (int)pos.f_82480_ + j, (int)pos.f_82481_ + offset);
            CommandRegistry.place(player, bl, state, blockPos);
            if (++i < rowLen) continue;
            i = 0;
            ++j;
        }
    }

    private static void place(ServerPlayer player, Block bl, BlockState state, BlockPos blockPos) {
        if (bl instanceof LadderBlock) {
            // empty if block
        }
        BlocksHelper.setWithoutUpdate((LevelAccessor)player.m_9236_(), blockPos, state);
        if (bl instanceof DoorBlock) {
            BlocksHelper.setWithoutUpdate((LevelAccessor)player.m_9236_(), blockPos.m_7494_(), (BlockState)state.m_61124_((Property)DoorBlock.f_52730_, (Comparable)DoubleBlockHalf.UPPER));
        }
    }

    private static /* synthetic */ Stream lambda$testPlace$15(PlacementModifier p, PlacementContext pctx, RandomSource rnd, BlockPos bp) {
        return p.m_213676_(pctx, rnd, bp);
    }
}

