/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.interfaces.tools.AddMineableHoe;
import org.betterx.betternether.blocks.BNBlockProperties;
import org.betterx.betternether.blocks.BNRenderLayer;
import org.betterx.betternether.blocks.BlockBNPot;
import org.betterx.betternether.blocks.BlockBaseNotFull;
import org.betterx.betternether.blocks.materials.Materials;
import org.betterx.betternether.registry.NetherBlocks;

public class BlockPottedPlant
extends BlockBaseNotFull
implements AddMineableHoe {
    public static final EnumProperty<BNBlockProperties.PottedPlantShape> PLANT = BNBlockProperties.PLANT;

    public BlockPottedPlant() {
        super(Materials.NETHER_PLANT.m_284180_(MapColor.f_283927_).m_60953_(BlockPottedPlant::getLuminance).m_222979_(BlockBehaviour.OffsetType.NONE));
        this.setDropItself(false);
        this.setRenderLayer(BNRenderLayer.CUTOUT);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(PLANT, (Comparable)((Object)BNBlockProperties.PottedPlantShape.AGAVE)));
    }

    private static int getLuminance(BlockState blockState) {
        if (!blockState.m_61138_(PLANT)) {
            return 0;
        }
        if (blockState.m_61143_(PLANT) == BNBlockProperties.PottedPlantShape.WILLOW) {
            return 12;
        }
        if (blockState.m_61143_(PLANT) == BNBlockProperties.PottedPlantShape.JELLYFISH_MUSHROOM) {
            return 13;
        }
        return 0;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        Block block = ((BNBlockProperties.PottedPlantShape)((Object)state.m_61143_(PLANT))).getBlock();
        Vec3 vec3d = block.m_49966_().m_60824_(view, pos);
        return block.m_5940_(block.m_49966_(), view, pos, ePos).m_83216_(-vec3d.f_82479_, -0.5 - vec3d.f_82480_, -vec3d.f_82481_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.m_61104_(new Property[]{PLANT});
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        return world.m_8055_(pos.m_7495_()).m_60734_() instanceof BlockBNPot;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!this.m_7898_(state, (LevelReader)world, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    @Override
    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        Block block = ((BNBlockProperties.PottedPlantShape)((Object)state.m_61143_(PLANT))).getBlock();
        return Collections.singletonList(new ItemStack((ItemLike)block.m_5456_()));
    }

    public static BlockState getPlant(Item item) {
        for (BNBlockProperties.PottedPlantShape shape : BNBlockProperties.PottedPlantShape.values()) {
            if (!shape.getItem().equals(item)) continue;
            return (BlockState)NetherBlocks.POTTED_PLANT.m_49966_().m_61124_(PLANT, (Comparable)((Object)shape));
        }
        return null;
    }
}

