/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.ToIntFunction;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.behaviours.BehaviourBuilders;
import org.betterx.bclib.behaviours.interfaces.BehaviourClimableVine;
import org.betterx.bclib.blocks.BlockProperties;
import org.betterx.betternether.MHelper;
import org.betterx.betternether.blocks.BNRenderLayer;
import org.betterx.betternether.blocks.BlockBaseNotFull;
import org.betterx.betternether.registry.NetherItems;
import org.betterx.betternether.world.features.DeferedSeedBlock;

public class BlockLumabusVine
extends BlockBaseNotFull
implements DeferedSeedBlock,
BehaviourClimableVine {
    private static final VoxelShape MIDDLE_SHAPE = BlockLumabusVine.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape BOTTOM_SHAPE = BlockLumabusVine.m_49796_((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    public static final EnumProperty<BlockProperties.TripleShape> SHAPE = BlockProperties.TRIPLE_SHAPE;
    private static final RandomSource RANDOM = new LegacyRandomSource(130520220102L);
    private Block seed;

    public BlockLumabusVine() {
        super(BehaviourBuilders.createStaticVine((MapColor)MapColor.f_283772_).m_60953_(BlockLumabusVine.getLuminance()));
        this.setRenderLayer(BNRenderLayer.CUTOUT);
        this.setDropItself(false);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(SHAPE, (Comparable)BlockProperties.TripleShape.TOP));
    }

    @Override
    public void setSeed(Block seed) {
        this.seed = seed;
    }

    private static ToIntFunction<BlockState> getLuminance() {
        return blockState -> blockState.m_61145_(SHAPE).orElse(BlockProperties.TripleShape.TOP) == BlockProperties.TripleShape.BOTTOM ? 15 : 0;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.m_61104_(new Property[]{SHAPE});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return state.m_61143_(SHAPE) == BlockProperties.TripleShape.BOTTOM ? BOTTOM_SHAPE : MIDDLE_SHAPE;
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        BlockState upState = world.m_8055_(pos.m_7494_());
        return upState.m_60734_() == this || upState.m_60783_((BlockGetter)world, pos, Direction.DOWN);
    }

    @Environment(value=EnvType.CLIENT)
    public float m_7749_(BlockState state, BlockGetter view, BlockPos pos) {
        return 1.0f;
    }

    public boolean m_7420_(BlockState state, BlockGetter view, BlockPos pos) {
        return true;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return this.m_7898_(state, (LevelReader)world, pos) && (world.m_8055_(pos.m_7495_()).m_60734_() == this || state.m_61143_(SHAPE) == BlockProperties.TripleShape.BOTTOM) ? state : Blocks.f_50016_.m_49966_();
    }

    @Override
    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        if (state.m_61143_(SHAPE) == BlockProperties.TripleShape.BOTTOM) {
            return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((ItemLike)this.seed, MHelper.randRange(1, 3, RANDOM)), new ItemStack((ItemLike)NetherItems.GLOWSTONE_PILE, MHelper.randRange(1, 3, RANDOM))});
        }
        return Lists.newArrayList();
    }

    @Environment(value=EnvType.CLIENT)
    public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)this.seed);
    }
}

