/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import org.betterx.bclib.blocks.BlockProperties;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.blocks.BNRenderLayer;
import org.betterx.betternether.blocks.BlockBaseNotFull;
import org.betterx.betternether.blocks.materials.Materials;

public abstract class BlockCommonPlant
extends BlockBaseNotFull
implements BonemealableBlock {
    public static final IntegerProperty AGE = BlockProperties.AGE;

    public BlockCommonPlant(MapColor color) {
        this(Materials.NETHER_PLANT.m_284180_(color).m_60977_());
    }

    public BlockCommonPlant(BlockBehaviour.Properties settings) {
        super(settings.m_60977_());
        this.setRenderLayer(BNRenderLayer.CUTOUT);
        this.setDropItself(false);
    }

    public int getMaxAge() {
        return 3;
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        stateManager.m_61104_(new Property[]{AGE});
    }

    public abstract boolean m_7898_(BlockState var1, LevelReader var2, BlockPos var3);

    public BlockState m_7417_(BlockState state, Direction facing, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!this.m_7898_(state, (LevelReader)world, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    public boolean m_7370_(LevelReader world, BlockPos pos, BlockState state, boolean isClient) {
        return (Integer)state.m_61143_((Property)AGE) < 3;
    }

    public boolean m_214167_(Level world, RandomSource random, BlockPos pos, BlockState state) {
        int age = (Integer)state.m_61143_((Property)AGE);
        if (age < 3) {
            return BlocksHelper.isFertile(world.m_8055_(pos.m_7495_())) ? random.m_188499_() : random.m_188503_(4) == 0;
        }
        return false;
    }

    protected boolean canGrowTerrain(Level world, RandomSource random, BlockPos pos, BlockState state) {
        int age = (Integer)state.m_61143_((Property)AGE);
        if (age < 3) {
            return BlocksHelper.isFertile(world.m_8055_(pos.m_7495_())) ? random.m_188503_(8) == 0 : random.m_188503_(16) == 0;
        }
        return false;
    }

    public void m_214148_(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        int age = (Integer)state.m_61143_((Property)AGE);
        world.m_46597_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(age + 1)));
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        super.m_213897_(state, world, pos, random);
        if (this.canGrowTerrain((Level)world, random, pos, state)) {
            this.m_214148_(world, random, pos, state);
        }
    }
}

