/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import java.util.Collections;
import java.util.List;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import org.betterx.bclib.behaviours.BehaviourHelper;
import org.betterx.bclib.behaviours.interfaces.BehaviourMetal;
import org.betterx.bclib.behaviours.interfaces.BehaviourStone;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.betternether.blocks.BNRenderLayer;
import org.betterx.betternether.client.IRenderTypeable;

public class BlockBase
extends Block
implements IRenderTypeable {
    private boolean dropItself = true;
    private BNRenderLayer layer = BNRenderLayer.SOLID;

    public BlockBase(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public void setRenderLayer(BNRenderLayer layer) {
        this.layer = layer;
    }

    @Override
    public BNRenderLayer getRenderLayer() {
        return this.layer;
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        if (this.dropItself) {
            return Collections.singletonList(new ItemStack((ItemLike)this.m_5456_()));
        }
        return super.m_49635_(state, builder);
    }

    public void setDropItself(boolean drop) {
        this.dropItself = drop;
    }

    public static BlockBase from(Block source) {
        return (BlockBase)BehaviourHelper.from((Block)source, Wood::new, Stone::new, Metal::new);
    }

    public static class Wood
    extends BlockBase
    implements BehaviourWood {
        public Wood(Block source) {
            super((BlockBehaviour.Properties)FabricBlockSettings.copyOf((BlockBehaviour)source));
        }

        public Wood(BlockBehaviour.Properties settings) {
            super(settings);
        }
    }

    public static class Metal
    extends BlockBase
    implements BehaviourMetal {
        public Metal(Block source) {
            super((BlockBehaviour.Properties)FabricBlockSettings.copyOf((BlockBehaviour)source));
        }

        public Metal(BlockBehaviour.Properties settings) {
            super(settings);
        }
    }

    public static class Stone
    extends BlockBase
    implements BehaviourStone {
        public Stone(Block source) {
            super((BlockBehaviour.Properties)FabricBlockSettings.copyOf((BlockBehaviour)source));
        }

        public Stone(BlockBehaviour.Properties settings) {
            super(settings);
        }
    }
}

