/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blockentities;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.blocks.BlockChestOfDrawers;
import org.betterx.betternether.registry.BlockEntitiesRegistry;

public class BlockEntityChestOfDrawers
extends RandomizableContainerBlockEntity {
    private NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
    private int watchers = 0;

    public BlockEntityChestOfDrawers(BlockPos pos, BlockState state) {
        super(BlockEntitiesRegistry.CHEST_OF_DRAWERS, pos, state);
    }

    public int m_6643_() {
        return 27;
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.inventory;
    }

    protected void m_6520_(NonNullList<ItemStack> list) {
        this.inventory = list;
    }

    protected Component m_6820_() {
        return Component.m_237110_((String)"container.chest_of_drawers", (Object[])new Object[0]);
    }

    protected AbstractContainerMenu m_6555_(int syncId, Inventory playerInventory) {
        return ChestMenu.m_39237_((int)syncId, (Inventory)playerInventory, (Container)this);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inventory = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(tag)) {
            ContainerHelper.m_18980_((CompoundTag)tag, this.inventory);
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (!this.m_59634_(tag)) {
            ContainerHelper.m_18973_((CompoundTag)tag, this.inventory);
        }
    }

    public void onInvOpen(Player player) {
        if (!player.m_5833_()) {
            if (this.watchers < 0) {
                this.watchers = 0;
            }
            if (this.watchers == 0) {
                this.playSound(this.m_58900_(), SoundEvents.f_11725_);
            }
            ++this.watchers;
            this.onInvOpenOrClose();
        }
    }

    public void m_5785_(Player player) {
        if (!player.m_5833_()) {
            --this.watchers;
            this.onInvOpenOrClose();
        }
    }

    protected void onInvOpenOrClose() {
        BlockState state = this.m_58900_();
        Block block = state.m_60734_();
        if (block instanceof BlockChestOfDrawers && !this.f_58857_.f_46443_) {
            if (this.watchers > 0 && !((Boolean)state.m_61143_((Property)BlockChestOfDrawers.OPEN)).booleanValue()) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)this.f_58857_, this.f_58858_, (BlockState)state.m_61124_((Property)BlockChestOfDrawers.OPEN, (Comparable)Boolean.valueOf(true)));
            } else if (this.watchers == 0 && ((Boolean)state.m_61143_((Property)BlockChestOfDrawers.OPEN)).booleanValue()) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)this.f_58857_, this.f_58858_, (BlockState)state.m_61124_((Property)BlockChestOfDrawers.OPEN, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    private void playSound(BlockState blockState, SoundEvent soundEvent) {
        Vec3i vec3i = ((Direction)blockState.m_61143_((Property)BlockChestOfDrawers.FACING)).m_122436_();
        double d = (double)this.f_58858_.m_123341_() + 0.5 + (double)vec3i.m_123341_() / 2.0;
        double e = (double)this.f_58858_.m_123342_() + 0.5 + (double)vec3i.m_123342_() / 2.0;
        double f = (double)this.f_58858_.m_123343_() + 0.5 + (double)vec3i.m_123343_() / 2.0;
        this.f_58857_.m_6263_(null, d, e, f, soundEvent, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f);
    }

    public void addItemsToList(List<ItemStack> items) {
        for (ItemStack item : this.inventory) {
            if (item == null) continue;
            items.add(item);
        }
    }
}

