/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.structures.piece;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.noise.OpenSimplexNoise;
import org.betterx.betterend.world.structures.piece.BasePiece;

public abstract class MountainPiece
extends BasePiece {
    protected Map<Integer, Integer> heightmap = Maps.newHashMap();
    protected OpenSimplexNoise noise1;
    protected OpenSimplexNoise noise2;
    protected BlockPos center;
    protected float radius;
    protected float height;
    protected float r2;
    protected ResourceLocation biomeID;
    protected int seed1;
    protected int seed2;

    public MountainPiece(StructurePieceType type, BlockPos center, float radius, float height, RandomSource random, Holder<Biome> biome) {
        super(type, random.m_188502_(), null);
        this.center = center;
        this.radius = radius;
        this.height = height;
        this.r2 = radius * radius;
        this.seed1 = random.m_188502_();
        this.seed2 = random.m_188502_();
        this.noise1 = new OpenSimplexNoise(this.seed1);
        this.noise2 = new OpenSimplexNoise(this.seed2);
        this.biomeID = BiomeAPI.getBiomeID(biome);
        this.makeBoundingBox();
    }

    public MountainPiece(StructurePieceType type, CompoundTag tag) {
        super(type, tag);
        this.makeBoundingBox();
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag tag) {
        tag.m_128365_("center", (Tag)NbtUtils.m_129224_((BlockPos)this.center));
        tag.m_128350_("radius", this.radius);
        tag.m_128350_("height", this.height);
        tag.m_128359_("biome", this.biomeID.toString());
        tag.m_128405_("seed1", this.seed1);
        tag.m_128405_("seed2", this.seed2);
    }

    @Override
    protected void fromNbt(CompoundTag tag) {
        this.center = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("center"));
        this.radius = tag.m_128457_("radius");
        this.height = tag.m_128457_("height");
        this.biomeID = new ResourceLocation(tag.m_128461_("biome"));
        this.r2 = this.radius * this.radius;
        this.seed1 = tag.m_128451_("seed1");
        this.seed2 = tag.m_128451_("seed2");
        this.noise1 = new OpenSimplexNoise(this.seed1);
        this.noise2 = new OpenSimplexNoise(this.seed2);
    }

    private int getHeight(WorldGenLevel world, BlockPos pos) {
        int p = (pos.m_123341_() & 0x7FF) << 11 | pos.m_123343_() & 0x7FF;
        int h = this.heightmap.getOrDefault(p, Integer.MIN_VALUE);
        if (h > Integer.MIN_VALUE) {
            return h;
        }
        if (!BiomeAPI.getBiomeID((Holder)world.m_204166_(pos)).equals((Object)this.biomeID)) {
            this.heightmap.put(p, -10);
            return -10;
        }
        h = world.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, pos.m_123341_(), pos.m_123343_());
        if ((h = Mth.m_14040_((int)(h - this.center.m_123342_()))) > 4) {
            h = 4 - h;
            this.heightmap.put(p, h);
            return h;
        }
        h = MHelper.floor((double)(this.noise2.eval((double)pos.m_123341_() * 0.01, (double)pos.m_123343_() * 0.01) * this.noise2.eval((double)pos.m_123341_() * 0.002, (double)pos.m_123343_() * 0.002) * 8.0 + 8.0));
        if (h < 0) {
            this.heightmap.put(p, 0);
            return 0;
        }
        this.heightmap.put(p, h);
        return h;
    }

    protected float getHeightClamp(WorldGenLevel world, int radius, int posX, int posZ) {
        BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
        float height = 0.0f;
        float max = 0.0f;
        for (int x = -radius; x <= radius; ++x) {
            mut.m_142451_(posX + x);
            int x2 = x * x;
            for (int z = -radius; z <= radius; ++z) {
                mut.m_142443_(posZ + z);
                int z2 = z * z;
                float mult = 1.0f - (float)Math.sqrt(x2 + z2) / (float)radius;
                if (!(mult > 0.0f)) continue;
                max += mult;
                height += (float)this.getHeight(world, (BlockPos)mut) * mult;
            }
        }
        return Mth.m_14036_((float)((height /= max) / (float)radius), (float)0.0f, (float)1.0f);
    }

    private void makeBoundingBox() {
        int minX = MHelper.floor((double)((float)this.center.m_123341_() - this.radius));
        int minY = MHelper.floor((double)((float)this.center.m_123342_() - this.radius));
        int minZ = MHelper.floor((double)((float)this.center.m_123343_() - this.radius));
        int maxX = MHelper.floor((double)((float)this.center.m_123341_() + this.radius + 1.0f));
        int maxY = MHelper.floor((double)((float)this.center.m_123342_() + this.radius + 1.0f));
        int maxZ = MHelper.floor((double)((float)this.center.m_123343_() + this.radius + 1.0f));
        this.f_73383_ = new BoundingBox(minX, minY, minZ, maxX, maxY, maxZ);
    }
}

