/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.generator;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseSettings;
import org.betterx.bclib.api.v2.generator.BCLibEndBiomeSource;
import org.betterx.bclib.api.v2.generator.config.BCLEndBiomeSourceConfig;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiome;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.interfaces.BETargetChecker;
import org.betterx.betterend.mixin.common.NoiseBasedChunkGeneratorAccessor;
import org.betterx.betterend.mixin.common.NoiseChunkAccessor;
import org.betterx.betterend.mixin.common.NoiseInterpolatorAccessor;
import org.betterx.betterend.noise.OpenSimplexNoise;
import org.betterx.betterend.world.generator.GeneratorOptions;
import org.betterx.betterend.world.generator.IslandLayer;
import org.betterx.betterend.world.generator.TerrainBoolCache;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public class TerrainGenerator {
    private static final Map<Point, TerrainBoolCache> TERRAIN_BOOL_CACHE_MAP = Maps.newHashMap();
    private static final ReentrantLock LOCKER = new ReentrantLock();
    private static final Point POS = new Point();
    private static final double SCALE_XZ = 8.0;
    private static final double SCALE_Y = 4.0;
    private static final float[] COEF;
    private static final Point[] OFFS;
    private static IslandLayer largeIslands;
    private static IslandLayer mediumIslands;
    private static IslandLayer smallIslands;
    private static OpenSimplexNoise noise1;
    private static OpenSimplexNoise noise2;
    private static BiomeSource biomeSource;
    private static Climate.Sampler sampler;

    public static void initNoise(long seed, BiomeSource biomeSource, Climate.Sampler sampler) {
        LegacyRandomSource random = new LegacyRandomSource(seed);
        largeIslands = new IslandLayer(random.m_188502_(), GeneratorOptions.bigOptions);
        mediumIslands = new IslandLayer(random.m_188502_(), GeneratorOptions.mediumOptions);
        smallIslands = new IslandLayer(random.m_188502_(), GeneratorOptions.smallOptions);
        noise1 = new OpenSimplexNoise(random.m_188502_());
        noise2 = new OpenSimplexNoise(random.m_188502_());
        TERRAIN_BOOL_CACHE_MAP.clear();
        TerrainGenerator.biomeSource = biomeSource;
        TerrainGenerator.sampler = sampler;
    }

    public static void fillTerrainDensity(double[] buffer, int posX, int posZ, int scaleXZ, int scaleY, int maxHeight) {
        LOCKER.lock();
        float fadeOutDist = 27.0f;
        float fadOutStart = (float)maxHeight - 28.0f;
        largeIslands.clearCache();
        mediumIslands.clearCache();
        smallIslands.clearCache();
        int x = Mth.m_14143_((float)(posX / scaleXZ));
        int z = Mth.m_14143_((float)(posZ / scaleXZ));
        double distortion1 = noise1.eval((double)x * 0.1, (double)z * 0.1) * 20.0 + noise2.eval((double)x * 0.2, (double)z * 0.2) * 10.0 + noise1.eval((double)x * 0.4, (double)z * 0.4) * 5.0;
        double distortion2 = noise2.eval((double)x * 0.1, (double)z * 0.1) * 20.0 + noise1.eval((double)x * 0.2, (double)z * 0.2) * 10.0 + noise2.eval((double)x * 0.4, (double)z * 0.4) * 5.0;
        double px = (double)x * (double)scaleXZ + distortion1;
        double pz = (double)z * (double)scaleXZ + distortion2;
        largeIslands.updatePositions(px, pz, maxHeight);
        mediumIslands.updatePositions(px, pz, maxHeight);
        smallIslands.updatePositions(px, pz, maxHeight);
        float height = TerrainGenerator.getAverageDepth(x << 1, z << 1) * 0.5f;
        for (int y = 0; y < buffer.length; ++y) {
            double py = (double)y * (double)scaleY;
            float dist = largeIslands.getDensity(px, py, pz, height);
            dist = dist > 1.0f ? dist : MHelper.max((float)dist, (float)mediumIslands.getDensity(px, py, pz, height));
            float f = dist = dist > 1.0f ? dist : MHelper.max((float)dist, (float)smallIslands.getDensity(px, py, pz, height));
            if (dist > -0.5f) {
                dist = (float)((double)dist + (noise1.eval(px * 0.01, py * 0.01, pz * 0.01) * 0.02 + 0.02));
                dist = (float)((double)dist + (noise2.eval(px * 0.05, py * 0.05, pz * 0.05) * 0.01 + 0.01));
                dist = (float)((double)dist + (noise1.eval(px * 0.1, py * 0.1, pz * 0.1) * 0.005 + 0.005));
            }
            if (py >= (double)maxHeight) {
                dist = -1.0f;
            } else if (py > (double)fadOutStart) {
                dist = (float)Mth.m_14139_((double)((py - (double)fadOutStart) / 27.0), (double)dist, (double)-1.0);
            }
            buffer[y] = dist;
        }
        LOCKER.unlock();
    }

    private static float getAverageDepth(int x, int z) {
        if (biomeSource == null) {
            return 0.0f;
        }
        BCLBiome biome = TerrainGenerator.getBiome(biomeSource, x, z);
        if (biome != null && biome.settings.getTerrainHeight() < 0.1f) {
            return 0.0f;
        }
        float depth = 0.0f;
        for (int i = 0; i < OFFS.length; ++i) {
            int px = x + TerrainGenerator.OFFS[i].x;
            int pz = z + TerrainGenerator.OFFS[i].y;
            biome = TerrainGenerator.getBiome(biomeSource, px, pz);
            depth += biome == null ? 0.0f : biome.settings.getTerrainHeight() * COEF[i];
        }
        return depth;
    }

    @Nullable
    private static BCLBiome getBiome(BiomeSource biomeSource, int x, int z) {
        return BiomeAPI.getBiome((Holder)biomeSource.m_203407_(x, 0, z, sampler));
    }

    public static Boolean isLand(int x, int z, int maxHeight) {
        byte value;
        int sectionX = TerrainBoolCache.scaleCoordinate(x);
        int sectionZ = TerrainBoolCache.scaleCoordinate(z);
        int stepY = (int)Math.ceil((double)maxHeight / 4.0);
        LOCKER.lock();
        POS.setLocation(sectionX, sectionZ);
        TerrainBoolCache section = TERRAIN_BOOL_CACHE_MAP.get(POS);
        if (section == null) {
            if (TERRAIN_BOOL_CACHE_MAP.size() > 64) {
                TERRAIN_BOOL_CACHE_MAP.clear();
            }
            section = new TerrainBoolCache();
            TERRAIN_BOOL_CACHE_MAP.put(new Point(TerrainGenerator.POS.x, TerrainGenerator.POS.y), section);
        }
        if ((value = section.getData(x, z)) > 0) {
            LOCKER.unlock();
            return value > 1;
        }
        double px = (double)(x >> 1) + 0.5;
        double pz = (double)(z >> 1) + 0.5;
        double distortion1 = noise1.eval(px * 0.1, pz * 0.1) * 20.0 + noise2.eval(px * 0.2, pz * 0.2) * 10.0 + noise1.eval(px * 0.4, pz * 0.4) * 5.0;
        double distortion2 = noise2.eval(px * 0.1, pz * 0.1) * 20.0 + noise1.eval(px * 0.2, pz * 0.2) * 10.0 + noise2.eval(px * 0.4, pz * 0.4) * 5.0;
        px = px * 8.0 + distortion1;
        pz = pz * 8.0 + distortion2;
        largeIslands.updatePositions(px, pz, maxHeight);
        mediumIslands.updatePositions(px, pz, maxHeight);
        smallIslands.updatePositions(px, pz, maxHeight);
        boolean result = false;
        for (int y = 0; y < stepY; ++y) {
            double py = (double)y * 4.0;
            float dist = largeIslands.getDensity(px, py, pz);
            dist = dist > 1.0f ? dist : MHelper.max((float)dist, (float)mediumIslands.getDensity(px, py, pz));
            float f = dist = dist > 1.0f ? dist : MHelper.max((float)dist, (float)smallIslands.getDensity(px, py, pz));
            if (dist > -0.5f) {
                dist = (float)((double)dist + (noise1.eval(px * 0.01, py * 0.01, pz * 0.01) * 0.02 + 0.02));
                dist = (float)((double)dist + (noise2.eval(px * 0.05, py * 0.05, pz * 0.05) * 0.01 + 0.01));
                dist = (float)((double)dist + (noise1.eval(px * 0.1, py * 0.1, pz * 0.1) * 0.005 + 0.005));
            }
            if (!((double)dist > -0.01)) continue;
            result = true;
            break;
        }
        section.setData(x, z, (byte)(result ? 2 : 1));
        LOCKER.unlock();
        return result;
    }

    public static void onServerLevelInit(ServerLevel level, LevelStem levelStem, long seed) {
        if (level.m_46472_() == Level.f_46430_) {
            ChunkGenerator chunkGenerator = levelStem.f_63976_();
            if (chunkGenerator instanceof NoiseBasedChunkGenerator) {
                Holder<NoiseGeneratorSettings> sHolder = ((NoiseBasedChunkGeneratorAccessor)chunkGenerator).be_getSettings();
                BiomeSource biomeSource = chunkGenerator.m_62218_();
                if (biomeSource instanceof BCLibEndBiomeSource) {
                    BCLibEndBiomeSource bcl = (BCLibEndBiomeSource)biomeSource;
                    ((BETargetChecker)BETargetChecker.class.cast(sHolder.m_203334_())).be_setTarget(bcl.getTogetherConfig().generatorVersion == BCLEndBiomeSourceConfig.EndBiomeGeneratorType.PAULEVS);
                } else {
                    ((BETargetChecker)BETargetChecker.class.cast(sHolder.m_203334_())).be_setTarget(false);
                }
            }
            TerrainGenerator.initNoise(seed, chunkGenerator.m_62218_(), level.m_7726_().m_214994_().m_224579_());
        }
    }

    public static void makeObsidianPlatform(ServerLevel serverLevel, CallbackInfo info) {
        if (!GeneratorOptions.generateObsidianPlatform()) {
            info.cancel();
        } else if (GeneratorOptions.changeSpawn()) {
            BlockPos blockPos = GeneratorOptions.getSpawn();
            int i = blockPos.m_123341_();
            int j = blockPos.m_123342_() - 2;
            int k = blockPos.m_123343_();
            BlockPos.m_121976_((int)(i - 2), (int)(j + 1), (int)(k - 2), (int)(i + 2), (int)(j + 3), (int)(k + 2)).forEach(blockPosx -> serverLevel.m_46597_(blockPosx, Blocks.f_50016_.m_49966_()));
            BlockPos.m_121976_((int)(i - 2), (int)j, (int)(k - 2), (int)(i + 2), (int)j, (int)(k + 2)).forEach(blockPosx -> serverLevel.m_46597_(blockPosx, Blocks.f_50080_.m_49966_()));
            info.cancel();
        }
    }

    public static void fillSlice(boolean primarySlice, int x, List<NoiseChunk.NoiseInterpolator> interpolators, NoiseChunkAccessor accessor, NoiseSettings noiseSettings) {
        int sizeY = noiseSettings.m_189212_();
        int sizeXZ = noiseSettings.m_189213_();
        int cellSizeXZ = accessor.bnv_getCellCountXZ() + 1;
        int firstCellZ = accessor.bnv_getFirstCellZ();
        x *= sizeXZ;
        for (int cellXZ = 0; cellXZ < cellSizeXZ; ++cellXZ) {
            int z = (firstCellZ + cellXZ) * sizeXZ;
            for (NoiseChunk.NoiseInterpolator noiseInterpolator : interpolators) {
                if (!(noiseInterpolator instanceof NoiseInterpolatorAccessor)) continue;
                NoiseInterpolatorAccessor interpolator = (NoiseInterpolatorAccessor)noiseInterpolator;
                double[] ds = (primarySlice ? interpolator.be_getSlice0() : interpolator.be_getSlice1())[cellXZ];
                TerrainGenerator.fillTerrainDensity(ds, x, z, sizeXZ, sizeY, noiseSettings.f_64508_());
            }
        }
    }

    static {
        float sum = 0.0f;
        ArrayList coef = Lists.newArrayList();
        ArrayList pos = Lists.newArrayList();
        for (int x = -3; x <= 3; ++x) {
            for (int z = -3; z <= 3; ++z) {
                float dist = MHelper.length((float)x, (float)z) / 3.0f;
                if (!(dist <= 1.0f)) continue;
                sum += dist;
                coef.add(Float.valueOf(dist));
                pos.add(new Point(x, z));
            }
        }
        OFFS = pos.toArray(new Point[0]);
        COEF = new float[coef.size()];
        for (int i = 0; i < COEF.length; ++i) {
            TerrainGenerator.COEF[i] = ((Float)coef.get(i)).floatValue() / sum;
        }
    }
}

