/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features.trees;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.bclib.blocks.BlockProperties;
import org.betterx.bclib.sdf.SDF;
import org.betterx.bclib.sdf.operator.SDFDisplacement;
import org.betterx.bclib.sdf.operator.SDFScale;
import org.betterx.bclib.sdf.operator.SDFScale3D;
import org.betterx.bclib.sdf.operator.SDFSubtraction;
import org.betterx.bclib.sdf.operator.SDFTranslate;
import org.betterx.bclib.sdf.operator.SDFUnary;
import org.betterx.bclib.sdf.primitive.SDFPrimitive;
import org.betterx.bclib.sdf.primitive.SDFSphere;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.bclib.util.SplineHelper;
import org.betterx.betterend.blocks.basis.FurBlock;
import org.betterx.betterend.noise.OpenSimplexNoise;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.worlds.together.tag.v3.CommonBlockTags;
import org.joml.Vector3f;

public class LucerniaFeature
extends DefaultFeature {
    private static final Direction[] DIRECTIONS = Direction.values();
    private static final Function<BlockState, Boolean> REPLACE = state -> {
        if (state.m_60734_() == EndBlocks.LUCERNIA_LEAVES) {
            return true;
        }
        return BlocksHelper.replaceableOrPlant((BlockState)state);
    };
    private static final Function<BlockState, Boolean> IGNORE = EndBlocks.LUCERNIA::isTreeLog;
    private static final List<Vector3f> SPLINE = Lists.newArrayList((Object[])new Vector3f[]{new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.1f, 0.35f, 0.0f), new Vector3f(0.2f, 0.5f, 0.0f), new Vector3f(0.3f, 0.55f, 0.0f), new Vector3f(0.42f, 0.7f, 0.0f), new Vector3f(0.5f, 1.0f, 0.0f)});
    private static final List<Vector3f> ROOT = Lists.newArrayList((Object[])new Vector3f[]{new Vector3f(0.1f, 0.7f, 0.0f), new Vector3f(0.3f, 0.3f, 0.0f), new Vector3f(0.7f, 0.05f, 0.0f), new Vector3f(0.8f, -0.2f, 0.0f)});

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> featureConfig) {
        RandomSource random = featureConfig.m_225041_();
        BlockPos pos = featureConfig.m_159777_();
        WorldGenLevel world = featureConfig.m_159774_();
        NoneFeatureConfiguration config = (NoneFeatureConfiguration)featureConfig.m_159778_();
        if (!world.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_13077_)) {
            return false;
        }
        float size = MHelper.randRange((int)12, (int)20, (RandomSource)random);
        int count = (int)(size * 0.3f);
        float var = (float)Math.PI * 2 / (float)(count * 3);
        float start = MHelper.randRange((float)0.0f, (float)((float)Math.PI * 2), (RandomSource)random);
        for (int i = 0; i < count; ++i) {
            float angle = (float)i / (float)count * ((float)Math.PI * 2) + MHelper.randRange((float)0.0f, (float)var, (RandomSource)random) + start;
            List spline = SplineHelper.copySpline(SPLINE);
            SplineHelper.rotateSpline((List)spline, (float)angle);
            SplineHelper.scale((List)spline, (float)(size * MHelper.randRange((float)0.5f, (float)1.0f, (RandomSource)random)));
            SplineHelper.offsetParts((List)spline, (RandomSource)random, (float)1.0f, (float)0.0f, (float)1.0f);
            SplineHelper.fillSpline((List)spline, (WorldGenLevel)world, (BlockState)EndBlocks.LUCERNIA.getBark().m_49966_(), (BlockPos)pos, REPLACE);
            Vector3f last = (Vector3f)spline.get(spline.size() - 1);
            float leavesRadius = (size * 0.13f + MHelper.randRange((float)0.8f, (float)1.5f, (RandomSource)random)) * 1.4f;
            OpenSimplexNoise noise = new OpenSimplexNoise(random.m_188505_());
            this.leavesBall(world, pos.m_7918_((int)last.x(), (int)last.y(), (int)last.z()), leavesRadius, random, noise, config != null);
        }
        this.makeRoots(world, pos.m_7918_(0, MHelper.randRange((int)3, (int)5, (RandomSource)random), 0), size * 0.35f, random);
        return true;
    }

    private void leavesBall(WorldGenLevel world, BlockPos pos, float radius, RandomSource random, OpenSimplexNoise noise, boolean natural) {
        SDFPrimitive sphere = new SDFSphere().setRadius(radius).setBlock((BlockState)EndBlocks.LUCERNIA_LEAVES.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(6)));
        SDFUnary sub = new SDFScale().setScale(5.0f).setSource((SDF)sphere);
        sub = new SDFTranslate().setTranslate(0.0f, -radius * 5.0f, 0.0f).setSource((SDF)sub);
        sphere = new SDFSubtraction().setSourceA((SDF)sphere).setSourceB((SDF)sub);
        sphere = new SDFScale3D().setScale(1.0f, 0.75f, 1.0f).setSource((SDF)sphere);
        sphere = new SDFDisplacement().setFunction(vec -> Float.valueOf((float)noise.eval((double)vec.x() * 0.2, (double)vec.y() * 0.2, (double)vec.z() * 0.2) * 2.0f)).setSource((SDF)sphere);
        sphere = new SDFDisplacement().setFunction(vec -> Float.valueOf(MHelper.randRange((float)-1.5f, (float)1.5f, (RandomSource)random))).setSource((SDF)sphere);
        BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
        for (Direction d1 : BlocksHelper.HORIZONTAL) {
            BlockPos p = mut.m_122190_((Vec3i)pos).m_122173_(Direction.UP).m_122173_(d1).m_7949_();
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)p, (BlockState)EndBlocks.LUCERNIA.getBark().m_49966_());
            for (Direction d2 : BlocksHelper.HORIZONTAL) {
                mut.m_122190_((Vec3i)p).m_122173_(Direction.UP).m_122173_(d2);
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)p, (BlockState)EndBlocks.LUCERNIA.getBark().m_49966_());
            }
        }
        BlockState top = (BlockState)EndBlocks.FILALUX.m_49966_().m_61124_((Property)BlockProperties.TRIPLE_SHAPE, (Comparable)BlockProperties.TripleShape.TOP);
        BlockState middle = (BlockState)EndBlocks.FILALUX.m_49966_().m_61124_((Property)BlockProperties.TRIPLE_SHAPE, (Comparable)BlockProperties.TripleShape.MIDDLE);
        BlockState bottom = (BlockState)EndBlocks.FILALUX.m_49966_().m_61124_((Property)BlockProperties.TRIPLE_SHAPE, (Comparable)BlockProperties.TripleShape.BOTTOM);
        BlockState outer = EndBlocks.LUCERNIA_OUTER_LEAVES.m_49966_();
        ArrayList support = Lists.newArrayList();
        sphere.addPostProcess(info -> {
            if (natural && random.m_188503_(6) == 0 && info.getStateDown().m_60795_()) {
                BlockPos d = info.getPos().m_7495_();
                support.add(d);
            }
            if (random.m_188503_(15) == 0) {
                for (BlockPos blockPos : Direction.values()) {
                    BlockState state = info.getState((Direction)blockPos, 2);
                    if (!state.m_60795_()) continue;
                    return info.getState();
                }
                info.setState(EndBlocks.LUCERNIA.getBark().m_49966_());
            }
            MHelper.shuffle((Object[])DIRECTIONS, (RandomSource)random);
            for (BlockPos blockPos : DIRECTIONS) {
                if (!info.getState((Direction)blockPos).m_60795_()) continue;
                info.setBlockPos(info.getPos().m_121945_((Direction)blockPos), (BlockState)outer.m_61124_((Property)FurBlock.FACING, (Comparable)blockPos));
            }
            if (EndBlocks.LUCERNIA.isTreeLog(info.getState())) {
                for (int x = -6; x < 7; ++x) {
                    int ax = Math.abs(x);
                    mut.m_142451_(x + info.getPos().m_123341_());
                    for (int z = -6; z < 7; ++z) {
                        int n = Math.abs(z);
                        mut.m_142443_(z + info.getPos().m_123343_());
                        for (int y = -6; y < 7; ++y) {
                            int distance;
                            int ay = Math.abs(y);
                            int d = ax + ay + n;
                            if (d >= 7) continue;
                            mut.m_142448_(y + info.getPos().m_123342_());
                            BlockState state = info.getState((BlockPos)mut);
                            if (!(state.m_60734_() instanceof LeavesBlock) || d >= (distance = ((Integer)state.m_61143_((Property)LeavesBlock.f_54418_)).intValue())) continue;
                            info.setState((BlockPos)mut, (BlockState)state.m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(d)));
                        }
                    }
                }
            }
            return info.getState();
        });
        sphere.fillRecursiveIgnore((ServerLevelAccessor)world, pos, IGNORE);
        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (Block)EndBlocks.LUCERNIA.getBark());
        support.forEach(bpos -> {
            BlockState state = world.m_8055_(bpos);
            if (state.m_60795_() || state.m_60713_(EndBlocks.LUCERNIA_OUTER_LEAVES)) {
                int count = MHelper.randRange((int)3, (int)8, (RandomSource)random);
                mut.m_122190_((Vec3i)bpos);
                if (world.m_8055_(mut.m_7494_()).m_60713_(EndBlocks.LUCERNIA_LEAVES)) {
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (BlockState)top);
                    for (int i = 1; i < count; ++i) {
                        mut.m_142448_(mut.m_123342_() - 1);
                        if (!world.m_46859_(mut.m_7495_())) break;
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (BlockState)middle);
                    }
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (BlockState)bottom);
                }
            }
        });
    }

    private void makeRoots(WorldGenLevel world, BlockPos pos, float radius, RandomSource random) {
        int count = (int)(radius * 1.5f);
        for (int i = 0; i < count; ++i) {
            float angle = (float)i / (float)count * ((float)Math.PI * 2);
            float scale = radius * MHelper.randRange((float)0.85f, (float)1.15f, (RandomSource)random);
            List branch = SplineHelper.copySpline(ROOT);
            SplineHelper.rotateSpline((List)branch, (float)angle);
            SplineHelper.scale((List)branch, (float)scale);
            Vector3f last = (Vector3f)branch.get(branch.size() - 1);
            if (!world.m_8055_(pos.m_7918_((int)last.x(), (int)last.y(), (int)last.z())).m_204336_(CommonBlockTags.GEN_END_STONES)) continue;
            SplineHelper.fillSplineForce((List)branch, (WorldGenLevel)world, (BlockState)EndBlocks.LUCERNIA.getBark().m_49966_(), (BlockPos)pos, REPLACE);
        }
    }

    static {
        SplineHelper.offset(ROOT, (Vector3f)new Vector3f(0.0f, -0.45f, 0.0f));
    }
}

