/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features.trees;

import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.phys.AABB;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.bclib.sdf.PosInfo;
import org.betterx.bclib.sdf.SDF;
import org.betterx.bclib.sdf.operator.SDFRotation;
import org.betterx.bclib.sdf.operator.SDFScale;
import org.betterx.bclib.sdf.operator.SDFSmoothUnion;
import org.betterx.bclib.sdf.operator.SDFTranslate;
import org.betterx.bclib.sdf.operator.SDFUnary;
import org.betterx.bclib.sdf.operator.SDFUnion;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.bclib.util.SplineHelper;
import org.betterx.betterend.blocks.HelixTreeLeavesBlock;
import org.betterx.betterend.registry.EndBlocks;
import org.joml.Vector3f;

public class HelixTreeFeature
extends DefaultFeature {
    private static final Function<PosInfo, BlockState> POST = info -> {
        if (EndBlocks.HELIX_TREE.isTreeLog(info.getStateUp()) && EndBlocks.HELIX_TREE.isTreeLog(info.getStateDown())) {
            return EndBlocks.HELIX_TREE.getLog().m_49966_();
        }
        return info.getState();
    };

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> featureConfig) {
        float dz;
        float dx;
        RandomSource random = featureConfig.m_225041_();
        BlockPos pos = featureConfig.m_159777_();
        WorldGenLevel world = featureConfig.m_159774_();
        if (!world.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_13077_)) {
            return false;
        }
        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (BlockState)AIR);
        float angle = random.m_188501_() * ((float)Math.PI * 2);
        float radiusRange = MHelper.randRange((float)4.5f, (float)6.0f, (RandomSource)random);
        float scale = MHelper.randRange((float)0.5f, (float)1.0f, (RandomSource)random);
        ArrayList<Vector3f> spline = new ArrayList<Vector3f>(10);
        for (int i = 0; i < 10; ++i) {
            float radius = (0.9f - (float)i * 0.1f) * radiusRange;
            dx = (float)Math.sin((float)i + angle) * radius;
            dz = (float)Math.cos((float)i + angle) * radius;
            spline.add(new Vector3f(dx, (float)(i * 2), dz));
        }
        SDF sdf = SplineHelper.buildSDF(spline, (float)1.7f, (float)0.5f, p -> EndBlocks.HELIX_TREE.getBark().m_49966_());
        SDFUnary rotated = new SDFRotation().setRotation(Axis.f_252436_, (float)Math.PI).setSource(sdf);
        sdf = new SDFUnion().setSourceA((SDF)rotated).setSourceB(sdf);
        Vector3f lastPoint = (Vector3f)spline.get(spline.size() - 1);
        List spline2 = SplineHelper.makeSpline((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)20.0f, (float)0.0f, (int)5);
        SDF stem = SplineHelper.buildSDF((List)spline2, (float)1.0f, (float)0.5f, p -> EndBlocks.HELIX_TREE.getBark().m_49966_());
        stem = new SDFTranslate().setTranslate(lastPoint.x(), lastPoint.y(), lastPoint.z()).setSource(stem);
        sdf = new SDFSmoothUnion().setRadius(3.0f).setSourceA(sdf).setSourceB(stem);
        sdf = new SDFScale().setScale(scale).setSource(sdf);
        dx = 30.0f * scale;
        float dy1 = -20.0f * scale;
        float dy2 = 100.0f * scale;
        sdf.addPostProcess(POST).fillArea((ServerLevelAccessor)world, pos, new AABB(pos.m_7918_((int)(-dx), (int)dy1, (int)(-dx)), pos.m_7918_((int)dx, (int)dy2, (int)dx)));
        SplineHelper.scale(spline, (float)scale);
        SplineHelper.fillSplineForce(spline, (WorldGenLevel)world, (BlockState)EndBlocks.HELIX_TREE.getBark().m_49966_(), (BlockPos)pos, state -> state.m_247087_());
        SplineHelper.rotateSpline(spline, (float)((float)Math.PI));
        SplineHelper.fillSplineForce(spline, (WorldGenLevel)world, (BlockState)EndBlocks.HELIX_TREE.getBark().m_49966_(), (BlockPos)pos, state -> state.m_247087_());
        SplineHelper.scale((List)spline2, (float)scale);
        BlockPos leafStart = pos.m_7918_((int)((double)lastPoint.x() + 0.5), (int)((double)lastPoint.y() + 0.5), (int)((double)lastPoint.z() + 0.5));
        SplineHelper.fillSplineForce((List)spline2, (WorldGenLevel)world, (BlockState)EndBlocks.HELIX_TREE.getLog().m_49966_(), (BlockPos)leafStart, state -> state.m_247087_());
        spline.clear();
        float rad = MHelper.randRange((float)8.0f, (float)11.0f, (RandomSource)random);
        int count = MHelper.randRange((int)20, (int)30, (RandomSource)random);
        float scaleM = 20.0f / (float)count * scale * 1.75f;
        float hscale = 20.0f / (float)count * 0.05f;
        for (int i = 0; i <= count; ++i) {
            float radius = 1.0f - (float)i * hscale;
            radius = radius * radius * 2.0f - 1.0f;
            radius *= radius;
            radius = (1.0f - radius) * rad * scale;
            dx = (float)Math.sin((float)i * 0.45f + angle) * radius;
            dz = (float)Math.cos((float)i * 0.45f + angle) * radius;
            spline.add(new Vector3f(dx, (float)i * scaleM, dz));
        }
        Vector3f start = new Vector3f();
        Vector3f end = new Vector3f();
        lastPoint = (Vector3f)spline.get(0);
        BlockState leaf = EndBlocks.HELIX_TREE_LEAVES.m_49966_();
        for (int i = 1; i < spline.size(); ++i) {
            Vector3f point = (Vector3f)spline.get(i);
            int minY = MHelper.floor((double)lastPoint.y());
            int maxY = MHelper.floor((double)point.y());
            float div = point.y() - lastPoint.y();
            for (float py = (float)minY; py <= (float)maxY; py += 0.2f) {
                start.set(0.0f, py, 0.0f);
                float delta = (py - (float)minY) / div;
                float px = Mth.m_14179_((float)delta, (float)lastPoint.x(), (float)point.x());
                float pz = Mth.m_14179_((float)delta, (float)lastPoint.z(), (float)point.z());
                end.set(px, py, pz);
                this.fillLine(start, end, world, leaf, leafStart, i / 2 - 1);
                float ax = Math.abs(px);
                float az = Math.abs(pz);
                if (ax > az) {
                    start.set(start.x(), start.y(), start.z() + az > 0.0f ? 1.0f : -1.0f);
                    end.set(end.x(), end.y(), end.z() + az > 0.0f ? 1.0f : -1.0f);
                } else {
                    start.set(start.x() + ax > 0.0f ? 1.0f : -1.0f, start.y(), start.z());
                    end.set(end.x() + ax > 0.0f ? 1.0f : -1.0f, end.y(), end.z());
                }
                this.fillLine(start, end, world, leaf, leafStart, i / 2 - 1);
            }
            lastPoint = point;
        }
        leaf = (BlockState)leaf.m_61124_((Property)HelixTreeLeavesBlock.COLOR, (Comparable)Integer.valueOf(7));
        if (world.m_8055_(leafStart = leafStart.m_7918_(0, (int)lastPoint.y(), 0)).m_60795_()) {
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)leafStart, (BlockState)leaf);
            leafStart = leafStart.m_7494_();
            if (world.m_8055_(leafStart).m_60795_()) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)leafStart, (BlockState)leaf);
                leafStart = leafStart.m_7494_();
                if (world.m_8055_(leafStart).m_60795_()) {
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)leafStart, (BlockState)leaf);
                }
            }
        }
        return true;
    }

    private void fillLine(Vector3f start, Vector3f end, WorldGenLevel world, BlockState state, BlockPos pos, int offset) {
        float dx = end.x() - start.x();
        float dy = end.y() - start.y();
        float dz = end.z() - start.z();
        float max = MHelper.max((float)Math.abs(dx), (float)Math.abs(dy), (float)Math.abs(dz));
        int count = MHelper.floor((double)(max + 1.0f));
        dx /= max;
        dy /= max;
        dz /= max;
        float x = start.x();
        float y = start.y();
        float z = start.z();
        BlockPos.MutableBlockPos bPos = new BlockPos.MutableBlockPos();
        for (int i = 0; i < count; ++i) {
            bPos.m_122169_((double)(x + (float)pos.m_123341_()), (double)(y + (float)pos.m_123342_()), (double)(z + (float)pos.m_123343_()));
            int color = MHelper.floor((double)((float)i / (float)count * 7.0f + 0.5f)) + offset;
            color = Mth.m_14045_((int)color, (int)0, (int)7);
            if (world.m_8055_((BlockPos)bPos).m_247087_()) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)bPos, (BlockState)((BlockState)state.m_61124_((Property)HelixTreeLeavesBlock.COLOR, (Comparable)Integer.valueOf(color))));
            }
            x += dx;
            y += dy;
            z += dz;
        }
        bPos.m_122169_((double)(end.x() + (float)pos.m_123341_()), (double)(end.y() + (float)pos.m_123342_()), (double)(end.z() + (float)pos.m_123343_()));
        if (world.m_8055_((BlockPos)bPos).m_247087_()) {
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)bPos, (BlockState)((BlockState)state.m_61124_((Property)HelixTreeLeavesBlock.COLOR, (Comparable)Integer.valueOf(7))));
        }
    }
}

