/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features.trees;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.bclib.sdf.PosInfo;
import org.betterx.bclib.sdf.SDF;
import org.betterx.bclib.sdf.operator.SDFDisplacement;
import org.betterx.bclib.sdf.operator.SDFScale;
import org.betterx.bclib.sdf.operator.SDFScale3D;
import org.betterx.bclib.sdf.operator.SDFSubtraction;
import org.betterx.bclib.sdf.operator.SDFTranslate;
import org.betterx.bclib.sdf.operator.SDFUnary;
import org.betterx.bclib.sdf.primitive.SDFPrimitive;
import org.betterx.bclib.sdf.primitive.SDFSphere;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.bclib.util.SplineHelper;
import org.betterx.betterend.noise.OpenSimplexNoise;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.worlds.together.tag.v3.CommonBlockTags;
import org.joml.Vector3f;

public class DragonTreeFeature
extends DefaultFeature {
    private static final Function<BlockState, Boolean> REPLACE = state -> {
        if (state.m_60734_() == EndBlocks.DRAGON_TREE_LEAVES) {
            return true;
        }
        return BlocksHelper.replaceableOrPlant((BlockState)state);
    };
    private static final Function<BlockState, Boolean> IGNORE = EndBlocks.DRAGON_TREE::isTreeLog;
    private static final Function<PosInfo, BlockState> POST = info -> {
        if (EndBlocks.DRAGON_TREE.isTreeLog(info.getStateUp()) && EndBlocks.DRAGON_TREE.isTreeLog(info.getStateDown())) {
            return EndBlocks.DRAGON_TREE.getLog().m_49966_();
        }
        return info.getState();
    };
    private static final List<Vector3f> BRANCH = Lists.newArrayList((Object[])new Vector3f[]{new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.1f, 0.3f, 0.0f), new Vector3f(0.4f, 0.6f, 0.0f), new Vector3f(0.8f, 0.8f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f)});
    private static final List<Vector3f> SIDE1 = Lists.newArrayList((Object[])new Vector3f[]{new Vector3f(0.4f, 0.6f, 0.0f), new Vector3f(0.8f, 0.8f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f)});
    private static final List<Vector3f> SIDE2 = SplineHelper.copySpline(SIDE1);
    private static final List<Vector3f> ROOT;

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> featureConfig) {
        RandomSource random = featureConfig.m_225041_();
        BlockPos pos = featureConfig.m_159777_();
        WorldGenLevel world = featureConfig.m_159774_();
        if (!world.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_13077_)) {
            return false;
        }
        float size = MHelper.randRange((int)10, (int)25, (RandomSource)random);
        List spline = SplineHelper.makeSpline((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)size, (float)0.0f, (int)6);
        SplineHelper.offsetParts((List)spline, (RandomSource)random, (float)1.0f, (float)0.0f, (float)1.0f);
        if (!SplineHelper.canGenerate((List)spline, (BlockPos)pos, (WorldGenLevel)world, REPLACE)) {
            return false;
        }
        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (BlockState)AIR);
        Vector3f last = SplineHelper.getPos((List)spline, (float)3.5f);
        OpenSimplexNoise noise = new OpenSimplexNoise(random.m_188505_());
        float radius = size * MHelper.randRange((float)0.5f, (float)0.7f, (RandomSource)random);
        this.makeCap(world, pos.m_7918_((int)last.x(), (int)last.y(), (int)last.z()), radius, random, noise);
        last = (Vector3f)spline.get(0);
        this.makeRoots(world, pos.m_7918_((int)last.x(), (int)last.y(), (int)last.z()), radius, random);
        radius = MHelper.randRange((float)1.2f, (float)2.3f, (RandomSource)random);
        SDF function = SplineHelper.buildSDF((List)spline, (float)radius, (float)1.2f, bpos -> EndBlocks.DRAGON_TREE.getBark().m_49966_());
        function.setReplaceFunction(REPLACE);
        function.addPostProcess(POST);
        function.fillRecursiveIgnore((ServerLevelAccessor)world, pos, IGNORE);
        return true;
    }

    private void makeCap(WorldGenLevel world, BlockPos pos, float radius, RandomSource random, OpenSimplexNoise noise) {
        int count = (int)radius;
        int offset = (int)(BRANCH.get(BRANCH.size() - 1).y() * radius);
        for (int i = 0; i < count; ++i) {
            float angle = (float)i / (float)count * ((float)Math.PI * 2);
            float scale = radius * MHelper.randRange((float)0.85f, (float)1.15f, (RandomSource)random);
            List branch = SplineHelper.copySpline(BRANCH);
            SplineHelper.rotateSpline((List)branch, (float)angle);
            SplineHelper.scale((List)branch, (float)scale);
            SplineHelper.fillSpline((List)branch, (WorldGenLevel)world, (BlockState)EndBlocks.DRAGON_TREE.getBark().m_49966_(), (BlockPos)pos, REPLACE);
            branch = SplineHelper.copySpline(SIDE1);
            SplineHelper.rotateSpline((List)branch, (float)angle);
            SplineHelper.scale((List)branch, (float)scale);
            SplineHelper.fillSpline((List)branch, (WorldGenLevel)world, (BlockState)EndBlocks.DRAGON_TREE.getBark().m_49966_(), (BlockPos)pos, REPLACE);
            branch = SplineHelper.copySpline(SIDE2);
            SplineHelper.rotateSpline((List)branch, (float)angle);
            SplineHelper.scale((List)branch, (float)scale);
            SplineHelper.fillSpline((List)branch, (WorldGenLevel)world, (BlockState)EndBlocks.DRAGON_TREE.getBark().m_49966_(), (BlockPos)pos, REPLACE);
        }
        this.leavesBall(world, pos.m_6630_(offset), radius * 1.15f + 2.0f, random, noise);
    }

    private void makeRoots(WorldGenLevel world, BlockPos pos, float radius, RandomSource random) {
        int count = (int)(radius * 1.5f);
        for (int i = 0; i < count; ++i) {
            float angle = (float)i / (float)count * ((float)Math.PI * 2);
            float scale = radius * MHelper.randRange((float)0.85f, (float)1.15f, (RandomSource)random);
            List branch = SplineHelper.copySpline(ROOT);
            SplineHelper.rotateSpline((List)branch, (float)angle);
            SplineHelper.scale((List)branch, (float)scale);
            Vector3f last = (Vector3f)branch.get(branch.size() - 1);
            if (!world.m_8055_(pos.m_7918_((int)last.x(), (int)last.y(), (int)last.z())).m_204336_(CommonBlockTags.GEN_END_STONES)) continue;
            SplineHelper.fillSpline((List)branch, (WorldGenLevel)world, (BlockState)EndBlocks.DRAGON_TREE.getBark().m_49966_(), (BlockPos)pos, REPLACE);
        }
    }

    private void leavesBall(WorldGenLevel world, BlockPos pos, float radius, RandomSource random, OpenSimplexNoise noise) {
        SDFPrimitive sphere = new SDFSphere().setRadius(radius).setBlock((BlockState)EndBlocks.DRAGON_TREE_LEAVES.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(6)));
        SDFUnary sub = new SDFScale().setScale(5.0f).setSource((SDF)sphere);
        sub = new SDFTranslate().setTranslate(0.0f, -radius * 5.0f, 0.0f).setSource((SDF)sub);
        sphere = new SDFSubtraction().setSourceA((SDF)sphere).setSourceB((SDF)sub);
        sphere = new SDFScale3D().setScale(1.0f, 0.5f, 1.0f).setSource((SDF)sphere);
        sphere = new SDFDisplacement().setFunction(vec -> Float.valueOf((float)noise.eval((double)vec.x() * 0.2, (double)vec.y() * 0.2, (double)vec.z() * 0.2) * 1.5f)).setSource((SDF)sphere);
        sphere = new SDFDisplacement().setFunction(vec -> Float.valueOf(random.m_188501_() * 3.0f - 1.5f)).setSource((SDF)sphere);
        BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
        sphere.addPostProcess(info -> {
            if (random.m_188503_(5) == 0) {
                for (Direction dir : Direction.values()) {
                    BlockState state = info.getState(dir, 2);
                    if (!state.m_60795_()) continue;
                    return info.getState();
                }
                info.setState(EndBlocks.DRAGON_TREE.getBark().m_49966_());
                for (int x = -6; x < 7; ++x) {
                    int ax = Math.abs(x);
                    mut.m_142451_(x + info.getPos().m_123341_());
                    for (int z = -6; z < 7; ++z) {
                        int az = Math.abs(z);
                        mut.m_142443_(z + info.getPos().m_123343_());
                        for (int y = -6; y < 7; ++y) {
                            int distance;
                            int ay = Math.abs(y);
                            int d = ax + ay + az;
                            if (d >= 7) continue;
                            mut.m_142448_(y + info.getPos().m_123342_());
                            BlockState state = info.getState((BlockPos)mut);
                            if (!(state.m_60734_() instanceof LeavesBlock) || d >= (distance = ((Integer)state.m_61143_((Property)LeavesBlock.f_54418_)).intValue())) continue;
                            info.setState((BlockPos)mut, (BlockState)state.m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(d)));
                        }
                    }
                }
            }
            return info.getState();
        });
        sphere.fillRecursiveIgnore((ServerLevelAccessor)world, pos, IGNORE);
        if (radius > 5.0f) {
            int count = (int)(radius * 2.5f);
            for (int i = 0; i < count; ++i) {
                BlockPos p = pos.m_7918_((int)(random.m_188583_() * 1.0), (int)(random.m_188583_() * 1.0), (int)(random.m_188583_() * 1.0));
                boolean place = true;
                for (Direction d : Direction.values()) {
                    BlockState state = world.m_8055_(p.m_121945_(d));
                    if (EndBlocks.DRAGON_TREE.isTreeLog(state) || state.m_60713_(EndBlocks.DRAGON_TREE_LEAVES)) continue;
                    place = false;
                    break;
                }
                if (!place) continue;
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)p, (Block)EndBlocks.DRAGON_TREE.getBark());
            }
        }
        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (Block)EndBlocks.DRAGON_TREE.getBark());
    }

    static {
        Vector3f offset1 = new Vector3f(-0.4f, -0.6f, 0.0f);
        Vector3f offset2 = new Vector3f(0.4f, 0.6f, 0.0f);
        SplineHelper.offset(SIDE1, (Vector3f)offset1);
        SplineHelper.offset(SIDE2, (Vector3f)offset1);
        SplineHelper.rotateSpline(SIDE1, (float)0.5f);
        SplineHelper.rotateSpline(SIDE2, (float)-0.5f);
        SplineHelper.offset(SIDE1, (Vector3f)offset2);
        SplineHelper.offset(SIDE2, (Vector3f)offset2);
        ROOT = Lists.newArrayList((Object[])new Vector3f[]{new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.1f, 0.7f, 0.0f), new Vector3f(0.3f, 0.3f, 0.0f), new Vector3f(0.7f, 0.05f, 0.0f), new Vector3f(0.8f, -0.2f, 0.0f)});
        SplineHelper.offset(ROOT, (Vector3f)new Vector3f(0.0f, -0.45f, 0.0f));
    }
}

