/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features.terrain.caves;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.noise.OpenSimplexNoise;
import org.betterx.betterend.world.features.terrain.caves.EndCaveFeature;
import org.betterx.worlds.together.tag.v3.CommonBlockTags;

public class RoundCaveFeature
extends EndCaveFeature {
    @Override
    protected Set<BlockPos> generate(WorldGenLevel world, BlockPos center, int radius, RandomSource random) {
        OpenSimplexNoise noise = new OpenSimplexNoise(MHelper.getSeed((int)534, (int)center.m_123341_(), (int)center.m_123343_()));
        int x1 = center.m_123341_() - radius - 5;
        int z1 = center.m_123343_() - radius - 5;
        int x2 = center.m_123341_() + radius + 5;
        int z2 = center.m_123343_() + radius + 5;
        int y1 = MHelper.floor((double)((double)center.m_123342_() - (double)(radius + 5) / 1.6));
        int y2 = MHelper.floor((double)((double)center.m_123342_() + (double)(radius + 5) / 1.6));
        double hr = (double)radius * 0.75;
        double nr = (double)radius * 0.25;
        int dx = x2 - x1 + 1;
        int dz = z2 - z1 + 1;
        int count = dx * dz;
        Set blocks = Sets.newConcurrentHashSet();
        IntStream.range(0, count).parallel().forEach(index -> {
            BlockPos.MutableBlockPos bpos = new BlockPos.MutableBlockPos();
            int x = index % dx + x1;
            int z = index / dx + z1;
            bpos.m_142451_(x);
            bpos.m_142443_(z);
            int xsq = MHelper.sqr((int)(x - center.m_123341_()));
            int zsq = MHelper.sqr((int)(z - center.m_123343_()));
            int dxz = xsq + zsq;
            for (int y = y1; y <= y2; ++y) {
                double r;
                int ysq = (int)MHelper.sqr((double)((double)(y - center.m_123342_()) * 1.6));
                double dist = dxz + ysq;
                if (!(dist < (r = noise.eval((double)x * 0.1, (double)y * 0.1, (double)z * 0.1) * nr + hr) * r)) continue;
                bpos.m_142448_(y);
                BlockState state = world.m_8055_((BlockPos)bpos);
                if (!this.isReplaceable(state) || this.isWaterNear(world, (BlockPos)bpos)) continue;
                blocks.add(bpos.m_7949_());
                while (state.m_204336_(BlockTags.f_13035_)) {
                    bpos.m_142448_(bpos.m_123342_() + 1);
                    state = world.m_8055_((BlockPos)bpos);
                }
                bpos.m_142448_(y - 1);
                while (state.m_204336_(BlockTags.f_13035_)) {
                    bpos.m_142448_(bpos.m_123342_() - 1);
                    state = world.m_8055_((BlockPos)bpos);
                }
            }
        });
        blocks.forEach(bpos -> BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)bpos, (BlockState)CAVE_AIR));
        return blocks;
    }

    private boolean isReplaceable(BlockState state) {
        return state.m_204336_(CommonBlockTags.GEN_END_STONES) || BlocksHelper.replaceableOrPlant((BlockState)state) != false || state.m_204336_(BlockTags.f_13035_);
    }
}

