/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features.terrain;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiome;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeRegistry;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.bclib.sdf.SDF;
import org.betterx.bclib.sdf.operator.SDFDisplacement;
import org.betterx.bclib.sdf.operator.SDFSmoothUnion;
import org.betterx.bclib.sdf.operator.SDFTranslate;
import org.betterx.bclib.sdf.operator.SDFUnary;
import org.betterx.bclib.sdf.primitive.SDFPrimitive;
import org.betterx.bclib.sdf.primitive.SDFSphere;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.noise.OpenSimplexNoise;
import org.betterx.betterend.registry.EndBiomes;
import org.betterx.betterend.registry.EndFeatures;
import org.betterx.betterend.world.biome.EndBiome;
import org.betterx.betterend.world.features.bushes.TenaneaBushFeature;
import org.betterx.worlds.together.tag.v3.CommonBlockTags;

public class SpireFeature
extends DefaultFeature {
    protected static final Function<BlockState, Boolean> REPLACE = state -> {
        if (state.m_204336_(CommonBlockTags.END_STONES)) {
            return true;
        }
        if (state.m_60734_() instanceof LeavesBlock || state.m_204336_(BlockTags.f_13035_)) {
            return true;
        }
        return BlocksHelper.replaceableOrPlant((BlockState)state);
    };

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> featureConfig) {
        RandomSource random = featureConfig.m_225041_();
        BlockPos pos = featureConfig.m_159777_();
        WorldGenLevel world = featureConfig.m_159774_();
        ChunkGenerator chunkGenerator = featureConfig.m_159775_();
        if ((pos = SpireFeature.getPosOnSurfaceWG((WorldGenLevel)world, (BlockPos)pos)).m_123342_() < 10 || !world.m_8055_(pos.m_6625_(3)).m_204336_(CommonBlockTags.GEN_END_STONES) || !world.m_8055_(pos.m_6625_(6)).m_204336_(CommonBlockTags.GEN_END_STONES)) {
            return false;
        }
        SDFPrimitive sdf = new SDFSphere().setRadius((float)MHelper.randRange((int)2, (int)3, (RandomSource)random)).setBlock(Blocks.f_50259_);
        int count = MHelper.randRange((int)3, (int)7, (RandomSource)random);
        for (int i = 0; i < count; ++i) {
            float rMin = (float)i * 1.3f + 2.5f;
            sdf = this.addSegment((SDF)sdf, MHelper.randRange((float)rMin, (float)(rMin + 1.5f), (RandomSource)random), random);
        }
        OpenSimplexNoise noise = new OpenSimplexNoise(random.m_188505_());
        sdf = new SDFDisplacement().setFunction(vec -> Float.valueOf((float)(Math.abs(noise.eval((double)vec.x() * 0.1, (double)vec.y() * 0.1, (double)vec.z() * 0.1)) * 3.0 + Math.abs(noise.eval((double)vec.x() * 0.3, (double)vec.y() * 0.3 + 100.0, (double)vec.z() * 0.3)) * (double)1.3f))).setSource((SDF)sdf);
        BlockPos center = pos;
        ArrayList support = Lists.newArrayList();
        sdf.setReplaceFunction(REPLACE).addPostProcess(info -> {
            if (info.getStateUp().m_60795_()) {
                if (random.m_188503_(16) == 0) {
                    support.add(info.getPos().m_7494_());
                }
                return EndBiome.findTopMaterial(world, info.getPos());
            }
            if (info.getState(Direction.UP, 3).m_60795_()) {
                return EndBiome.findUnderMaterial(world, info.getPos());
            }
            return info.getState();
        }).fillRecursive((ServerLevelAccessor)world, center);
        support.forEach(bpos -> {
            BCLBiome biome = BiomeAPI.getBiome((Holder)world.m_204166_(bpos));
            if (!BCLBiomeRegistry.isEmptyBiome((BCLBiome)biome) && biome.equals(EndBiomes.BLOSSOMING_SPIRES)) {
                ((TenaneaBushFeature)EndFeatures.TENANEA_BUSH.getFeature()).m_142674_((FeaturePlaceContext<NoneFeatureConfiguration>)new FeaturePlaceContext(Optional.empty(), world, chunkGenerator, random, bpos, null));
            }
        });
        return true;
    }

    protected SDF addSegment(SDF sdf, float radius, RandomSource random) {
        SDFPrimitive sphere = new SDFSphere().setRadius(radius).setBlock(Blocks.f_50259_);
        SDFUnary offseted = new SDFTranslate().setTranslate(0.0f, radius + random.m_188501_() * 0.25f * radius, 0.0f).setSource(sdf);
        return new SDFSmoothUnion().setRadius(radius * 0.5f).setSourceA((SDF)sphere).setSourceB((SDF)offseted);
    }
}

