/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features.bushes;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.bclib.blocks.BlockProperties;
import org.betterx.bclib.sdf.SDF;
import org.betterx.bclib.sdf.operator.SDFDisplacement;
import org.betterx.bclib.sdf.operator.SDFScale3D;
import org.betterx.bclib.sdf.operator.SDFSubtraction;
import org.betterx.bclib.sdf.operator.SDFTranslate;
import org.betterx.bclib.sdf.primitive.SDFPrimitive;
import org.betterx.bclib.sdf.primitive.SDFSphere;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.blocks.basis.FurBlock;
import org.betterx.betterend.noise.OpenSimplexNoise;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.worlds.together.tag.v3.CommonBlockTags;

public class TenaneaBushFeature
extends DefaultFeature {
    private static final Function<BlockState, Boolean> REPLACE;
    private static final Direction[] DIRECTIONS;

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> featureConfig) {
        RandomSource random = featureConfig.m_225041_();
        BlockPos pos = featureConfig.m_159777_();
        WorldGenLevel world = featureConfig.m_159774_();
        if (!world.m_8055_(pos.m_7495_()).m_204336_(CommonBlockTags.END_STONES)) {
            return false;
        }
        float radius = MHelper.randRange((float)1.8f, (float)3.5f, (RandomSource)random);
        OpenSimplexNoise noise = new OpenSimplexNoise(random.m_188502_());
        BlockState leaves = EndBlocks.TENANEA_LEAVES.m_49966_();
        SDFPrimitive sphere = new SDFSphere().setRadius(radius).setBlock(leaves);
        sphere = new SDFScale3D().setScale(1.0f, 0.75f, 1.0f).setSource((SDF)sphere);
        sphere = new SDFDisplacement().setFunction(vec -> Float.valueOf((float)noise.eval((double)vec.x() * 0.2, (double)vec.y() * 0.2, (double)vec.z() * 0.2) * 3.0f)).setSource((SDF)sphere);
        sphere = new SDFDisplacement().setFunction(vec -> Float.valueOf(MHelper.randRange((float)-2.0f, (float)2.0f, (RandomSource)random))).setSource((SDF)sphere);
        sphere = new SDFSubtraction().setSourceA((SDF)sphere).setSourceB((SDF)new SDFTranslate().setTranslate(0.0f, -radius, 0.0f).setSource((SDF)sphere));
        sphere.setReplaceFunction(REPLACE);
        ArrayList support = Lists.newArrayList();
        sphere.addPostProcess(info -> {
            if (info.getState().m_60734_() instanceof LeavesBlock) {
                int distance = info.getPos().m_123333_((Vec3i)pos);
                if (distance < 7) {
                    if (random.m_188503_(4) == 0 && info.getStateDown().m_60795_()) {
                        BlockPos d = info.getPos().m_7495_();
                        support.add(d);
                    }
                    MHelper.shuffle((Object[])DIRECTIONS, (RandomSource)random);
                    for (Direction d : DIRECTIONS) {
                        if (!info.getState(d).m_60795_()) continue;
                        info.setBlockPos(info.getPos().m_121945_(d), (BlockState)EndBlocks.TENANEA_OUTER_LEAVES.m_49966_().m_61124_((Property)FurBlock.FACING, (Comparable)d));
                    }
                    return (BlockState)info.getState().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(distance));
                }
                return AIR;
            }
            return info.getState();
        });
        sphere.fillRecursive((ServerLevelAccessor)world, pos);
        BlockState stem = EndBlocks.TENANEA.getBark().m_49966_();
        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (BlockState)stem);
        for (Direction d : Direction.values()) {
            BlockPos p = pos.m_121945_(d);
            if (!world.m_46859_(p)) continue;
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)p, (BlockState)((BlockState)leaves.m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1))));
        }
        BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
        BlockState top = (BlockState)EndBlocks.TENANEA_FLOWERS.m_49966_().m_61124_((Property)BlockProperties.TRIPLE_SHAPE, (Comparable)BlockProperties.TripleShape.TOP);
        BlockState middle = (BlockState)EndBlocks.TENANEA_FLOWERS.m_49966_().m_61124_((Property)BlockProperties.TRIPLE_SHAPE, (Comparable)BlockProperties.TripleShape.MIDDLE);
        BlockState bottom = (BlockState)EndBlocks.TENANEA_FLOWERS.m_49966_().m_61124_((Property)BlockProperties.TRIPLE_SHAPE, (Comparable)BlockProperties.TripleShape.BOTTOM);
        support.forEach(bpos -> {
            BlockState state = world.m_8055_(bpos);
            if (state.m_60795_() || state.m_60713_(EndBlocks.TENANEA_OUTER_LEAVES)) {
                int count = MHelper.randRange((int)3, (int)8, (RandomSource)random);
                mut.m_122190_((Vec3i)bpos);
                if (world.m_8055_(mut.m_7494_()).m_60713_(EndBlocks.TENANEA_LEAVES)) {
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (BlockState)top);
                    for (int i = 1; i < count; ++i) {
                        mut.m_142448_(mut.m_123342_() - 1);
                        if (!world.m_46859_(mut.m_7495_())) break;
                        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (BlockState)middle);
                    }
                    BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)mut, (BlockState)bottom);
                }
            }
        });
        return true;
    }

    static {
        DIRECTIONS = Direction.values();
        REPLACE = BlocksHelper::replaceableOrPlant;
    }
}

