/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features.bushes;

import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.bclib.sdf.SDF;
import org.betterx.bclib.sdf.operator.SDFDisplacement;
import org.betterx.bclib.sdf.operator.SDFScale3D;
import org.betterx.bclib.sdf.operator.SDFSubtraction;
import org.betterx.bclib.sdf.operator.SDFTranslate;
import org.betterx.bclib.sdf.primitive.SDFPrimitive;
import org.betterx.bclib.sdf.primitive.SDFSphere;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.noise.OpenSimplexNoise;
import org.betterx.betterend.world.features.bushes.BushWithOuterFeatureConfig;
import org.betterx.worlds.together.tag.v3.CommonBlockTags;

public class BushWithOuterFeature
extends Feature<BushWithOuterFeatureConfig> {
    private static final Direction[] DIRECTIONS = Direction.values();
    private static final Function<BlockState, Boolean> REPLACE = BlocksHelper::replaceableOrPlant;

    public BushWithOuterFeature() {
        super(BushWithOuterFeatureConfig.CODEC);
    }

    public boolean m_142674_(FeaturePlaceContext<BushWithOuterFeatureConfig> featureConfig) {
        RandomSource random = featureConfig.m_225041_();
        BlockPos pos = featureConfig.m_159777_();
        BushWithOuterFeatureConfig cfg = (BushWithOuterFeatureConfig)featureConfig.m_159778_();
        BlockState outer_leaves = cfg.outer_leaves.m_213972_(random, pos);
        Block leaves = cfg.leaves.m_213972_(random, pos).m_60734_();
        BlockState stem = cfg.stem.m_213972_(random, pos);
        WorldGenLevel world = featureConfig.m_159774_();
        if (!world.m_8055_(pos.m_7495_()).m_204336_(CommonBlockTags.END_STONES) && !world.m_8055_(pos.m_7494_()).m_204336_(CommonBlockTags.END_STONES)) {
            return false;
        }
        float radius = MHelper.randRange((float)1.8f, (float)3.5f, (RandomSource)random);
        OpenSimplexNoise noise = new OpenSimplexNoise(random.m_188502_());
        SDFPrimitive sphere = new SDFSphere().setRadius(radius).setBlock(leaves);
        sphere = new SDFScale3D().setScale(1.0f, 0.5f, 1.0f).setSource((SDF)sphere);
        sphere = new SDFDisplacement().setFunction(vec -> Float.valueOf((float)noise.eval((double)vec.x() * 0.2, (double)vec.y() * 0.2, (double)vec.z() * 0.2) * 3.0f)).setSource((SDF)sphere);
        sphere = new SDFDisplacement().setFunction(vec -> Float.valueOf(MHelper.randRange((float)-2.0f, (float)2.0f, (RandomSource)random))).setSource((SDF)sphere);
        sphere = new SDFSubtraction().setSourceA((SDF)sphere).setSourceB((SDF)new SDFTranslate().setTranslate(0.0f, -radius, 0.0f).setSource((SDF)sphere));
        sphere.setReplaceFunction(REPLACE);
        sphere.addPostProcess(info -> {
            if (info.getState().m_60734_() instanceof LeavesBlock) {
                int distance = info.getPos().m_123333_((Vec3i)pos);
                if (distance < 7) {
                    return (BlockState)info.getState().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(distance));
                }
                return DefaultFeature.AIR;
            }
            return info.getState();
        }).addPostProcess(info -> {
            if (info.getState().m_60734_() instanceof LeavesBlock) {
                MHelper.shuffle((Object[])DIRECTIONS, (RandomSource)random);
                for (Direction dir : DIRECTIONS) {
                    if (!info.getState(dir).m_60795_()) continue;
                    info.setBlockPos(info.getPos().m_121945_(dir), (BlockState)outer_leaves.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)dir));
                }
            }
            return info.getState();
        });
        sphere.fillRecursive((ServerLevelAccessor)world, pos);
        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (BlockState)stem);
        for (Direction d : Direction.values()) {
            BlockPos p = pos.m_121945_(d);
            if (!world.m_46859_(p)) continue;
            if (leaves instanceof LeavesBlock) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)p, (BlockState)((BlockState)leaves.m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1))));
                continue;
            }
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)p, (BlockState)leaves.m_49966_());
        }
        return true;
    }
}

