/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.world.features.ScatterFeature;
import org.betterx.betterend.world.features.ScatterFeatureConfig;

public abstract class SkyScatterFeature
extends ScatterFeature<ScatterFeatureConfig> {
    public SkyScatterFeature() {
        super(ScatterFeatureConfig.CODEC);
    }

    @Override
    protected int getChance() {
        return 10;
    }

    @Override
    public boolean canGenerate(ScatterFeatureConfig cfg, WorldGenLevel world, RandomSource random, BlockPos center, BlockPos blockPos, float radius) {
        if (!world.m_46859_(blockPos)) {
            return false;
        }
        for (Direction dir : BlocksHelper.HORIZONTAL) {
            if (world.m_46859_(blockPos.m_121945_(dir))) continue;
            return false;
        }
        int maxD = this.getYOffset() + 2;
        int maxV = this.getYOffset() - 2;
        return BlocksHelper.upRay((LevelAccessor)world, (BlockPos)blockPos, (int)maxD) > maxV && BlocksHelper.downRay((LevelAccessor)world, (BlockPos)blockPos, (int)maxD) > maxV;
    }

    @Override
    protected boolean canSpawn(ScatterFeatureConfig cfg, WorldGenLevel world, BlockPos pos) {
        return true;
    }

    @Override
    protected BlockPos getCenterGround(ScatterFeatureConfig cfg, WorldGenLevel world, BlockPos pos) {
        return new BlockPos(pos.m_123341_(), MHelper.randRange((int)32, (int)192, (RandomSource)world.m_213780_()), pos.m_123343_());
    }

    @Override
    protected boolean getGroundPlant(ScatterFeatureConfig cfg, WorldGenLevel world, BlockPos.MutableBlockPos pos) {
        pos.m_142448_(pos.m_123342_() + MHelper.randRange((int)(-this.getYOffset()), (int)this.getYOffset(), (RandomSource)world.m_213780_()));
        return true;
    }
}

