/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.util.GlobalState;
import org.betterx.betterend.world.features.ScatterFeatureConfig;
import org.betterx.worlds.together.tag.v3.CommonBlockTags;

public abstract class ScatterFeature<FC extends ScatterFeatureConfig>
extends Feature<FC> {
    public ScatterFeature(Codec<FC> codec) {
        super(codec);
    }

    public abstract boolean canGenerate(FC var1, WorldGenLevel var2, RandomSource var3, BlockPos var4, BlockPos var5, float var6);

    public abstract void generate(FC var1, WorldGenLevel var2, RandomSource var3, BlockPos var4);

    protected BlockPos getCenterGround(FC cfg, WorldGenLevel world, BlockPos pos) {
        return DefaultFeature.getPosOnSurfaceWG((WorldGenLevel)world, (BlockPos)pos);
    }

    protected boolean canSpawn(FC cfg, WorldGenLevel world, BlockPos pos) {
        if (pos.m_123342_() < 5) {
            return false;
        }
        return world.m_8055_(pos.m_7495_()).m_204336_(CommonBlockTags.END_STONES);
    }

    protected boolean getGroundPlant(FC cfg, WorldGenLevel world, BlockPos.MutableBlockPos pos) {
        int down = BlocksHelper.downRay((LevelAccessor)world, (BlockPos)pos, (int)16);
        if (down > Math.abs(this.getYOffset() * 2)) {
            return false;
        }
        pos.m_142448_(pos.m_123342_() - down);
        return true;
    }

    protected int getYOffset() {
        return 5;
    }

    protected int getChance() {
        return 1;
    }

    public boolean m_142674_(FeaturePlaceContext<FC> featureConfig) {
        ScatterFeatureConfig cfg = (ScatterFeatureConfig)featureConfig.m_159778_();
        BlockPos.MutableBlockPos POS = GlobalState.stateForThread().POS;
        RandomSource random = featureConfig.m_225041_();
        BlockPos center = featureConfig.m_159777_();
        WorldGenLevel world = featureConfig.m_159774_();
        if (!this.canSpawn(cfg, world, center = this.getCenterGround(cfg, world, center))) {
            return false;
        }
        float r = MHelper.randRange((float)((float)cfg.radius * 0.5f), (float)cfg.radius, (RandomSource)random);
        int count = MHelper.floor((double)(r * r * MHelper.randRange((float)1.5f, (float)3.0f, (RandomSource)random)));
        for (int i = 0; i < count; ++i) {
            float pr = r * (float)Math.sqrt(random.m_188501_());
            float theta = random.m_188501_() * ((float)Math.PI * 2);
            float x = pr * (float)Math.cos(theta);
            float z = pr * (float)Math.sin(theta);
            POS.m_122169_((double)((float)center.m_123341_() + x), (double)(center.m_123342_() + this.getYOffset()), (double)((float)center.m_123343_() + z));
            if (!this.getGroundPlant(cfg, world, POS) || !this.canGenerate(cfg, world, random, center, (BlockPos)POS, r) || this.getChance() >= 2 && random.m_188503_(this.getChance()) != 0) continue;
            this.generate(cfg, world, random, (BlockPos)POS);
        }
        return true;
    }
}

