/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.bclib.blocks.BlockProperties;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.betterend.blocks.EndLotusLeafBlock;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.world.features.ScatterFeature;
import org.betterx.betterend.world.features.ScatterFeatureConfig;

public class EndLotusLeafFeature
extends ScatterFeature<ScatterFeatureConfig> {
    public EndLotusLeafFeature() {
        super(ScatterFeatureConfig.CODEC);
    }

    @Override
    public void generate(ScatterFeatureConfig cfg, WorldGenLevel world, RandomSource random, BlockPos blockPos) {
        if (this.canGenerate(world, blockPos)) {
            this.generateLeaf(world, blockPos);
        }
    }

    @Override
    protected int getChance() {
        return 15;
    }

    @Override
    protected BlockPos getCenterGround(ScatterFeatureConfig cfg, WorldGenLevel world, BlockPos pos) {
        return DefaultFeature.getPosOnSurface((WorldGenLevel)world, (BlockPos)pos);
    }

    private void generateLeaf(WorldGenLevel world, BlockPos pos) {
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos();
        BlockState leaf = EndBlocks.END_LOTUS_LEAF.m_49966_();
        BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)pos, (BlockState)((BlockState)leaf.m_61124_(EndLotusLeafBlock.SHAPE, (Comparable)BlockProperties.TripleShape.BOTTOM)));
        for (Direction move : BlocksHelper.HORIZONTAL) {
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)p.m_122190_((Vec3i)pos).m_122173_(move), (BlockState)((BlockState)((BlockState)leaf.m_61124_(EndLotusLeafBlock.HORIZONTAL_FACING, (Comparable)move)).m_61124_(EndLotusLeafBlock.SHAPE, (Comparable)BlockProperties.TripleShape.MIDDLE)));
        }
        for (int i = 0; i < 4; ++i) {
            Direction d1 = BlocksHelper.HORIZONTAL[i];
            Direction d2 = BlocksHelper.HORIZONTAL[i + 1 & 3];
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, (BlockPos)p.m_122190_((Vec3i)pos).m_122173_(d1).m_122173_(d2), (BlockState)((BlockState)((BlockState)leaf.m_61124_(EndLotusLeafBlock.HORIZONTAL_FACING, (Comparable)d1)).m_61124_(EndLotusLeafBlock.SHAPE, (Comparable)BlockProperties.TripleShape.TOP)));
        }
    }

    private boolean canGenerate(WorldGenLevel world, BlockPos pos) {
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos();
        p.m_142448_(pos.m_123342_());
        int count = 0;
        for (int x = -1; x < 2; ++x) {
            p.m_142451_(pos.m_123341_() + x);
            for (int z = -1; z < 2; ++z) {
                p.m_142443_(pos.m_123343_() + z);
                if (!world.m_46859_((BlockPos)p) || !world.m_8055_(p.m_7495_()).m_60713_(Blocks.f_49990_)) continue;
                ++count;
            }
        }
        return count == 9;
    }

    @Override
    public boolean canGenerate(ScatterFeatureConfig cfg, WorldGenLevel world, RandomSource random, BlockPos center, BlockPos blockPos, float radius) {
        return world.m_46859_(blockPos) && world.m_8055_(blockPos.m_7495_()).m_60713_(Blocks.f_49990_);
    }
}

