/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.bclib.sdf.SDF;
import org.betterx.bclib.sdf.operator.SDFDisplacement;
import org.betterx.bclib.sdf.operator.SDFTranslate;
import org.betterx.bclib.sdf.primitive.SDFCappedCone;
import org.betterx.bclib.sdf.primitive.SDFPrimitive;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.betterend.noise.OpenSimplexNoise;
import org.betterx.betterend.world.biome.EndBiome;

public class BiomeIslandFeature
extends DefaultFeature {
    private static final BlockPos.MutableBlockPos CENTER = new BlockPos.MutableBlockPos();
    private static final SDF ISLAND;
    private static OpenSimplexNoise simplexNoise;
    private static BlockState topBlock;
    private static BlockState underBlock;

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> featureConfig) {
        BlockPos pos = featureConfig.m_159777_();
        WorldGenLevel world = featureConfig.m_159774_();
        int dist = BlocksHelper.downRay((LevelAccessor)world, (BlockPos)pos, (int)10) + 1;
        BlockPos surfacePos = new BlockPos(pos.m_123341_(), pos.m_123342_() - dist, pos.m_123343_());
        BlockState topMaterial = EndBiome.findTopMaterial(world, surfacePos);
        if (BlocksHelper.isFluid((BlockState)topMaterial)) {
            topBlock = Blocks.f_49994_.m_49966_();
            underBlock = Blocks.f_50069_.m_49966_();
        } else {
            underBlock = EndBiome.findUnderMaterial(world, surfacePos);
        }
        simplexNoise = new OpenSimplexNoise(world.m_7328_());
        CENTER.m_122190_((Vec3i)pos);
        ISLAND.fillRecursive((ServerLevelAccessor)world, pos.m_7495_());
        return true;
    }

    private static SDF createSDFIsland() {
        SDFPrimitive sdfCone = new SDFCappedCone().setRadius1(0.0f).setRadius2(6.0f).setHeight(4.0f).setBlock(pos -> {
            if (pos.m_123342_() > CENTER.m_123342_()) {
                return AIR;
            }
            if (pos.m_123342_() == CENTER.m_123342_()) {
                return topBlock;
            }
            return underBlock;
        });
        sdfCone = new SDFTranslate().setTranslate(0.0f, -2.0f, 0.0f).setSource((SDF)sdfCone);
        sdfCone = new SDFDisplacement().setFunction(pos -> {
            float deltaX = Math.abs(pos.x());
            float deltaY = Math.abs(pos.y());
            float deltaZ = Math.abs(pos.z());
            if (deltaY < 2.0f && (deltaX < 3.0f || deltaZ < 3.0f)) {
                return Float.valueOf(0.0f);
            }
            return Float.valueOf((float)simplexNoise.eval((float)CENTER.m_123341_() + pos.x(), (float)CENTER.m_123342_() + pos.y(), (float)CENTER.m_123343_() + pos.z()));
        }).setSource((SDF)sdfCone).setReplaceFunction(state -> BlocksHelper.isFluid((BlockState)state) || state.m_247087_());
        return sdfCone;
    }

    static {
        simplexNoise = new OpenSimplexNoise(412L);
        topBlock = Blocks.f_50440_.m_49966_();
        underBlock = Blocks.f_50493_.m_49966_();
        ISLAND = BiomeIslandFeature.createSDFIsland();
    }
}

