/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.biome.cave;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiome;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeBuilder;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeSettings;
import org.betterx.bclib.interfaces.SurfaceMaterialProvider;
import org.betterx.bclib.util.WeightedList;
import org.betterx.betterend.registry.EndFeatures;
import org.betterx.betterend.registry.EndParticles;
import org.betterx.betterend.world.biome.EndBiome;
import org.betterx.betterend.world.biome.cave.EndCaveBiome;

public class EmptyAuroraCaveBiome
extends EndCaveBiome.Config {
    public static final Codec<Biome> CODEC = EndCaveBiome.simpleCaveBiomeCodec(Biome::new);
    public static final KeyDispatchDataCodec<Biome> KEY_CODEC = KeyDispatchDataCodec.m_216236_(CODEC);

    public EmptyAuroraCaveBiome() {
        super("empty_aurora_cave");
    }

    @Override
    protected void addCustomBuildData(BCLBiomeBuilder builder) {
        super.addCustomBuildData(builder);
        builder.fogColor(150, 30, 68).fogDensity(2.0f).plantsColor(108, 25, 46).waterAndFogColor(186, 77, 237).particles((ParticleOptions)EndParticles.GLOWING_SPHERE, 0.001f);
    }

    @Override
    public BCLBiomeBuilder.BiomeSupplier<EndBiome> getSupplier() {
        return Biome::new;
    }

    public static class Biome
    extends EndCaveBiome {
        public Biome(ResourceKey<net.minecraft.world.level.biome.Biome> biomeID, BCLBiomeSettings settings) {
            super(biomeID, settings);
            this.addFloorFeature(EndFeatures.BIG_AURORA_CRYSTAL.configuredFeature, 1.0f);
            this.addCeilFeature(EndFeatures.END_STONE_STALACTITE.configuredFeature, 1.0f);
        }

        @Override
        public KeyDispatchDataCodec<? extends BCLBiome> codec() {
            return KEY_CODEC;
        }

        protected Biome(float terrainHeight, float fogDensity, float genChance, int edgeSize, boolean vertical, Optional<ResourceLocation> edge, ResourceLocation biomeID, Optional<List<Climate.ParameterPoint>> parameterPoints, Optional<ResourceLocation> biomeParent, Optional<String> intendedType, boolean hasCaves, SurfaceMaterialProvider surface, WeightedList<Holder<ConfiguredFeature<?, ?>>> floorFeatures, WeightedList<Holder<ConfiguredFeature<?, ?>>> ceilFeatures) {
            super(terrainHeight, fogDensity, genChance, edgeSize, vertical, edge, biomeID, parameterPoints, biomeParent, intendedType, hasCaves, surface, floorFeatures, ceilFeatures);
        }

        @Override
        public float getFloorDensity() {
            return 0.01f;
        }

        @Override
        public float getCeilDensity() {
            return 0.1f;
        }
    }
}

