/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.registry;

import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.heightproviders.ConstantHeight;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import org.betterx.bclib.api.v2.levelgen.structures.BCLJigsawStructureBuilder;
import org.betterx.bclib.api.v2.levelgen.structures.BCLStructure;
import org.betterx.bclib.api.v2.levelgen.structures.BCLStructureBuilder;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.world.structures.features.EternalPortalStructure;
import org.betterx.betterend.world.structures.features.GiantIceStarStructure;
import org.betterx.betterend.world.structures.features.GiantMossyGlowshroomStructure;
import org.betterx.betterend.world.structures.features.MegaLakeSmallStructure;
import org.betterx.betterend.world.structures.features.MegaLakeStructure;
import org.betterx.betterend.world.structures.features.MountainStructure;
import org.betterx.betterend.world.structures.features.PaintedMountainStructure;
import org.betterx.betterend.world.structures.piece.CavePiece;
import org.betterx.betterend.world.structures.piece.CrystalMountainPiece;
import org.betterx.betterend.world.structures.piece.LakePiece;
import org.betterx.betterend.world.structures.piece.NBTPiece;
import org.betterx.betterend.world.structures.piece.PaintedMountainPiece;
import org.betterx.betterend.world.structures.piece.VoxelPiece;
import org.betterx.betterend.world.structures.village.VillagePools;
import org.betterx.worlds.together.tag.v3.TagManager;

public class EndStructures {
    public static final StructurePieceType VOXEL_PIECE = EndStructures.register("voxel", VoxelPiece::new);
    public static final StructurePieceType MOUNTAIN_PIECE = EndStructures.register("mountain_piece", CrystalMountainPiece::new);
    public static final StructurePieceType CAVE_PIECE = EndStructures.register("cave_piece", CavePiece::new);
    public static final StructurePieceType LAKE_PIECE = EndStructures.register("lake_piece", LakePiece::new);
    public static final StructurePieceType PAINTED_MOUNTAIN_PIECE = EndStructures.register("painted_mountain_piece", PaintedMountainPiece::new);
    public static final StructurePieceType NBT_PIECE = EndStructures.register("nbt_piece", NBTPiece::new);
    public static final BCLStructure<GiantMossyGlowshroomStructure> GIANT_MOSSY_GLOWSHROOM = ((BCLStructureBuilder)((BCLStructureBuilder)BCLStructureBuilder.start((ResourceLocation)BetterEnd.makeID("giant_mossy_glowshroom"), GiantMossyGlowshroomStructure::new).step(GenerationStep.Decoration.SURFACE_STRUCTURES)).randomPlacement(16, 8)).build();
    public static final BCLStructure<MegaLakeStructure> MEGALAKE = ((BCLStructureBuilder)((BCLStructureBuilder)BCLStructureBuilder.start((ResourceLocation)BetterEnd.makeID("megalake"), MegaLakeStructure::new).step(GenerationStep.Decoration.LAKES)).randomPlacement(4, 1)).build();
    public static final BCLStructure<MegaLakeSmallStructure> MEGALAKE_SMALL = ((BCLStructureBuilder)((BCLStructureBuilder)BCLStructureBuilder.start((ResourceLocation)BetterEnd.makeID("megalake_small"), MegaLakeSmallStructure::new).step(GenerationStep.Decoration.LAKES)).randomPlacement(4, 1)).build();
    public static final BCLStructure<MountainStructure> MOUNTAIN = ((BCLStructureBuilder)((BCLStructureBuilder)BCLStructureBuilder.start((ResourceLocation)BetterEnd.makeID("mountain"), MountainStructure::new).step(GenerationStep.Decoration.RAW_GENERATION)).randomPlacement(3, 2)).build();
    public static final BCLStructure<PaintedMountainStructure> PAINTED_MOUNTAIN = ((BCLStructureBuilder)((BCLStructureBuilder)BCLStructureBuilder.start((ResourceLocation)BetterEnd.makeID("painted_mountain"), PaintedMountainStructure::new).step(GenerationStep.Decoration.RAW_GENERATION)).randomPlacement(3, 2)).build();
    public static final BCLStructure<EternalPortalStructure> ETERNAL_PORTAL = ((BCLStructureBuilder)((BCLStructureBuilder)BCLStructureBuilder.start((ResourceLocation)BetterEnd.makeID("eternal_portal"), EternalPortalStructure::new).step(GenerationStep.Decoration.RAW_GENERATION)).randomPlacement(40, 12)).build();
    public static final BCLStructure<GiantIceStarStructure> GIANT_ICE_STAR = ((BCLStructureBuilder)((BCLStructureBuilder)BCLStructureBuilder.start((ResourceLocation)BetterEnd.makeID("giant_ice_star"), GiantIceStarStructure::new).step(GenerationStep.Decoration.SURFACE_STRUCTURES)).randomPlacement(16, 8)).build();
    public static final BCLStructure<JigsawStructure> END_VILLAGE = ((BCLJigsawStructureBuilder)((BCLJigsawStructureBuilder)((BCLJigsawStructureBuilder)BCLStructureBuilder.jigsaw((ResourceLocation)BetterEnd.makeID("end_village")).startPool(VillagePools.START).adjustment(TerrainAdjustment.BEARD_THIN)).projectStartToHeightmap(Heightmap.Types.WORLD_SURFACE_WG).maxDepth(6).startHeight((HeightProvider)ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158922_((int)0))).step(GenerationStep.Decoration.SURFACE_STRUCTURES)).randomPlacement(34, 8)).build();

    public static void register() {
    }

    private static StructurePieceType register(String id, StructurePieceType pieceType) {
        return (StructurePieceType)Registry.m_122965_((Registry)BuiltInRegistries.f_257014_, (ResourceLocation)BetterEnd.makeID(id), (Object)pieceType);
    }

    public static void addBiomeStructures(ResourceLocation biomeID, Holder<Biome> biome) {
        if (!(biomeID.m_135827_().equals("minecraft") || biomeID.m_135827_().equals("betterend") || biomeID.m_135815_().contains("mountain") || biomeID.m_135815_().contains("lake"))) {
            TagManager.BIOMES.add(EndStructures.ETERNAL_PORTAL.biomeTag, (Object[])new Biome[]{(Biome)biome.m_203334_()});
        }
    }
}

