/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.registry;

import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityTypeBuilder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.level.levelgen.Heightmap;
import org.betterx.bclib.api.v2.spawning.SpawnRuleBuilder;
import org.betterx.bclib.entity.BCLEntityWrapper;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.config.Configs;
import org.betterx.betterend.entity.CubozoaEntity;
import org.betterx.betterend.entity.DragonflyEntity;
import org.betterx.betterend.entity.EndFishEntity;
import org.betterx.betterend.entity.EndSlimeEntity;
import org.betterx.betterend.entity.ShadowWalkerEntity;
import org.betterx.betterend.entity.SilkMothEntity;
import org.betterx.betterend.registry.EndItems;
import org.betterx.ui.ColorUtil;

public class EndEntities {
    public static final BCLEntityWrapper<DragonflyEntity> DRAGONFLY = EndEntities.register("dragonfly", MobCategory.AMBIENT, 0.6f, 0.5f, DragonflyEntity::new, DragonflyEntity.createMobAttributes(), true, ColorUtil.color((int)32, (int)42, (int)176), ColorUtil.color((int)115, (int)225, (int)249));
    public static final BCLEntityWrapper<EndSlimeEntity> END_SLIME = EndEntities.register("end_slime", MobCategory.MONSTER, 2.0f, 2.0f, EndSlimeEntity::new, EndSlimeEntity.createMobAttributes(), false, ColorUtil.color((int)28, (int)28, (int)28), ColorUtil.color((int)99, (int)11, (int)99));
    public static final BCLEntityWrapper<EndFishEntity> END_FISH = EndEntities.register("end_fish", MobCategory.WATER_AMBIENT, 0.5f, 0.5f, EndFishEntity::new, EndFishEntity.createMobAttributes(), true, ColorUtil.color((int)3, (int)50, (int)76), ColorUtil.color((int)120, (int)206, (int)255));
    public static final BCLEntityWrapper<ShadowWalkerEntity> SHADOW_WALKER = EndEntities.register("shadow_walker", MobCategory.MONSTER, 0.6f, 1.95f, ShadowWalkerEntity::new, ShadowWalkerEntity.createMobAttributes(), true, ColorUtil.color((int)30, (int)30, (int)30), ColorUtil.color((int)5, (int)5, (int)5));
    public static final BCLEntityWrapper<CubozoaEntity> CUBOZOA = EndEntities.register("cubozoa", MobCategory.WATER_AMBIENT, 0.6f, 1.0f, CubozoaEntity::new, CubozoaEntity.createMobAttributes(), true, ColorUtil.color((int)151, (int)77, (int)181), ColorUtil.color((int)93, (int)176, (int)238));
    public static final BCLEntityWrapper<SilkMothEntity> SILK_MOTH = EndEntities.register("silk_moth", MobCategory.AMBIENT, 0.6f, 0.6f, SilkMothEntity::new, SilkMothEntity.createMobAttributes(), true, ColorUtil.color((int)198, (int)138, (int)204), ColorUtil.color((int)242, (int)220, (int)236));

    public static void register() {
        SpawnRuleBuilder.start(DRAGONFLY).aboveGround(2).maxNearby(4, 32).buildNoRestrictions(Heightmap.Types.MOTION_BLOCKING);
        SpawnRuleBuilder.start(SILK_MOTH).aboveGround(2).maxNearby(4, 32).buildNoRestrictions(Heightmap.Types.MOTION_BLOCKING);
        SpawnRuleBuilder.start(END_SLIME).notPeaceful().maxNearby(6, 32).onlyOnValidBlocks().customRule(EndSlimeEntity::canSpawn).buildOnGround(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES);
        SpawnRuleBuilder.start(SHADOW_WALKER).vanillaHostile().onlyOnValidBlocks().maxNearby(8, 64).buildOnGround(Heightmap.Types.MOTION_BLOCKING);
        SpawnRuleBuilder.start(END_FISH).maxNearby(16, 16).buildInWater(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES);
        SpawnRuleBuilder.start(CUBOZOA).maxNearby(16, 16).buildInWater(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES);
    }

    protected static <T extends Entity> EntityType<T> register(String name, MobCategory group, float width, float height, EntityType.EntityFactory<T> entity) {
        ResourceLocation id = BetterEnd.makeID(name);
        EntityType type = FabricEntityTypeBuilder.create((MobCategory)group, entity).dimensions(EntityDimensions.m_20398_((float)width, (float)height)).build();
        if (Configs.ENTITY_CONFIG.getBooleanRoot(id.m_135815_(), true)) {
            return (EntityType)Registry.m_122965_((Registry)BuiltInRegistries.f_256780_, (ResourceLocation)id, (Object)type);
        }
        return type;
    }

    private static <T extends Mob> BCLEntityWrapper<T> register(String name, MobCategory group, float width, float height, EntityType.EntityFactory<T> entity, AttributeSupplier.Builder attributes, boolean fixedSize, int eggColor, int dotsColor) {
        ResourceLocation id = BetterEnd.makeID(name);
        EntityType type = FabricEntityTypeBuilder.create((MobCategory)group, entity).dimensions(fixedSize ? EntityDimensions.m_20398_((float)width, (float)height) : EntityDimensions.m_20395_((float)width, (float)height)).build();
        FabricDefaultAttributeRegistry.register((EntityType)type, (AttributeSupplier.Builder)attributes);
        EndItems.registerEndEgg("spawn_egg_" + name, (EntityType<? extends Mob>)type, eggColor, dotsColor);
        Registry.m_122965_((Registry)BuiltInRegistries.f_256780_, (ResourceLocation)BetterEnd.makeID(name), (Object)type);
        return new BCLEntityWrapper(type, Configs.ENTITY_CONFIG.getBooleanRoot(id.m_135815_(), true));
    }
}

