/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.portal;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.BlockUtil;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundChangeDifficultyPacket;
import net.minecraft.network.protocol.game.ClientboundLevelEventPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerAbilitiesPacket;
import net.minecraft.network.protocol.game.ClientboundRespawnPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.level.portal.PortalShape;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.phys.Vec3;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.advancements.BECriteria;
import org.betterx.betterend.portal.PortalBuilder;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TravelerState {
    public final Entity entity;
    private BlockPos portalEntrancePos;
    private boolean isInsidePortal;
    private int portalTime;

    public TravelerState(Entity entity) {
        this.entity = entity;
        this.portalEntrancePos = null;
        this.isInsidePortal = false;
    }

    public static TravelerState init(Entity e) {
        return new TravelerState(e);
    }

    public void handleInsidePortal(BlockPos blockPos) {
        if (this.entity.m_20092_()) {
            this.entity.m_20091_();
            return;
        }
        if (!this.level().f_46443_ && !blockPos.equals((Object)this.portalEntrancePos)) {
            this.portalEntrancePos = blockPos.m_7949_();
        }
        if (this.level().f_46443_ && this.entity instanceof LocalPlayer) {
            this.entity.f_19817_ = true;
        }
        this.isInsidePortal = true;
    }

    public Level level() {
        return this.entity.m_9236_();
    }

    @ApiStatus.Internal
    public void portalTick() {
        if (!(this.level() instanceof ServerLevel)) {
            return;
        }
        if (this.isInsidePortal) {
            int waitTimer = this.entity.m_6078_();
            ServerLevel sourceDimension = (ServerLevel)this.level();
            MinecraftServer minecraftServer = sourceDimension.m_7654_();
            ServerLevel targetDimension = minecraftServer.m_129880_(this.level().m_46472_() == Level.f_46430_ ? Level.f_46428_ : Level.f_46430_);
            if (targetDimension != null && !this.entity.m_20159_() && this.portalTime++ >= waitTimer) {
                this.level().m_46473_().m_6180_("end_portal");
                this.portalTime = waitTimer;
                this.entity.m_20091_();
                this.changeDimension(targetDimension);
                this.level().m_46473_().m_7238_();
            }
            this.isInsidePortal = false;
        } else {
            if (this.portalTime > 0) {
                this.portalTime -= 4;
            }
            if (this.portalTime < 0) {
                this.portalTime = 0;
            }
        }
    }

    @Nullable
    public void changeDimension(ServerLevel targetLevel) {
        if (!(this.level() instanceof ServerLevel) || this.entity.m_213877_()) {
            return;
        }
        this.level().m_46473_().m_6180_("be_findEntry");
        this.entity.m_19877_();
        PortalInfo portalInfo = this.findDimensionEntryPoint(targetLevel);
        if (portalInfo == null) {
            return;
        }
        this.level().m_46473_().m_6180_("be_reposition");
        this.teleportEntity(targetLevel, portalInfo);
        this.level().m_46473_().m_7238_();
        this.level().m_46473_().m_7238_();
    }

    private void teleportEntity(ServerLevel serverLevel, PortalInfo portalInfo) {
        ServerPlayer sp;
        boolean targetIsEnd = serverLevel.m_46472_().equals(Level.f_46430_);
        MinecraftServer server = serverLevel.m_7654_();
        ServerLevel destination = targetIsEnd ? server.m_129880_(Level.f_46430_) : server.m_129880_(Level.f_46428_);
        Entity entity = this.entity;
        if (entity instanceof ServerPlayer && (sp = (ServerPlayer)entity).m_7500_()) {
            sp.m_8999_(destination, portalInfo.f_77676_.f_82479_ + 0.5, portalInfo.f_77676_.f_82480_, portalInfo.f_77676_.f_82481_ + 0.5, this.entity.m_146908_() + 180.0f, this.entity.m_146909_());
            BECriteria.PORTAL_TRAVEL.m_222618_(sp);
        } else {
            Entity entity2 = this.entity;
            if (entity2 instanceof ServerPlayer) {
                ServerPlayer sp2 = (ServerPlayer)entity2;
                BECriteria.PORTAL_TRAVEL.m_222618_(sp2);
                TravelerState.travelToDimension(sp2, serverLevel, portalInfo);
            } else {
                TravelerState.sendToDimension(this.entity, serverLevel, portalInfo);
            }
            this.entity.m_20091_();
        }
    }

    public static Entity sendToDimension(Entity traveler, ServerLevel serverLevel, @NotNull PortalInfo portalInfo) {
        Level level = traveler.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel sourceDimension = (ServerLevel)level;
            if (!traveler.m_213877_()) {
                traveler.m_19877_();
                Entity copy = traveler.m_6095_().m_20615_((Level)serverLevel);
                if (copy != null) {
                    copy.m_20361_(traveler);
                    copy.m_7678_(portalInfo.f_77676_.f_82479_, portalInfo.f_77676_.f_82480_, portalInfo.f_77676_.f_82481_, portalInfo.f_77678_, copy.m_146909_());
                    copy.m_20256_(portalInfo.f_77677_);
                    serverLevel.m_143334_(copy);
                }
                traveler.m_6089_();
                sourceDimension.m_8886_();
                serverLevel.m_8886_();
                return copy;
            }
        }
        return null;
    }

    public static Entity travelToDimension(ServerPlayer traveler, ServerLevel serverLevel, @NotNull PortalInfo portalInfo) {
        LevelData levelData = serverLevel.m_6106_();
        ServerLevel sourceDimension = traveler.m_284548_();
        PlayerList playerList = traveler.f_8924_.m_6846_();
        traveler.f_8927_ = true;
        traveler.m_19877_();
        traveler.f_8906_.m_9829_((Packet)new ClientboundRespawnPacket(serverLevel.m_220362_(), serverLevel.m_46472_(), BiomeManager.m_47877_((long)serverLevel.m_7328_()), traveler.f_8941_.m_9290_(), traveler.f_8941_.m_9293_(), serverLevel.m_46659_(), serverLevel.m_8584_(), 3, traveler.m_219759_(), traveler.m_287157_()));
        traveler.f_8906_.m_9829_((Packet)new ClientboundChangeDifficultyPacket(levelData.m_5472_(), levelData.m_5474_()));
        playerList.m_11289_(traveler);
        sourceDimension.m_143261_(traveler, Entity.RemovalReason.CHANGED_DIMENSION);
        traveler.m_146912_();
        traveler.m_284127_(serverLevel);
        traveler.f_8906_.m_9953_();
        serverLevel.m_8817_(traveler);
        traveler.m_9209_(sourceDimension);
        traveler.f_8906_.m_9774_(portalInfo.f_77676_.f_82479_, portalInfo.f_77676_.f_82480_, portalInfo.f_77676_.f_82481_, portalInfo.f_77678_, portalInfo.f_77679_);
        playerList.m_11229_(traveler, serverLevel);
        playerList.m_11292_(traveler);
        traveler.f_8906_.m_9829_((Packet)new ClientboundPlayerAbilitiesPacket(traveler.m_150110_()));
        TravelerState.sendPlayerEffects(traveler);
        traveler.f_8906_.m_9829_((Packet)new ClientboundLevelEventPacket(1032, BlockPos.f_121853_, 0, false));
        traveler.f_8920_ = -1;
        traveler.f_8917_ = -1.0f;
        traveler.f_8918_ = -1;
        sourceDimension.m_8886_();
        serverLevel.m_8886_();
        return traveler;
    }

    private static void sendPlayerEffects(ServerPlayer traveler) {
        for (MobEffectInstance mobEffectInstance : traveler.m_21220_()) {
            traveler.f_8906_.m_9829_((Packet)new ClientboundUpdateMobEffectPacket(traveler.m_19879_(), mobEffectInstance));
        }
    }

    @Nullable
    private PortalInfo findDimensionEntryPoint(ServerLevel targetLevel) {
        boolean toEnd;
        boolean bl = toEnd = targetLevel.m_46472_() == Level.f_46430_;
        if (this.level().m_46472_() != Level.f_46430_ && !toEnd) {
            return null;
        }
        WorldBorder worldBorder = targetLevel.m_6857_();
        BlockPos startingPos = PortalBuilder.getStartingPos(this.level(), (Level)targetLevel, this.entity, worldBorder);
        return this.getExitPortal(targetLevel, startingPos, toEnd, worldBorder).map(foundRectangle -> {
            Vec3 vec3;
            Direction.Axis axis;
            BlockState blockState = this.level().m_8055_(this.portalEntrancePos);
            if (blockState.m_61138_((Property)BlockStateProperties.f_61364_)) {
                axis = (Direction.Axis)blockState.m_61143_((Property)BlockStateProperties.f_61364_);
                BlockUtil.FoundRectangle foundRectangle2 = BlockUtil.m_124334_((BlockPos)this.portalEntrancePos, (Direction.Axis)axis, (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, blockPos -> this.level().m_8055_(blockPos) == blockState);
                vec3 = this.getRelativePortalPosition(axis, foundRectangle2);
            } else {
                axis = Direction.Axis.X;
                vec3 = new Vec3(0.5, 0.0, 0.0);
            }
            return PortalShape.m_257966_((ServerLevel)targetLevel, (BlockUtil.FoundRectangle)foundRectangle, (Direction.Axis)axis, (Vec3)vec3, (Entity)this.entity, (Vec3)this.entity.m_20184_(), (float)this.entity.m_146908_(), (float)this.entity.m_146909_());
        }).orElse(null);
    }

    protected Optional<BlockUtil.FoundRectangle> getExitPortal(ServerLevel targetLevel, BlockPos startingPos, boolean bl, WorldBorder worldBorder) {
        PortalBuilder builder = new PortalBuilder(this.level(), targetLevel);
        Optional<BlockUtil.FoundRectangle> portalRectangle = builder.findPortalAround(startingPos, worldBorder);
        if (portalRectangle.isPresent()) {
            return portalRectangle;
        }
        BetterEnd.LOGGER.error("Unable to locate an active portal");
        return portalRectangle;
    }

    protected Vec3 getRelativePortalPosition(Direction.Axis axis, BlockUtil.FoundRectangle foundRectangle) {
        return PortalShape.m_77738_((BlockUtil.FoundRectangle)foundRectangle, (Direction.Axis)axis, (Vec3)this.entity.m_20182_(), (EntityDimensions)this.entity.m_6972_(this.entity.m_20089_()));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        TravelerState that = (TravelerState)obj;
        return Objects.equals(this.entity, that.entity) && Objects.equals(this.portalEntrancePos, that.portalEntrancePos) && this.isInsidePortal == that.isInsidePortal;
    }

    public int hashCode() {
        return Objects.hash(this.entity, this.portalEntrancePos, this.isInsidePortal);
    }

    public String toString() {
        return "TravelerState[entity=" + this.entity + ", portalEntrancePos=" + this.portalEntrancePos + ", isInsidePortal=" + this.isInsidePortal + "]";
    }
}

