/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.mixin.common;

import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.RandomSequences;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.storage.WritableLevelData;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.world.generator.GeneratorOptions;
import org.betterx.betterend.world.generator.TerrainGenerator;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerLevel.class})
public abstract class ServerLevelMixin
extends Level {
    private static final List<ResourceKey<DimensionType>> BE_TEST_DIMENSIONS = List.of(BuiltinDimensionTypes.f_223538_, BuiltinDimensionTypes.f_223541_, BuiltinDimensionTypes.f_223539_);

    protected ServerLevelMixin(WritableLevelData writableLevelData, ResourceKey<Level> resourceKey, RegistryAccess registryAccess, Holder<DimensionType> holder, Supplier<ProfilerFiller> supplier, boolean bl, boolean bl2, long l, int i) {
        super(writableLevelData, resourceKey, registryAccess, holder, supplier, bl, bl2, l, i);
    }

    @ModifyArg(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraft/core/Holder;is(Lnet/minecraft/resources/ResourceKey;)Z"))
    ResourceKey<DimensionType> be_dragonFight(ResourceKey<DimensionType> resourceKey) {
        if (!GeneratorOptions.hasDragonFights() && this.m_204156_().m_203565_(BuiltinDimensionTypes.f_223540_)) {
            return BuiltinDimensionTypes.f_223538_;
        }
        return resourceKey;
    }

    @Inject(method={"<init>*"}, at={@At(value="TAIL")})
    private void be_onServerWorldInit(MinecraftServer minecraftServer, Executor executor, LevelStorageSource.LevelStorageAccess levelStorageAccess, ServerLevelData serverLevelData, ResourceKey resourceKey, LevelStem levelStem, ChunkProgressListener chunkProgressListener, boolean bl, long seed, List list, boolean bl2, RandomSequences randomSequences, CallbackInfo ci) {
        TerrainGenerator.onServerLevelInit((ServerLevel)ServerLevel.class.cast((Object)this), levelStem, seed);
    }

    @Inject(method={"makeObsidianPlatform"}, at={@At(value="HEAD")}, cancellable=true)
    private static void be_createObsidianPlatform(ServerLevel serverLevel, CallbackInfo info) {
        TerrainGenerator.makeObsidianPlatform(serverLevel, info);
    }

    @ModifyArg(method={"tickChunk"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;setBlockAndUpdate(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Z"))
    private BlockState be_modifyTickState(BlockPos pos, BlockState state) {
        ResourceLocation biome;
        if (state.m_60713_(Blocks.f_50126_) && (biome = BiomeAPI.getBiomeID((Holder)this.m_204166_(pos))).m_135827_().equals("betterend")) {
            state = EndBlocks.EMERALD_ICE.m_49966_();
        }
        return state;
    }
}

