/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.mixin.common;

import java.util.Collection;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.interfaces.MobEffectApplier;
import org.betterx.betterend.item.CrystaliteArmor;
import org.betterx.betterend.registry.EndAttributes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class}, priority=200)
public abstract class LivingEntityMixin
extends Entity {
    private Entity lastAttacker;

    public LivingEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Shadow
    public abstract AttributeMap m_21204_();

    @Inject(method={"createLivingAttributes"}, at={@At(value="RETURN")}, cancellable=true)
    private static void be_addLivingAttributes(CallbackInfoReturnable<AttributeSupplier.Builder> info) {
        EndAttributes.addLivingEntityAttributes((AttributeSupplier.Builder)info.getReturnValue());
    }

    @Inject(method={"tickEffects"}, at={@At(value="HEAD")})
    protected void be_applyEffects(CallbackInfo info) {
        if (!this.m_9236_().m_5776_()) {
            LivingEntity owner = (LivingEntity)LivingEntity.class.cast((Object)this);
            if (CrystaliteArmor.hasFullSet(owner)) {
                CrystaliteArmor.applySetEffect(owner);
            }
            this.m_6168_().forEach(itemStack -> {
                if (itemStack.m_41720_() instanceof MobEffectApplier) {
                    ((MobEffectApplier)itemStack.m_41720_()).applyEffect(owner);
                }
            });
        }
    }

    @Inject(method={"canBeAffected"}, at={@At(value="HEAD")}, cancellable=true)
    public void be_canBeAffected(MobEffectInstance mobEffectInstance, CallbackInfoReturnable<Boolean> info) {
        try {
            if (mobEffectInstance.m_19544_() == MobEffects.f_19610_ && this.m_21204_().m_22181_(EndAttributes.BLINDNESS_RESISTANCE) > 0.0) {
                info.setReturnValue((Object)false);
            }
        }
        catch (Exception ex) {
            BetterEnd.LOGGER.warning("Blindness resistance attribute haven't been registered.", new Object[0]);
        }
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")})
    public void be_hurt(DamageSource source, float amount, CallbackInfoReturnable<Boolean> info) {
        this.lastAttacker = source.m_7639_();
    }

    @ModifyArg(method={"hurt"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;knockback(DDD)V"), index=0)
    private double be_increaseKnockback(double value, double x, double z) {
        if (this.lastAttacker != null && this.lastAttacker instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)this.lastAttacker;
            value += this.be_getKnockback(attacker.m_21205_().m_41720_());
        }
        return value;
    }

    private double be_getKnockback(Item tool) {
        if (tool == null) {
            return 0.0;
        }
        Collection modifiers = tool.m_7167_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22282_);
        if (modifiers.size() > 0) {
            return ((AttributeModifier)modifiers.iterator().next()).m_22218_();
        }
        return 0.0;
    }
}

