/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.integration.byg.features;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.phys.AABB;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.bclib.sdf.SDF;
import org.betterx.bclib.sdf.operator.SDFDisplacement;
import org.betterx.bclib.sdf.operator.SDFSubtraction;
import org.betterx.bclib.sdf.operator.SDFTranslate;
import org.betterx.bclib.sdf.operator.SDFUnion;
import org.betterx.bclib.sdf.primitive.SDFPrimitive;
import org.betterx.bclib.sdf.primitive.SDFSphere;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.bclib.util.MHelper;
import org.betterx.bclib.util.SplineHelper;
import org.betterx.betterend.integration.Integrations;
import org.betterx.betterend.noise.OpenSimplexNoise;
import org.betterx.worlds.together.tag.v3.CommonBlockTags;
import org.joml.Vector3f;

public class OldBulbisTreeFeature
extends DefaultFeature {
    private static final List<Vector3f> SPLINE = Lists.newArrayList((Object[])new Vector3f[]{new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.1f, 0.35f, 0.0f), new Vector3f(0.2f, 0.5f, 0.0f), new Vector3f(0.3f, 0.55f, 0.0f), new Vector3f(0.42f, 0.7f, 0.0f), new Vector3f(0.5f, 1.0f, 0.0f)});
    private static final List<Vector3f> ROOT = Lists.newArrayList((Object[])new Vector3f[]{new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.1f, 0.7f, 0.0f), new Vector3f(0.3f, 0.3f, 0.0f), new Vector3f(0.7f, 0.05f, 0.0f), new Vector3f(0.8f, -0.2f, 0.0f)});
    private static final List<Vector3f> LEAF;
    private static final List<Vector3f> SIDE;

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> featureConfig) {
        RandomSource random = featureConfig.m_225041_();
        BlockPos pos = featureConfig.m_159777_();
        WorldGenLevel world = featureConfig.m_159774_();
        if (!world.m_8055_(pos.m_7495_()).m_204336_(CommonBlockTags.END_STONES)) {
            return false;
        }
        if (!world.m_8055_(pos.m_6625_(4)).m_204336_(CommonBlockTags.GEN_END_STONES)) {
            return false;
        }
        BlockState stem = Integrations.BYG.getDefaultState("bulbis_stem");
        BlockState wood = Integrations.BYG.getDefaultState("bulbis_wood");
        BlockState cap = Integrations.BYG.getDefaultState(random.m_188499_() ? "bulbis_shell" : "purple_bulbis_shell");
        BlockState glow = Integrations.BYG.getDefaultState("purple_shroomlight");
        Function<BlockState, Boolean> replacement = state -> {
            if (state.equals(stem) || state.equals(wood) || state.m_204336_(CommonBlockTags.END_STONES)) {
                return true;
            }
            return BlocksHelper.replaceableOrPlant((BlockState)state);
        };
        float size = MHelper.randRange((int)10, (int)20, (RandomSource)random);
        float addSize = MHelper.randRange((float)1.0f, (float)1.7f, (RandomSource)random);
        float addRad = addSize * 0.5f + 0.5f;
        int count = (int)(size * 0.15f);
        size *= addSize;
        float var = (float)Math.PI * 2 / (float)(count * 3);
        float start = MHelper.randRange((float)0.0f, (float)((float)Math.PI * 2), (RandomSource)random);
        SDF sdf = null;
        int x1 = (pos.m_123341_() >> 4 << 4) - 16;
        int z1 = (pos.m_123343_() >> 4 << 4) - 16;
        AABB limits = new AABB((double)x1, (double)(pos.m_123342_() - 5), (double)z1, (double)(x1 + 47), (double)((float)pos.m_123342_() + size * 2.0f), (double)(z1 + 47));
        for (int i = 0; i < count; ++i) {
            float angle = (float)i / (float)count * ((float)Math.PI * 2) + MHelper.randRange((float)0.0f, (float)var, (RandomSource)random) + start;
            List spline = SplineHelper.copySpline(SPLINE);
            float sizeXZ = (size + MHelper.randRange((float)0.0f, (float)(size * 0.5f), (RandomSource)random)) * 0.7f;
            SplineHelper.scale((List)spline, (float)sizeXZ, (float)(sizeXZ * 1.5f + MHelper.randRange((float)0.0f, (float)(size * 0.5f), (RandomSource)random)), (float)sizeXZ);
            SplineHelper.offset((List)spline, (Vector3f)new Vector3f(size * random.m_188501_() * 0.3f, 0.0f, 0.0f));
            SplineHelper.rotateSpline((List)spline, (float)angle);
            SplineHelper.offsetParts((List)spline, (RandomSource)random, (float)1.0f, (float)0.0f, (float)1.0f);
            SDF branch = SplineHelper.buildSDF((List)spline, (float)(2.3f * addRad), (float)(1.3f * addRad), bpos -> stem);
            Vector3f vec = (Vector3f)spline.get(spline.size() - 1);
            float radius = (size + MHelper.randRange((float)0.0f, (float)(size * 0.5f), (RandomSource)random)) * 0.35f;
            this.bigSphere(world, pos.m_7918_((int)vec.x(), (int)vec.y(), (int)vec.z()), radius, cap, glow, wood, replacement, random);
            vec = SplineHelper.getPos((List)spline, (float)0.3f);
            this.makeRoots(world, pos.m_7918_((int)vec.x(), (int)vec.y(), (int)vec.z()), size * 0.4f + 5.0f, random, wood, replacement);
            sdf = sdf == null ? branch : new SDFUnion().setSourceA(sdf).setSourceB(branch);
        }
        sdf.setReplaceFunction(replacement).addPostProcess(info -> {
            if (!(!info.getState().equals(stem) || info.getStateUp().equals(stem) && info.getStateDown().equals(stem))) {
                return wood;
            }
            return info.getState();
        }).fillArea((ServerLevelAccessor)world, pos, limits);
        return true;
    }

    private void bigSphere(WorldGenLevel world, BlockPos pos, float radius, BlockState cap, BlockState glow, BlockState wood, Function<BlockState, Boolean> replacement, RandomSource random) {
        OpenSimplexNoise noise = new OpenSimplexNoise(random.m_188505_());
        SDFPrimitive sphere = new SDFSphere().setRadius(radius).setBlock(cap);
        SDFPrimitive sphereInner = new SDFSphere().setRadius(radius * 0.53f).setBlock(Blocks.f_50016_);
        sphereInner = new SDFDisplacement().setFunction(vec -> Float.valueOf((float)noise.eval((double)vec.x() * 0.1, (double)vec.y() * 0.1, (double)vec.z() * 0.1))).setSource((SDF)sphereInner);
        SDFPrimitive sphereGlow = new SDFSphere().setRadius(radius * 0.6f).setBlock(glow);
        sphereGlow = new SDFDisplacement().setFunction(vec -> Float.valueOf((float)noise.eval((double)vec.x() * 0.1, (double)vec.y() * 0.1, (double)vec.z() * 0.1) * 2.0f)).setSource((SDF)sphereGlow);
        sphereGlow = new SDFSubtraction().setSourceA((SDF)sphereGlow).setSourceB((SDF)sphereInner);
        sphere = new SDFSubtraction().setSourceA((SDF)sphere).setSourceB((SDF)sphereGlow);
        sphere = new SDFSubtraction().setSourceA((SDF)sphere).setSourceB((SDF)sphereInner);
        float offsetY = radius * 1.7f;
        sphere = new SDFUnion().setSourceA((SDF)sphere).setSourceB((SDF)sphereGlow);
        sphere = new SDFTranslate().setTranslate(0.0f, offsetY, 0.0f).setSource((SDF)sphere);
        int leafCount = (int)(radius * 0.5f) + 2;
        for (int i = 0; i < 4; ++i) {
            float angle = (float)i / 4.0f * ((float)Math.PI * 2);
            List spline = SplineHelper.copySpline(LEAF);
            SplineHelper.rotateSpline((List)spline, (float)angle);
            SplineHelper.scale((List)spline, (float)(radius * 1.4f));
            SplineHelper.fillSplineForce((List)spline, (WorldGenLevel)world, (BlockState)wood, (BlockPos)pos, replacement);
            for (int j = 0; j < leafCount; ++j) {
                float delta = (float)j / (float)(leafCount - 1);
                float scale = (float)Math.sin((double)delta * Math.PI) * 0.8f + 0.2f;
                float index = Mth.m_14179_((float)delta, (float)1.0f, (float)3.9f);
                Vector3f point = SplineHelper.getPos((List)spline, (float)index);
                List side = SplineHelper.copySpline(SIDE);
                SplineHelper.rotateSpline((List)side, (float)angle);
                SplineHelper.scale((List)side, (float)(scale * radius));
                BlockPos p = pos.m_7918_((int)(point.x() + 0.5f), (int)(point.y() + 0.5f), (int)(point.z() + 0.5f));
                SplineHelper.fillSplineForce((List)side, (WorldGenLevel)world, (BlockState)wood, (BlockPos)p, replacement);
            }
        }
        sphere.fillArea((ServerLevelAccessor)world, pos, new AABB(pos.m_6630_((int)offsetY)).m_82400_((double)(radius * 1.3f)));
    }

    private void makeRoots(WorldGenLevel world, BlockPos pos, float radius, RandomSource random, BlockState wood, Function<BlockState, Boolean> replacement) {
        int count = (int)(radius * 1.5f);
        for (int i = 0; i < count; ++i) {
            float angle = (float)i / (float)count * ((float)Math.PI * 2);
            float scale = radius * MHelper.randRange((float)0.85f, (float)1.15f, (RandomSource)random);
            List branch = SplineHelper.copySpline(ROOT);
            SplineHelper.rotateSpline((List)branch, (float)angle);
            SplineHelper.scale((List)branch, (float)scale);
            Vector3f last = (Vector3f)branch.get(branch.size() - 1);
            if (!world.m_8055_(pos.m_7918_((int)last.x(), (int)last.y(), (int)last.z())).m_204336_(CommonBlockTags.GEN_END_STONES)) continue;
            SplineHelper.fillSpline((List)branch, (WorldGenLevel)world, (BlockState)wood, (BlockPos)pos, replacement);
        }
    }

    static {
        SplineHelper.offset(ROOT, (Vector3f)new Vector3f(0.0f, -0.45f, 0.0f));
        LEAF = Lists.newArrayList((Object[])new Vector3f[]{new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.1f, 0.4f, 0.0f), new Vector3f(0.4f, 0.8f, 0.0f), new Vector3f(0.75f, 0.9f, 0.0f), new Vector3f(1.0f, 0.8f, 0.0f)});
        SIDE = Lists.newArrayList((Object[])new Vector3f[]{new Vector3f(0.0f, -0.3f, -0.5f), new Vector3f(0.0f, -0.1f, -0.3f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, -0.1f, 0.3f), new Vector3f(0.0f, -0.3f, 0.5f)});
    }
}

